/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.Utils;

public final class BinSet {
    private static final int NO_VALUE = 0;
    private final int mType;
    private final byte[] mSrc;
    private int[] mValues;
    private int[] mHashes;
    private int mEmpty;
    private int mSize;

    private BinSet(int type, byte[] src, int size) {
        if (size <= 0) {
            size = 4;
        }
        this.mType = type;
        this.mSrc = src;
        size = Integer.highestOneBit(size) << 2;
        this.mValues = new int[size];
        this.mHashes = new int[size >> 1];
    }

    private BinSet(byte[] src, int[] values) {
        this.mType = -1;
        this.mSrc = src;
        this.mValues = values;
        this.mHashes = new int[values.length >> 1];
    }

    private static int hash(byte[] src, int offset, int len) {
        if (src == null) {
            return 0;
        }
        int result = 1;
        for (int i = offset; i < offset + len; ++i) {
            result = 31 * result + src[i];
        }
        return result;
    }

    public boolean contains(byte[] src, IntRef srcOffsetRef) {
        int len = Decoder.decodeCborValueBounds(src, srcOffsetRef, this.mType);
        if (len < 0) {
            return false;
        }
        if (len == 0) {
            return this.mEmpty < 0;
        }
        int pos = srcOffsetRef.value - len;
        int[] values = this.mValues;
        int sz = values.length >> 1;
        int hc = BinSet.hash(src, pos, len);
        int idx = hc & sz - 1;
        int tries = 0;
        int elemPos;
        while ((elemPos = BinSet.posOf(values, idx)) != 0) {
            int elemSz = BinSet.lenOf(values, idx);
            if (elemSz == len && hc == BinSet.hashOf(this.mHashes, idx) && Utils.compareUnsigned(this.mSrc, elemPos, elemSz, src, pos, len) == 0) {
                return true;
            }
            if (++tries >= BinSet.probeLimit(sz)) {
                return false;
            }
            idx = idx + 1 & sz - 1;
        }
        return false;
    }

    private static int probeLimit(int len) {
        return 10 + (len >> 2);
    }

    private static int posOf(int[] values, int idx) {
        return values[idx << 1];
    }

    private static int lenOf(int[] values, int idx) {
        return values[(idx << 1) + 1];
    }

    private static int hashOf(int[] hashes, int idx) {
        return hashes[idx];
    }

    private static void set(int[] values, int idx, int pos, int len) {
        values[idx << 1] = pos;
        values[(idx << 1) + 1] = len;
    }

    private void resize() {
        int active = this.mSize;
        int[] values = this.mValues;
        int oldSz = values.length >> 1;
        int newSz = oldSz << 1;
        if (active >= oldSz >> 1) {
            newSz = oldSz << 2;
        }
        BinSet newSet = new BinSet(this.mSrc, new int[newSz << 1]);
        for (int idx = 0; idx < oldSz && active > 0; ++idx) {
            int pos = BinSet.posOf(values, idx);
            if (pos == 0) continue;
            newSet.add(pos, BinSet.lenOf(values, idx), BinSet.hashOf(this.mHashes, idx));
            --active;
        }
        this.mValues = newSet.mValues;
        this.mHashes = newSet.mHashes;
    }

    private boolean add(int pos, int len) {
        return this.add(pos, len, len == 0 ? 0 : BinSet.hash(this.mSrc, pos, len));
    }

    private boolean add(int pos, int len, int hashCode) {
        if (len == 0) {
            int empty = this.mEmpty;
            this.mEmpty = ~pos;
            return empty >= 0;
        }
        int[] values = this.mValues;
        int[] hashes = this.mHashes;
        int sz = values.length >> 1;
        int hc = hashCode;
        int idx = hc & sz - 1;
        int tries = 0;
        while (true) {
            int elemPos;
            if ((elemPos = BinSet.posOf(values, idx)) == 0) {
                BinSet.set(values, idx, pos, len);
                hashes[idx] = hc;
                ++this.mSize;
                return true;
            }
            if (elemPos == pos || len == BinSet.lenOf(values, idx) && hc == BinSet.hashOf(this.mHashes, idx) && Utils.compareUnsigned(this.mSrc, elemPos, len, this.mSrc, pos, len) == 0) {
                return false;
            }
            if (++tries >= BinSet.probeLimit(sz)) {
                this.resize();
                return this.add(pos, len, hc);
            }
            idx = idx + 1 & sz - 1;
        }
    }

    public static BinSet build(int type, byte[] src, IntRef srcOffsetRef, int numElements) {
        if (src == null) {
            return null;
        }
        BinSet bs = new BinSet(type, src, numElements);
        while (numElements > 0) {
            int elemLen = Decoder.decodeCborValueBounds(src, srcOffsetRef, type);
            if (elemLen < 0) {
                return null;
            }
            int elemStart = srcOffsetRef.value - elemLen;
            if (!bs.add(elemStart, elemLen)) {
                srcOffsetRef.value = Decoder.skipCborItems(src, srcOffsetRef.value, numElements - 1);
                throw new IllegalArgumentException("set contains duplicate elements");
            }
            --numElements;
        }
        return bs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BinSet{type=").append(this.mType).append(",size=").append(this.mEmpty < 0 ? this.mSize + 1 : this.mSize).append(",length=").append(this.mValues.length >> 1).append(",elements=[");
        if (this.mSize > 10) {
            sb.append("...");
        } else {
            if (this.mEmpty < 0) {
                sb.append("<empty>");
                if (this.mSize > 0) {
                    sb.append(',');
                }
            }
            byte[] src = this.mSrc;
            int[] values = this.mValues;
            int sz = values.length >> 1;
            int active = this.mSize;
            for (int idx = 0; idx < sz && active > 0; ++idx) {
                int pos = BinSet.posOf(values, idx);
                if (pos == 0) continue;
                int len = BinSet.lenOf(values, idx);
                for (int i = pos; i < pos + len; ++i) {
                    sb.append(Character.forDigit((src[i] & 0xF0) >>> 4, 16)).append(Character.forDigit(src[i] & 0xF, 16));
                }
                if (--active <= 0) continue;
                sb.append(',');
            }
        }
        sb.append("]}");
        return sb.toString();
    }
}

