/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.Utils;
import com.amazon.dax.bits.Equality;
import com.amazon.dax.bits.dynamodb.DynamoDbType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DaxCompareUtilDecoder
extends Decoder {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final BigDecimal DECIMAL_TWO = BigDecimal.valueOf(2L);

    public static int containsString(byte[] src, int srcOffset, byte[] subarr, int subarrOffset, int subarrLen, int subarrType, int fail) throws IOException {
        DynamoDbType type = DaxCompareUtilDecoder.getType(src, srcOffset);
        switch (type) {
            case String: {
                int srcLen;
                if ((subarrType & 0xE0) != 96) {
                    return fail;
                }
                IntRef srcOffsetRef = new IntRef(srcOffset);
                try {
                    srcLen = DaxCompareUtilDecoder.decodeCborValueBounds(src, srcOffsetRef, 96);
                }
                catch (IllegalArgumentException e) {
                    return fail;
                }
                if (srcLen < 0) {
                    return fail;
                }
                if (subarrLen > srcLen) {
                    return -1;
                }
                return DaxCompareUtilDecoder.subArrayIndex(src, srcOffsetRef.value - srcLen, srcLen, subarr, subarrOffset, subarrLen) == -1 ? -1 : 0;
            }
            case StringSet: {
                if (type == DynamoDbType.StringSet && (subarrType & 0xE0) != 96) {
                    return fail;
                }
            }
            case BinarySet: {
                if (type == DynamoDbType.BinarySet && (subarrType & 0xE0) != 64) {
                    return fail;
                }
            }
            case List: {
                IntRef setSrcOffsetRef = new IntRef(srcOffset);
                int size = DaxCompareUtilDecoder.decodeCborSize(src, setSrcOffsetRef, fail);
                if (size < 0 || size == fail) {
                    return fail;
                }
                while (size-- > 0) {
                    if (DaxCompareUtilDecoder.compareCborValue(src, setSrcOffsetRef, subarr, subarrOffset, subarrLen, subarrType, fail) != 0) continue;
                    return 0;
                }
                return -1;
            }
        }
        return fail;
    }

    public static int containsCbor(byte[] src, int srcOffset, byte[] subarr, int subarrOffset, int fail) throws IOException {
        DynamoDbType srcType = DaxCompareUtilDecoder.getType(src, srcOffset);
        DynamoDbType subType = DaxCompareUtilDecoder.getType(subarr, subarrOffset);
        int retVal = fail;
        switch (srcType) {
            case String: {
                int subLen;
                int srcLen;
                if (subType != DynamoDbType.String) {
                    return fail;
                }
                IntRef srcOffsetRef = new IntRef(srcOffset);
                try {
                    srcLen = DaxCompareUtilDecoder.decodeCborValueBounds(src, srcOffsetRef, 96);
                }
                catch (IllegalArgumentException e) {
                    return fail;
                }
                if (srcLen < 0) {
                    return fail;
                }
                IntRef subOffsetRef = new IntRef(subarrOffset);
                try {
                    subLen = DaxCompareUtilDecoder.decodeCborValueBounds(subarr, subOffsetRef, 96);
                }
                catch (IllegalArgumentException e) {
                    return fail;
                }
                if (subLen > srcLen) {
                    return -1;
                }
                retVal = DaxCompareUtilDecoder.subArrayIndex(src, srcOffsetRef.value - srcLen, srcLen, subarr, subOffsetRef.value - subLen, subLen) == -1 ? -1 : 0;
                break;
            }
            case NumberSet: {
                if (srcType == DynamoDbType.NumberSet && subType != DynamoDbType.Number) {
                    return fail;
                }
            }
            case StringSet: {
                if (srcType == DynamoDbType.StringSet && subType != DynamoDbType.String) {
                    return fail;
                }
            }
            case BinarySet: {
                if (srcType == DynamoDbType.BinarySet && subType != DynamoDbType.Binary) {
                    return fail;
                }
            }
            case List: {
                IntRef listSrcOffsetRef = new IntRef(srcOffset);
                int size = DaxCompareUtilDecoder.decodeCborSize(src, listSrcOffsetRef, -1);
                if (size < 0) {
                    return fail;
                }
                while (size-- > 0) {
                    if (Equality.cborEquals(src, listSrcOffsetRef.value, subarr, subarrOffset)) {
                        return 0;
                    }
                    listSrcOffsetRef.value = DaxCompareUtilDecoder.skipCborItem(src, listSrcOffsetRef.value);
                }
                retVal = -1;
                break;
            }
            default: {
                retVal = fail;
            }
        }
        return retVal;
    }

    public static int containsLong(byte[] src, int srcOffset, long value, int fail) throws IOException {
        DynamoDbType type = DaxCompareUtilDecoder.getType(src, srcOffset);
        if (type != DynamoDbType.NumberSet && type != DynamoDbType.List) {
            return fail;
        }
        IntRef srcOffsetRef = new IntRef(srcOffset);
        int size = DaxCompareUtilDecoder.decodeCborSize(src, srcOffsetRef, -1);
        if (size < 0) {
            return fail;
        }
        while (size-- > 0) {
            if (DaxCompareUtilDecoder.compareCborLong(src, srcOffsetRef.value, value, value + 1L) == value) {
                return 0;
            }
            srcOffsetRef.value = DaxCompareUtilDecoder.skipCborItem(src, srcOffsetRef.value);
        }
        return -1;
    }

    public static int containsDouble(byte[] src, int srcOffset, double value, int fail) throws IOException {
        DynamoDbType type = DaxCompareUtilDecoder.getType(src, srcOffset);
        if (type != DynamoDbType.NumberSet && type != DynamoDbType.List) {
            return fail;
        }
        IntRef srcOffsetRef = new IntRef(srcOffset);
        int size = DaxCompareUtilDecoder.decodeCborSize(src, srcOffsetRef, -1);
        if (size < 0) {
            return fail;
        }
        while (size-- > 0) {
            if (DaxCompareUtilDecoder.compareCborDouble(src, srcOffsetRef.value, value, 1) == 0) {
                return 0;
            }
            srcOffsetRef.value = DaxCompareUtilDecoder.skipCborItem(src, srcOffsetRef.value);
        }
        return -1;
    }

    public static int containsBigDecimal(byte[] src, int srcOffset, BigDecimal value, int fail) throws IOException {
        DynamoDbType type = DaxCompareUtilDecoder.getType(src, srcOffset);
        if (type != DynamoDbType.NumberSet && type != DynamoDbType.List) {
            return fail;
        }
        IntRef srcOffsetRef = new IntRef(srcOffset);
        int size = DaxCompareUtilDecoder.decodeCborSize(src, srcOffsetRef, -1);
        if (size < 0) {
            return fail;
        }
        while (size-- > 0) {
            if (DaxCompareUtilDecoder.compareCborBigDecimal(src, srcOffsetRef.value, value, 1) == 0) {
                return 0;
            }
            srcOffsetRef.value = DaxCompareUtilDecoder.skipCborItem(src, srcOffsetRef.value);
        }
        return -1;
    }

    public static int compareCborType(byte[] src, int offset, byte[] typeDef, int typeDefOffset, int typeDefLen, int fail) throws IOException {
        DynamoDbType type = DaxCompareUtilDecoder.getType(src, offset);
        if (type == DynamoDbType.Unknown) {
            return fail;
        }
        byte[] attrType = type.getTypeDefBytes();
        return Utils.compareUnsigned(attrType, 0, attrType.length, typeDef, typeDefOffset, typeDefLen);
    }

    public static int compareCbor(byte[] first, int firstOffset, byte[] second, int secondOffset, int fail) throws IOException {
        DynamoDbType secondType;
        if (first == null || second == null || firstOffset < 0 || secondOffset < 0) {
            return fail;
        }
        DynamoDbType firstType = DaxCompareUtilDecoder.getType(first, firstOffset);
        if (firstType != (secondType = DaxCompareUtilDecoder.getType(second, secondOffset))) {
            return fail;
        }
        switch (firstType) {
            case Number: {
                return DaxCompareUtilDecoder.compareCborNumber(first, firstOffset, second, secondOffset, fail);
            }
            case String: 
            case Binary: {
                IntRef firstOffsetRef = new IntRef(firstOffset);
                IntRef secondOffsetRef = new IntRef(secondOffset);
                try {
                    int type = firstType == DynamoDbType.Binary ? 64 : 96;
                    int firstLen = DaxCompareUtilDecoder.decodeCborValueBounds(first, firstOffsetRef, type);
                    int secondLen = DaxCompareUtilDecoder.decodeCborValueBounds(second, secondOffsetRef, type);
                    return Utils.compareUnsigned(first, firstOffsetRef.value - firstLen, firstLen, second, secondOffsetRef.value - secondLen, secondLen);
                }
                catch (IllegalArgumentException e) {
                    return fail;
                }
            }
            case Null: {
                return 0;
            }
            case StringSet: 
            case BinarySet: 
            case List: 
            case NumberSet: 
            case Bool: 
            case Map: {
                return Equality.cborEquals(first, firstOffset, second, secondOffset) ? 0 : fail;
            }
        }
        return fail;
    }

    private static int subArrayIndex(byte[] src, int srcOffset, int srcLen, byte[] sub, int subOffset, int subLen) {
        int j;
        if (subLen == 0) {
            return 1;
        }
        if (subLen > srcLen) {
            return -1;
        }
        int[] prefixTable = new int[subLen];
        int j2 = 0;
        prefixTable[0] = -1;
        for (int i = 1; i < prefixTable.length; ++i) {
            prefixTable[i] = sub[subOffset + i] != sub[subOffset + j2] ? j2 : prefixTable[j2];
            while (j2 >= 0 && sub[subOffset + i] != sub[subOffset + j2]) {
                j2 = prefixTable[j2];
            }
            ++j2;
        }
        int i = 0;
        for (j = 0; i < srcLen && j < subLen; ++j, ++i) {
            while (j >= 0 && src[srcOffset + i] != sub[subOffset + j]) {
                j = prefixTable[j];
            }
        }
        if (j == subLen) {
            return srcOffset + i - subLen;
        }
        return -1;
    }

    public static long compareCborLong(byte[] src, int srcOffset, long value, long fail) {
        double da;
        long attrValue;
        int b;
        block23: while (true) {
            b = src[srcOffset++] & 0xFF;
            attrValue = 0L;
            switch (b & 0x1F) {
                default: {
                    attrValue = b & 0x1F;
                    break;
                }
                case 27: {
                    attrValue = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                    if (attrValue < 0L) {
                        if (b == 27) {
                            return value + 1L;
                        }
                        if (b == 59) {
                            return value - 1L;
                        }
                    }
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16 | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 26: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16 | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 25: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 24: {
                    attrValue |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 6: {
                    int tag = (int)attrValue;
                    if ((long)tag != attrValue) continue block23;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(DaxCompareUtilDecoder.decodeCborBytes(tag, src, new IntRef(srcOffset)));
                            return value + (long)bi.compareTo(BigInteger.valueOf(value));
                        }
                        case 4: 
                        case 5: {
                            BigDecimal bd = DaxCompareUtilDecoder.decodeCborBigDecimal(tag, src, new IntRef(srcOffset));
                            return value + (long)bd.compareTo(BigDecimal.valueOf(value));
                        }
                    }
                    continue block23;
                }
                case 1: {
                    return attrValue ^ 0xFFFFFFFFFFFFFFFFL;
                }
                case 0: {
                    return attrValue;
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                return fail;
            }
            case 22: {
                return value + 1L;
            }
            case 25: {
                da = DaxCompareUtilDecoder.float16to32((int)attrValue);
                break;
            }
            case 26: {
                da = Float.intBitsToFloat((int)attrValue);
                break;
            }
            case 27: {
                da = Double.longBitsToDouble(attrValue);
            }
        }
        double dv = value;
        if (value == (long)dv) {
            return value + (long)Long.compare(DaxCompareUtilDecoder.doubleCompareBits(da), DaxCompareUtilDecoder.doubleCompareBits(dv));
        }
        if (DaxCompareUtilDecoder.isInfinityOrNaN(da)) {
            return Double.doubleToRawLongBits(da) < 0L ? value - 1L : value + 1L;
        }
        return value + (long)BigDecimal.valueOf(da).compareTo(BigDecimal.valueOf(value));
    }

    public static int compareCborDouble(byte[] src, int srcOffset, double value, int fail) {
        double da;
        long attrValue;
        int b;
        block23: while (true) {
            b = src[srcOffset++] & 0xFF;
            attrValue = 0L;
            switch (b & 0x1F) {
                default: {
                    attrValue = b & 0x1F;
                    break;
                }
                case 27: {
                    attrValue = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32 | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16 | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 26: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16 | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 25: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 8 | (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 24: {
                    attrValue |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 6: {
                    int tag = (int)attrValue;
                    if ((long)tag != attrValue) continue block23;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(DaxCompareUtilDecoder.decodeCborBytes(tag, src, new IntRef(srcOffset)));
                            return DaxCompareUtilDecoder.compare(new BigDecimal(bi, 0), value);
                        }
                        case 4: 
                        case 5: {
                            return DaxCompareUtilDecoder.compare(DaxCompareUtilDecoder.decodeCborBigDecimal(tag, src, new IntRef(srcOffset)), value);
                        }
                    }
                    continue block23;
                }
                case 1: {
                    long bits = Double.doubleToRawLongBits(value);
                    if ((attrValue & 0xFFE0000000000000L) != 0L) {
                        if (bits >= 0L) {
                            return -1;
                        }
                        if ((bits | 0x800FFFFFFFFFFFFFL) == -1L) {
                            return Long.compare(0L, DaxCompareUtilDecoder.fixBits(bits));
                        }
                        int attrExp = 63 - Long.numberOfLeadingZeros(attrValue);
                        int valueExp = Math.getExponent(value);
                        int result = valueExp - attrExp;
                        if (result < -1 | result > 1) {
                            return result;
                        }
                        return DaxCompareUtilDecoder.compare(new BigDecimal(DaxCompareUtilDecoder.decodeNegativeBigInteger(attrValue)), value);
                    }
                    return Long.compare(DaxCompareUtilDecoder.doubleCompareBits(attrValue ^ 0xFFFFFFFFFFFFFFFFL), DaxCompareUtilDecoder.fixBits(bits));
                }
                case 0: {
                    long bits = Double.doubleToRawLongBits(value);
                    if ((attrValue & 0xFFE0000000000000L) != 0L) {
                        int valueExp;
                        if (bits < 0L) {
                            return 1;
                        }
                        if ((bits | 0x800FFFFFFFFFFFFFL) == -1L) {
                            return Long.compare(0L, DaxCompareUtilDecoder.fixBits(bits));
                        }
                        int attrExp = 63 - Long.numberOfLeadingZeros(attrValue);
                        int result = attrExp - (valueExp = Math.getExponent(value));
                        if (result < -1 | result > 1) {
                            return result;
                        }
                        return DaxCompareUtilDecoder.compare(new BigDecimal(DaxCompareUtilDecoder.decodePositiveBigInteger(attrValue)), value);
                    }
                    return Long.compare(DaxCompareUtilDecoder.doubleCompareBits(attrValue), DaxCompareUtilDecoder.fixBits(bits));
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                return fail;
            }
            case 22: {
                return 1;
            }
            case 25: {
                da = DaxCompareUtilDecoder.float16to32((int)attrValue);
                break;
            }
            case 26: {
                da = Float.intBitsToFloat((int)attrValue);
                break;
            }
            case 27: {
                return Long.compare(DaxCompareUtilDecoder.fixBits(attrValue), DaxCompareUtilDecoder.doubleCompareBits(value));
            }
        }
        return Long.compare(DaxCompareUtilDecoder.doubleCompareBits(da), DaxCompareUtilDecoder.doubleCompareBits(value));
    }

    /*
     * Unable to fully structure code
     */
    public static int compareCborBigDecimal(byte[] src, int srcOffset, BigDecimal value, int fail) {
        if (value == null) {
            return (src[srcOffset] & 255) == 246 ? 0 : -1;
        }
        block21: while (true) {
            b = src[srcOffset++] & 255;
            field = 0L;
            switch (b & 31) {
                default: {
                    field = b & 31;
                    break;
                }
                case 27: {
                    field = ((long)src[srcOffset++] & 255L) << 56 | ((long)src[srcOffset++] & 255L) << 48 | ((long)src[srcOffset++] & 255L) << 40 | ((long)src[srcOffset++] & 255L) << 32 | ((long)src[srcOffset++] & 255L) << 24 | ((long)src[srcOffset++] & 255L) << 16 | ((long)src[srcOffset++] & 255L) << 8 | (long)src[srcOffset++] & 255L;
                    break;
                }
                case 26: {
                    field = field | ((long)src[srcOffset++] & 255L) << 24 | ((long)src[srcOffset++] & 255L) << 16 | ((long)src[srcOffset++] & 255L) << 8 | (long)src[srcOffset++] & 255L;
                    break;
                }
                case 25: {
                    field = field | ((long)src[srcOffset++] & 255L) << 8 | (long)src[srcOffset++] & 255L;
                    break;
                }
                case 24: {
                    field |= (long)src[srcOffset++] & 255L;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 0: {
                    bd = new BigDecimal(DaxCompareUtilDecoder.decodePositiveBigInteger(field));
                    break block21;
                }
                case 1: {
                    bd = new BigDecimal(DaxCompareUtilDecoder.decodeNegativeBigInteger(field));
                    break block21;
                }
                case 6: {
                    if (field < 2L) continue block21;
                    if (field <= 3L) {
                        bi = new BigInteger(DaxCompareUtilDecoder.decodeCborBytes((int)field, src, new IntRef(srcOffset)));
                        bd = new BigDecimal(bi);
                        break block21;
                    }
                    if (field <= 5L) ** break;
                    continue block21;
                    bd = DaxCompareUtilDecoder.decodeCborBigDecimal((int)field, src, new IntRef(srcOffset));
                    break block21;
                }
                case 7: {
                    try {
                        switch (b & 31) {
                            default: {
                                return fail;
                            }
                            case 22: {
                                return 1;
                            }
                            case 25: {
                                ifield = (int)field;
                                if ((ifield | -31745) == -1) {
                                    if (ifield < 0) {
                                        ifield ^= 32767;
                                    }
                                    return Short.compare((short)ifield, (short)0);
                                }
                                f = DaxCompareUtilDecoder.float16to32(ifield);
                                if ((ifield & 32767) == 0) {
                                    return Float.compare(f, value.signum());
                                }
                                bd = BigDecimal.valueOf(f);
                                break block21;
                            }
                            case 26: {
                                ifield = (int)field;
                                if ((ifield | -2139095041) == -1) {
                                    if (ifield < 0) {
                                        ifield ^= 0x7FFFFFFF;
                                    }
                                    return Integer.compare(ifield, 0);
                                }
                                f = Float.intBitsToFloat(ifield);
                                if ((ifield & 0x7FFFFFFF) == 0) {
                                    return Float.compare(f, value.signum());
                                }
                                bd = BigDecimal.valueOf(f);
                                break block21;
                            }
                            case 27: 
                        }
                        if ((field | -9218868437227405313L) == -1L) {
                            return Long.compare(DaxCompareUtilDecoder.fixBits(field), 0L);
                        }
                        d = Double.longBitsToDouble(field);
                        if ((field & 0x7FFFFFFFFFFFFFFFL) == 0L) {
                            return Double.compare(d, value.signum());
                        }
                        bd = BigDecimal.valueOf(d);
                        break block21;
                    }
                    catch (NumberFormatException e) {
                        return fail;
                    }
                }
            }
            break;
        }
        return bd.compareTo(value);
    }

    public static int compareCborValue(byte[] src, int srcOffset, byte[] value, int valueOffset, int valueLen, int type, int fail) {
        return DaxCompareUtilDecoder.compareCborValue(src, new IntRef(srcOffset), value, valueOffset, valueLen, type, fail);
    }

    public static int compareCborValue(byte[] src, IntRef srcOffsetRef, byte[] value, int valueOffset, int valueLen, int type, int fail) {
        int len;
        try {
            len = DaxCompareUtilDecoder.decodeCborValueBounds(src, srcOffsetRef, type);
        }
        catch (IllegalArgumentException e) {
            return fail;
        }
        if (len < 0) {
            return fail;
        }
        return Utils.compareUnsigned(src, srcOffsetRef.value - len, len, value, valueOffset, valueLen);
    }

    private static DynamoDbType getType(byte[] src, int offset) {
        DynamoDbType type = DynamoDbType.Unknown;
        long value = 0L;
        int b = src[offset++] & 0xFF;
        switch (b & 0x1F) {
            default: {
                value = b & 0x1F;
                break;
            }
            case 27: {
                value = ((long)src[offset++] & 0xFFL) << 56 | ((long)src[offset++] & 0xFFL) << 48 | ((long)src[offset++] & 0xFFL) << 40 | ((long)src[offset++] & 0xFFL) << 32 | ((long)src[offset++] & 0xFFL) << 24 | ((long)src[offset++] & 0xFFL) << 16 | ((long)src[offset++] & 0xFFL) << 8 | (long)src[offset++] & 0xFFL;
                break;
            }
            case 26: {
                value = value | ((long)src[offset++] & 0xFFL) << 24 | ((long)src[offset++] & 0xFFL) << 16 | ((long)src[offset++] & 0xFFL) << 8 | (long)src[offset++] & 0xFFL;
                break;
            }
            case 25: {
                value = value | ((long)src[offset++] & 0xFFL) << 8 | (long)src[offset++] & 0xFFL;
                break;
            }
            case 24: {
                value |= (long)src[offset++] & 0xFFL;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return DynamoDbType.Unknown;
            }
        }
        block7 : switch (b >> 5) {
            case 0: 
            case 1: {
                type = DynamoDbType.Number;
                break;
            }
            case 2: {
                type = DynamoDbType.Binary;
                break;
            }
            case 3: {
                type = DynamoDbType.String;
                break;
            }
            case 4: {
                type = DynamoDbType.List;
                break;
            }
            case 5: {
                type = DynamoDbType.Map;
                break;
            }
            case 7: {
                switch (b) {
                    case 244: 
                    case 245: {
                        type = DynamoDbType.Bool;
                        break block7;
                    }
                    case 246: {
                        type = DynamoDbType.Null;
                        break block7;
                    }
                    case 249: 
                    case 250: 
                    case 251: {
                        type = DynamoDbType.Number;
                        break block7;
                    }
                }
                return DynamoDbType.Unknown;
            }
            case 6: {
                int ivalue = (int)value;
                if ((long)ivalue != value) {
                    return DynamoDbType.Unknown;
                }
                switch ((int)value) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        type = DynamoDbType.Number;
                        break block7;
                    }
                    case 3321: {
                        type = DynamoDbType.StringSet;
                        break block7;
                    }
                    case 3322: {
                        type = DynamoDbType.NumberSet;
                        break block7;
                    }
                    case 3323: {
                        type = DynamoDbType.BinarySet;
                        break block7;
                    }
                }
                return DynamoDbType.Unknown;
            }
            default: {
                return DynamoDbType.Unknown;
            }
        }
        return type;
    }

    private static int compareCborNumber(byte[] first, int firstOffset, byte[] second, int secondOffset, int fail) {
        if (first == null || second == null || firstOffset < 0 || secondOffset < 0) {
            return fail;
        }
        block22: while (true) {
            int type = second[secondOffset++] & 0xFF;
            long value = 0L;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)second[secondOffset++] & 0xFFL) << 56 | ((long)second[secondOffset++] & 0xFFL) << 48 | ((long)second[secondOffset++] & 0xFFL) << 40 | ((long)second[secondOffset++] & 0xFFL) << 32 | ((long)second[secondOffset++] & 0xFFL) << 24 | ((long)second[secondOffset++] & 0xFFL) << 16 | ((long)second[secondOffset++] & 0xFFL) << 8 | (long)second[secondOffset++] & 0xFFL;
                    break;
                }
                case 26: {
                    value |= ((long)second[secondOffset++] & 0xFFL) << 24 | ((long)second[secondOffset++] & 0xFFL) << 16 | ((long)second[secondOffset++] & 0xFFL) << 8 | (long)second[secondOffset++] & 0xFFL;
                    break;
                }
                case 25: {
                    value |= ((long)second[secondOffset++] & 0xFFL) << 8 | (long)second[secondOffset++] & 0xFFL;
                    break;
                }
                case 24: {
                    value |= (long)second[secondOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    throw new IllegalStateException("illegal type: " + type);
                }
            }
            switch (type >> 5) {
                case 1: {
                    return Long.compare(DaxCompareUtilDecoder.compareCborLong(first, firstOffset, value ^= 0xFFFFFFFFFFFFFFFFL, fail), value);
                }
                case 0: {
                    return Long.compare(DaxCompareUtilDecoder.compareCborLong(first, firstOffset, value, fail), value);
                }
                case 7: {
                    double da;
                    switch (type & 0x1F) {
                        default: {
                            return fail;
                        }
                        case 25: {
                            da = DaxCompareUtilDecoder.float16to32((int)value);
                            break;
                        }
                        case 26: {
                            da = Float.intBitsToFloat((int)value);
                            break;
                        }
                        case 27: {
                            da = Double.longBitsToDouble(value);
                        }
                    }
                    return DaxCompareUtilDecoder.compareCborDouble(first, firstOffset, da, fail);
                }
                case 6: {
                    long tag;
                    int itag;
                    if ((long)(itag = (int)(tag = value)) != tag) continue block22;
                    switch (itag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(DaxCompareUtilDecoder.decodeCborBytes((int)value, second, new IntRef(secondOffset)));
                            return DaxCompareUtilDecoder.compareCborBigDecimal(first, firstOffset, new BigDecimal(bi), fail);
                        }
                        case 4: 
                        case 5: {
                            BigDecimal bd = DaxCompareUtilDecoder.decodeCborBigDecimal((int)value, second, new IntRef(secondOffset));
                            return DaxCompareUtilDecoder.compareCborBigDecimal(first, firstOffset, bd, fail);
                        }
                    }
                    return fail;
                }
            }
            break;
        }
        return fail;
    }
}

