/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import java.util.concurrent.CountDownLatch;

public class LazyClock {
    private static final int DEFAULT_DELAY = 10;
    private static volatile LazyClock mInstance;
    private volatile long mCurrTime;
    long p00;
    long p01;
    long p02;
    long p03;
    long p04;

    public long getCurrentTime() {
        return this.mCurrTime;
    }

    protected LazyClock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LazyClock instance() {
        if (mInstance != null) return mInstance;
        Class<LazyClock> clazz = LazyClock.class;
        synchronized (LazyClock.class) {
            if (mInstance != null) return mInstance;
            mInstance = LazyClock.custom(10L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static LazyClock custom(long delay) {
        LazyClock clock = new LazyClock();
        CountDownLatch started = new CountDownLatch(1);
        LazyClockUpdater clockThread = new LazyClockUpdater(clock, delay, started);
        clockThread.start();
        try {
            started.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return clock;
    }

    protected static class LazyClockUpdater
    extends Thread {
        private final LazyClock mClock;
        private final long mDelay;
        private final CountDownLatch mStarted;

        public LazyClockUpdater(LazyClock clock, long delay, CountDownLatch started) {
            this.mClock = clock;
            this.mDelay = delay;
            this.mStarted = started;
            this.setDaemon(true);
            this.setName("DaxLazyClock-" + delay);
        }

        @Override
        public void run() {
            this.mClock.mCurrTime = System.currentTimeMillis();
            this.mStarted.countDown();
            while (true) {
                this.mClock.mCurrTime = System.currentTimeMillis();
                try {
                    Thread.sleep(this.mDelay);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

