/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public final class NumSet {
    private static final BigInteger NEGINT = BigInteger.valueOf(-1L).shiftLeft(64);
    private LongSet mLongs;
    private Set<Number> mNums;

    public NumSet(int sizeHint) {
        this.mLongs = new LongSet(sizeHint <= 0 ? 4 : sizeHint);
    }

    public int size() {
        return this.mLongs != null ? this.mLongs.size() : this.mNums.size();
    }

    boolean add(long v) {
        if (this.mLongs != null) {
            return this.mLongs.add(v);
        }
        return this.mNums.add(v);
    }

    boolean contains(long v) {
        if (this.mLongs != null) {
            return this.mLongs.contains(v);
        }
        return this.mNums.contains(v);
    }

    boolean contains(double v) {
        long lv = (long)v;
        if (v == (double)lv) {
            return this.contains(lv);
        }
        if (this.mLongs != null) {
            return false;
        }
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            return this.mNums.contains(v);
        }
        return this.mNums.contains(BigDecimal.valueOf(v));
    }

    boolean add(double v) {
        long lv = (long)v;
        if (v == (double)lv) {
            return this.add(lv);
        }
        if (this.mLongs != null) {
            this.promote();
        }
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            return this.mNums.add(v);
        }
        return this.mNums.add(BigDecimal.valueOf(v));
    }

    boolean contains(BigInteger v) {
        if (v.bitLength() <= 63) {
            return this.contains(Utils.longValueExact(v));
        }
        if (this.mLongs != null) {
            return false;
        }
        return this.mNums.contains(new BigDecimal(v));
    }

    boolean add(BigInteger v) {
        int bitlen = v.bitLength();
        if (bitlen <= 63) {
            return this.add(Utils.longValueExact(v));
        }
        if (this.mLongs != null) {
            this.promote();
        }
        return this.mNums.add(new BigDecimal(v));
    }

    boolean add(BigDecimal v) {
        try {
            return this.add(v.longValueExact());
        }
        catch (ArithmeticException e) {
            if (this.mLongs != null) {
                this.promote();
            }
            return this.mNums.add(v);
        }
    }

    boolean contains(BigDecimal v) {
        try {
            return this.contains(v.longValueExact());
        }
        catch (ArithmeticException e) {
            if (this.mLongs != null) {
                return false;
            }
            return this.mNums.contains(v);
        }
    }

    boolean allLongs() {
        return this.mLongs != null;
    }

    private void promote() {
        LongSet longs = this.mLongs;
        int active = longs.mSize;
        this.mNums = new HashSet<Number>(active);
        long[] values = longs.mValues;
        int idx = 0;
        while (idx < values.length && active > 0) {
            long v;
            if ((v = values[idx++]) == 0L) continue;
            this.mNums.add(v);
            --active;
        }
        if (longs.mZero) {
            this.mNums.add(0L);
        }
        this.mLongs = null;
    }

    public boolean contains(byte[] src, IntRef srcOffsetRef) {
        double d;
        long value;
        int b;
        int srcOffset = srcOffsetRef.value;
        block21: while (true) {
            b = src[srcOffset++] & 0xFF;
            value = 0L;
            switch (b & 0x1F) {
                default: {
                    value = b & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value = value | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)src[srcOffset++] & 0xFFL;
                }
            }
            switch (b >> 5) {
                default: {
                    srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                    return false;
                }
                case 6: {
                    int tag = (int)value;
                    if ((long)tag != value) continue block21;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            srcOffsetRef.value = srcOffset;
                            BigInteger bi = new BigInteger(Decoder.decodeCborBytes(tag, src, srcOffsetRef));
                            return this.contains(bi);
                        }
                        case 4: 
                        case 5: {
                            srcOffsetRef.value = srcOffset;
                            BigDecimal bd = Decoder.decodeCborBigDecimal(tag, src, srcOffsetRef);
                            return this.contains(bd);
                        }
                    }
                    continue block21;
                }
                case 0: {
                    srcOffsetRef.value = srcOffset;
                    if (value >= 0L) {
                        return this.contains(value);
                    }
                    if (this.mLongs != null) {
                        return false;
                    }
                    return this.contains(BigInteger.valueOf(value ^ Long.MIN_VALUE).setBit(63));
                }
                case 1: {
                    srcOffsetRef.value = srcOffset;
                    long v = value ^ 0xFFFFFFFFFFFFFFFFL;
                    if (v < 0L) {
                        return this.contains(v);
                    }
                    if (this.mLongs != null) {
                        return false;
                    }
                    return this.contains(NEGINT.or(BigInteger.valueOf(v)));
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                return false;
            }
            case 25: {
                d = Decoder.float16to32((int)value);
                break;
            }
            case 26: {
                d = Float.intBitsToFloat((int)value);
                break;
            }
            case 27: {
                d = Double.longBitsToDouble(value);
            }
        }
        srcOffsetRef.value = srcOffset;
        return this.contains(d);
    }

    public int add(byte[] src, IntRef srcOffsetRef) {
        double d;
        long value;
        int b;
        int srcOffset = srcOffsetRef.value;
        block21: while (true) {
            b = src[srcOffset++] & 0xFF;
            value = 0L;
            switch (b & 0x1F) {
                default: {
                    value = b & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value = value | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)src[srcOffset++] & 0xFFL;
                }
            }
            switch (b >> 5) {
                default: {
                    srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                    return ~srcOffsetRef.value;
                }
                case 6: {
                    int tag = (int)value;
                    if ((long)tag != value) continue block21;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            srcOffsetRef.value = srcOffset;
                            BigInteger bi = new BigInteger(Decoder.decodeCborBytes(tag, src, srcOffsetRef));
                            return this.add(bi) ? srcOffsetRef.value : 0;
                        }
                        case 4: 
                        case 5: {
                            srcOffsetRef.value = srcOffset;
                            BigDecimal bd = Decoder.decodeCborBigDecimal(tag, src, srcOffsetRef);
                            return this.add(bd) ? srcOffsetRef.value : 0;
                        }
                    }
                    continue block21;
                }
                case 0: {
                    srcOffsetRef.value = srcOffset;
                    if (value >= 0L) {
                        return this.add(value) ? srcOffsetRef.value : 0;
                    }
                    BigInteger bi = BigInteger.valueOf(value ^ Long.MIN_VALUE).setBit(63);
                    return this.add(bi) ? srcOffsetRef.value : 0;
                }
                case 1: {
                    srcOffsetRef.value = srcOffset;
                    long v = value ^ 0xFFFFFFFFFFFFFFFFL;
                    if (v < 0L) {
                        return this.add(v) ? srcOffsetRef.value : 0;
                    }
                    return this.add(NEGINT.or(BigInteger.valueOf(v))) ? srcOffsetRef.value : 0;
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                return ~srcOffsetRef.value;
            }
            case 25: {
                d = Decoder.float16to32((int)value);
                break;
            }
            case 26: {
                d = Float.intBitsToFloat((int)value);
                break;
            }
            case 27: {
                d = Double.longBitsToDouble(value);
            }
        }
        srcOffsetRef.value = srcOffset;
        return this.add(d) ? srcOffsetRef.value : 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "NumSet{size=0}";
        }
        StringBuilder sb = new StringBuilder("NumSet{size=").append(this.size()).append(',');
        if (this.mLongs != null) {
            long[] vals = this.mLongs.mValues;
            int rem = this.mLongs.mSize;
            if (this.mLongs.mZero) {
                sb.append('0');
                if (rem > 0) {
                    sb.append(',');
                }
            }
            for (int i = 0; i < vals.length && rem > 0; ++i) {
                if (vals[i] == 0L) continue;
                sb.append(vals[i]);
                if (--rem <= 0) continue;
                sb.append(',');
            }
        } else {
            boolean first = true;
            for (Number n : this.mNums) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(n);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class LongSet {
        private static final long NO_VALUE = 0L;
        private long[] mValues;
        private boolean mZero;
        private int mSize;

        private LongSet(int size) {
            size = Integer.highestOneBit(size) << 1;
            this.mValues = new long[size];
        }

        public int size() {
            return this.mZero ? this.mSize + 1 : this.mSize;
        }

        public boolean add(long v) {
            if (v == 0L) {
                boolean zero = this.mZero;
                this.mZero = true;
                return !zero;
            }
            long[] values = this.mValues;
            int len = values.length;
            int idx = (int)(v & (long)(len - 1));
            int tries = 0;
            while (true) {
                long found;
                if ((found = values[idx]) == 0L) {
                    values[idx] = v;
                    ++this.mSize;
                    return true;
                }
                if (found == v) {
                    return false;
                }
                if (++tries >= LongSet.probeLimit(len)) {
                    this.resize();
                    return this.add(v);
                }
                idx = idx + 1 & len - 1;
            }
        }

        public boolean contains(long v) {
            if (v == 0L) {
                return this.mZero;
            }
            int len = this.mValues.length;
            int tries = 0;
            int idx = (int)(v & (long)(len - 1));
            long found;
            while ((found = this.mValues[idx]) != 0L) {
                if (found == v) {
                    return true;
                }
                if (++tries >= LongSet.probeLimit(len)) {
                    return false;
                }
                idx = idx + 1 & len - 1;
            }
            return false;
        }

        private static int probeLimit(int len) {
            return 10 + (len >> 2);
        }

        private void resize() {
            int newSz = this.mValues.length << 1;
            LongSet newSet = new LongSet(newSz);
            int toCopy = this.mSize;
            int idx = 0;
            while (toCopy > 0 && idx < this.mValues.length) {
                long v;
                if ((v = this.mValues[idx++]) == 0L) continue;
                newSet.add(v);
                --toCopy;
            }
            this.mValues = newSet.mValues;
        }
    }
}

