/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.disco;

import com.amazon.cbor.CborEncodingException;
import com.amazon.cbor.CborInputStream;
import com.amazon.cbor.CborOutputStream;
import com.amazon.cbor.EndOfStreamException;
import com.amazon.cbor.Utils;
import com.amazon.dax.bits.model.Field;
import com.amazon.dax.bits.model.Fields;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class ServiceEndpoint {
    public static final Schema SCHEMA = new Schema();
    private long mNodeId;
    private String mHostname;
    private byte[] mAddress;
    private int mPort;
    private Role mRole;
    private String mZone;
    private long mLeaderSessionId;

    public ServiceEndpoint() {
    }

    private ServiceEndpoint(long nodeId, String hostname, byte[] address, int port, Role role, String zone, long leaderSessionId) {
        this.mNodeId = nodeId;
        this.mHostname = hostname;
        this.mAddress = address;
        this.mPort = port;
        this.mRole = role;
        this.mZone = zone;
        this.mLeaderSessionId = leaderSessionId;
    }

    public String toString() {
        return "ServiceEndpoint{" + Utils.longToUnsignedString(this.mNodeId) + ',' + this.mHostname + ',' + Arrays.toString(this.mAddress) + ',' + this.mPort + ',' + this.mRole + ',' + this.mZone + ',' + this.mLeaderSessionId + '}';
    }

    public int hashCode() {
        int result = (int)(this.mNodeId ^ this.mNodeId >>> 32);
        result = 31 * result + (this.mHostname == null ? 0 : this.mHostname.hashCode());
        result = 31 * result + Arrays.hashCode(this.mAddress);
        result = 31 * result + this.mPort;
        result = 31 * result + (this.mRole == null ? 0 : this.mRole.hashCode());
        result = 31 * result + (this.mZone == null ? 0 : this.mZone.hashCode());
        result = 31 * result + (int)(this.mLeaderSessionId ^ this.mLeaderSessionId >>> 32);
        return result;
    }

    public long nodeId() {
        return this.mNodeId;
    }

    public String hostname() {
        return this.mHostname;
    }

    public byte[] address() {
        return this.mAddress;
    }

    public int port() {
        return this.mPort;
    }

    public Role role() {
        return this.mRole;
    }

    public String zone() {
        return this.mZone;
    }

    public long leaderSessionId() {
        return this.mLeaderSessionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceEndpoint)) {
            return false;
        }
        ServiceEndpoint other = (ServiceEndpoint)obj;
        return this.mNodeId == other.mNodeId && this.mRole == other.mRole && this.mPort == other.mPort && Arrays.equals(this.mAddress, other.mAddress) && Objects.equals(this.mHostname, other.mHostname) && Objects.equals(this.mZone, other.mZone) && this.mLeaderSessionId == other.mLeaderSessionId;
    }

    public CborOutputStream writeTo(CborOutputStream os) throws IOException {
        Fields.begin(os);
        Schema.NODE.write(os, this.mNodeId);
        Schema.HOSTNAME.write(os, this.mHostname);
        Schema.ADDRESS.write(os, this.mAddress);
        Schema.PORT.write(os, this.mPort);
        Schema.ROLE.write(os, this.mRole);
        Schema.ZONE.write(os, this.mZone);
        Schema.LEADERSESSIONID.write(os, this.mLeaderSessionId);
        Fields.end(os);
        return os;
    }

    public static ServiceEndpoint readFrom(CborInputStream is) throws IOException {
        long remaining = Long.MAX_VALUE;
        block17: while (true) {
            int ft = is.fieldType();
            switch (ft >> 5) {
                case 5: {
                    if ((ft & 0x1F) != 31) {
                        remaining = is.getFieldValue();
                    }
                    is.consumeField();
                    break block17;
                }
                case 6: {
                    is.consumeField();
                    continue block17;
                }
                case 7: {
                    if (ft == 246) {
                        is.consumeField();
                        return null;
                    }
                }
                default: {
                    is.consumeField();
                    if (ft == -1) {
                        throw new EndOfStreamException(is);
                    }
                    throw new CborEncodingException("Unsupported type: " + Utils.intToUnsignedString(ft));
                }
            }
            break;
        }
        ServiceEndpoint ep = new ServiceEndpoint();
        block18: while (true) {
            int ft = is.fieldType();
            switch (ft) {
                case 255: {
                    is.consumeField();
                    break block18;
                }
                default: {
                    int fieldIdx = is.readInt();
                    switch (fieldIdx) {
                        case 0: {
                            ep.mNodeId = is.readLong();
                            break;
                        }
                        case 1: {
                            ep.mHostname = (String)is.readObject();
                            break;
                        }
                        case 2: {
                            ep.mAddress = (byte[])is.readObject();
                            break;
                        }
                        case 3: {
                            ep.mPort = is.readInt();
                            break;
                        }
                        case 4: {
                            ep.mRole = Role.valueOf(is.readInt());
                            break;
                        }
                        case 5: {
                            ep.mZone = (String)is.readObject();
                            break;
                        }
                        case 6: {
                            ep.mLeaderSessionId = is.readLong();
                            break;
                        }
                        default: {
                            is.skipObject();
                        }
                    }
                    if (--remaining > 0L) continue block18;
                    break block18;
                }
            }
            break;
        }
        return ep;
    }

    public static ServiceEndpoint from(long nodeId, String hostname, byte[] address, int port, Role role, String zone, long leaderSessionId) {
        return new ServiceEndpoint(nodeId, hostname, address, port, role, zone, leaderSessionId);
    }

    public static final class Schema
    implements Fields.ModelSchema {
        public static final Fields.LongField NODE = new Fields.LongField(0, "node");
        public static final Fields.StringField HOSTNAME = new Fields.StringField(1, "hostname");
        public static final Fields.BinaryField ADDRESS = new Fields.BinaryField(2, "address");
        public static final Fields.IntField PORT = new Fields.IntField(3, "port");
        public static final Fields.EnumField<Role> ROLE = new Fields.EnumField(4, "role");
        public static final Fields.StringField ZONE = new Fields.StringField(5, "availabilityZone");
        public static final Fields.LongField LEADERSESSIONID = new Fields.LongField(6, "leaderSessionId");
        private static final Field[] FIELDS = new Field[]{NODE, HOSTNAME, ADDRESS, PORT, ROLE, ZONE, LEADERSESSIONID};

        @Override
        public Field[] fields() {
            return FIELDS;
        }
    }

    public static enum Role implements Fields.EnumValue
    {
        LEADER(1),
        REPLICA(2);

        private final int value;

        private Role(int v) {
            this.value = v;
        }

        @Override
        public int value() {
            return this.value;
        }

        public static Role valueOf(int value) {
            switch (value) {
                case 1: {
                    return LEADER;
                }
                case 2: {
                    return REPLICA;
                }
            }
            return null;
        }
    }
}

