/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.dynamodb;

import com.amazon.dax.bits.dynamodb.AttributeValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AttributeValueUtil {
    private AttributeValueUtil() {
    }

    public static AttributeValue from(com.amazonaws.services.dynamodbv2.model.AttributeValue value) {
        Object valueObj = value.getBOOL();
        if (valueObj != null) {
            return ((Boolean)valueObj).booleanValue() ? AttributeValue.TRUE : AttributeValue.FALSE;
        }
        if (value.getNULL() != null) {
            return AttributeValue.NULL;
        }
        valueObj = value.getS();
        if (valueObj != null) {
            return AttributeValue.withString((String)valueObj);
        }
        valueObj = value.getN();
        if (valueObj != null) {
            return new AttributeValue(2, (String)valueObj);
        }
        valueObj = value.getB();
        if (valueObj != null) {
            return AttributeValue.withBinary(((ByteBuffer)valueObj).array());
        }
        valueObj = value.getSS();
        if (valueObj != null) {
            return new AttributeValue(4, (List)valueObj);
        }
        valueObj = value.getNS();
        if (valueObj != null) {
            return new AttributeValue(5, (List)valueObj);
        }
        valueObj = value.getBS();
        if (valueObj != null) {
            ArrayList<byte[]> bs = new ArrayList<byte[]>();
            for (ByteBuffer bb : (List)valueObj) {
                bs.add(bb.array());
            }
            return new AttributeValue(6, bs);
        }
        valueObj = value.getL();
        if (valueObj != null) {
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            for (com.amazonaws.services.dynamodbv2.model.AttributeValue av : (List)valueObj) {
                list.add(AttributeValueUtil.from(av));
            }
            return AttributeValue.withList(list);
        }
        valueObj = value.getM();
        if (valueObj != null) {
            HashMap<String, AttributeValue> m = new HashMap<String, AttributeValue>();
            for (Map.Entry en : ((Map)valueObj).entrySet()) {
                m.put((String)en.getKey(), AttributeValueUtil.from((com.amazonaws.services.dynamodbv2.model.AttributeValue)en.getValue()));
            }
            return AttributeValue.withMap(m);
        }
        throw new IllegalArgumentException();
    }

    public static com.amazonaws.services.dynamodbv2.model.AttributeValue toModel(AttributeValue av) {
        com.amazonaws.services.dynamodbv2.model.AttributeValue v = new com.amazonaws.services.dynamodbv2.model.AttributeValue();
        switch (av.type) {
            default: {
                throw new IllegalStateException("unknown type: " + av.type);
            }
            case 1: {
                return v.withS((String)av.value);
            }
            case 2: {
                return v.withN((String)av.value);
            }
            case 3: {
                return v.withB(ByteBuffer.wrap((byte[])av.value));
            }
            case 4: {
                return v.withSS((Collection)((List)av.value));
            }
            case 5: {
                return v.withNS((Collection)((List)av.value));
            }
            case 6: {
                List rb = (List)av.value;
                ByteBuffer[] bs = new ByteBuffer[rb.size()];
                for (int i = 0; i < bs.length; ++i) {
                    bs[i] = ByteBuffer.wrap((byte[])rb.get(i));
                }
                return v.withBS(bs);
            }
            case 7: {
                Map m = (Map)av.value;
                if (m.isEmpty()) {
                    return v.withM(Collections.emptyMap());
                }
                for (Map.Entry en : ((Map)av.value).entrySet()) {
                    v.addMEntry((String)en.getKey(), AttributeValueUtil.toModel((AttributeValue)en.getValue()));
                }
                return v;
            }
            case 8: {
                List list = (List)av.value;
                ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue> newList = new ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue>(list.size());
                for (AttributeValue ch : list) {
                    newList.add(AttributeValueUtil.toModel(ch));
                }
                return v.withL(newList);
            }
            case 9: {
                return v.withNULL(Boolean.valueOf(true));
            }
            case 10: 
        }
        return v.withBOOL((Boolean)av.value);
    }
}

