/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.expr;

import com.amazon.cbor.SegmentPool;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.bits.dynamodb.AttributeValueUtil;
import com.amazon.dax.bits.dynamodb.CborPackerCore;
import com.amazon.dax.bits.expr.ExpressionErrorListener;
import com.amazon.dax.bits.expr.ExpressionType;
import com.amazon.dax.bits.expr.Function;
import com.amazon.dax.client.com.amazon.dynamodb.grammar.DynamoDbExpressionParser;
import com.amazon.dax.client.com.amazon.dynamodb.grammar.DynamoDbGrammarBaseListener;
import com.amazon.dax.client.com.amazon.dynamodb.grammar.DynamoDbGrammarParser;
import com.amazon.dax.client.com.amazon.dynamodb.grammar.exceptions.RedundantParenthesesException;
import com.amazon.dax.client.org.antlr.v4.runtime.misc.NotNull;
import com.amazon.dax.client.org.antlr.v4.runtime.tree.ParseTree;
import com.amazon.dax.client.org.antlr.v4.runtime.tree.ParseTreeWalker;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CborSExprGenerator
extends DynamoDbGrammarBaseListener {
    private static final int MAX_STACK_DEPTH = 750;
    private static final int ENCODING_FORMAT = 1;
    public static final String ATTRIBUTE_VALUE_PREFIX = ":";
    public static final char ATTRIBUTE_NAME_PREFIX = '#';
    private final Stack<byte[]> mStack = new BoundedSizeStack<byte[]>(750);
    private final SegmentPool mPool = SegmentPool.withCapacity(128);
    private final Map<String, AttributeValue> mExpressionAttributeNames;
    private final Map<String, AttributeValue> mExpressionAttributeValues;
    private final Map<String, Integer> mVariableNameById;
    private final Set<String> mUnusedExpressionAttributeNames;
    private final Set<String> mUnusedExpressionAttributeValues;
    private final List<byte[]> mVariableValues;
    private ExpressionType mType;
    private int mNestingLevel;

    private CborSExprGenerator(Map<String, AttributeValue> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues) {
        this.mExpressionAttributeNames = expressionAttributeNames;
        this.mExpressionAttributeValues = expressionAttributeValues;
        this.mUnusedExpressionAttributeNames = new HashSet<String>();
        if (expressionAttributeNames != null) {
            this.mUnusedExpressionAttributeNames.addAll(expressionAttributeNames.keySet());
        }
        this.mUnusedExpressionAttributeValues = new HashSet<String>();
        if (expressionAttributeValues != null) {
            this.mUnusedExpressionAttributeValues.addAll(expressionAttributeValues.keySet());
            this.mVariableNameById = new HashMap<String, Integer>(expressionAttributeValues.size());
            this.mVariableValues = new ArrayList<byte[]>(expressionAttributeValues.size());
        } else {
            this.mVariableNameById = null;
            this.mVariableValues = null;
        }
    }

    private void reset(ExpressionType type) {
        this.mType = type;
        this.mNestingLevel = 0;
        if (this.mVariableNameById != null) {
            this.mVariableNameById.clear();
        }
        if (this.mVariableValues != null) {
            this.mVariableValues.clear();
        }
    }

    public static byte[] encodeConditionalExprWithStringAttrNames(String expression, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        Map<String, AttributeValue> expressionAttributeNames = CborSExprGenerator.convertExpressionAttributeNames(eAttrStrs);
        return CborSExprGenerator.encodeConditionalExpression(expression, expressionAttributeNames, eAttrVals);
    }

    public static Map<ExpressionType, byte[]> encodeExpressionsWithStringAttributeNames(String condExpr, String keyCondExpr, String filterExpr, String updExpr, String projExpr, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        Map<String, AttributeValue> eAttrNames = CborSExprGenerator.convertExpressionAttributeNames(eAttrStrs);
        return CborSExprGenerator.encodeExpressions(condExpr, keyCondExpr, filterExpr, updExpr, projExpr, eAttrNames, eAttrVals);
    }

    public static Map<ExpressionType, byte[]> encodeExpressions(String condExpr, String keyCondExpr, String filterExpr, String updExpr, String projExpr, Map<String, AttributeValue> eAttrNames, Map<String, AttributeValue> eAttrVals) {
        LinkedHashMap<ExpressionType, String> exprs = new LinkedHashMap<ExpressionType, String>();
        exprs.put(ExpressionType.Condition, condExpr);
        exprs.put(ExpressionType.KeyCondition, keyCondExpr);
        exprs.put(ExpressionType.Filter, filterExpr);
        exprs.put(ExpressionType.Update, updExpr);
        exprs.put(ExpressionType.Projection, projExpr);
        return CborSExprGenerator.encodeExpressions(exprs, eAttrNames, eAttrVals);
    }

    public static Map<ExpressionType, byte[]> encodeExpressions(Map<ExpressionType, String> exprs, Map<String, AttributeValue> eAttrNames, Map<String, AttributeValue> eAttrVals) {
        LinkedHashMap<ExpressionType, byte[]> output = new LinkedHashMap<ExpressionType, byte[]>();
        CborSExprGenerator generator = new CborSExprGenerator(eAttrNames, eAttrVals);
        for (Map.Entry<ExpressionType, String> e : exprs.entrySet()) {
            SegmentPool.Segment tail;
            ExpressionType type = e.getKey();
            String expr = e.getValue();
            if (expr == null) {
                output.put(type, null);
                continue;
            }
            String typeStr = type.name() + "Expression";
            ParseTree tree = null;
            int exprArrayLength = 3;
            try {
                switch (type) {
                    case Condition: 
                    case Filter: 
                    case KeyCondition: {
                        exprArrayLength = 3;
                        tree = DynamoDbExpressionParser.parseCondition(expr, new ExpressionErrorListener(expr, typeStr));
                        break;
                    }
                    case Projection: {
                        exprArrayLength = 2;
                        tree = DynamoDbExpressionParser.parseProjection(expr, new ExpressionErrorListener(expr, typeStr));
                        break;
                    }
                    case Update: {
                        exprArrayLength = 3;
                        tree = DynamoDbExpressionParser.parseUpdate(expr, new ExpressionErrorListener(expr, typeStr));
                    }
                }
            }
            catch (RedundantParenthesesException ex) {
                throw new IllegalArgumentException("Invalid " + typeStr + ": The expression has redundant parentheses");
            }
            generator.reset(type);
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk(generator, tree);
            generator.validateIntermediateState();
            byte[] spec = generator.mStack.pop();
            SegmentPool.Segment head = tail = generator.mPool.alloc();
            tail = generator.mPool.chainAppendCborArrayPrefix(tail, exprArrayLength);
            tail = generator.mPool.chainAppendCborInteger(tail, 1L);
            tail = generator.mPool.chainAppend(tail, spec);
            if (ExpressionType.Projection != type) {
                tail = generator.mPool.chainAppendCborArrayPrefix(tail, generator.mVariableValues.size());
                for (byte[] varVal : generator.mVariableValues) {
                    tail = generator.mPool.chainAppend(tail, varVal);
                }
            }
            output.put(type, generator.mPool.chainCopyAndRecycle(head, 0));
        }
        generator.validateFinalState();
        return output;
    }

    public static Map<String, AttributeValue> convertExpressionAttributeNames(Map<String, String> eAttrStrs) {
        HashMap<String, AttributeValue> expressionAttributeNames = new HashMap<String, AttributeValue>(eAttrStrs.size());
        for (Map.Entry<String, String> entry : eAttrStrs.entrySet()) {
            expressionAttributeNames.put(entry.getKey(), new AttributeValue().withS(entry.getValue()));
        }
        return expressionAttributeNames;
    }

    public static byte[] encodeConditionalExpression(String expression, Map<String, AttributeValue> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues) {
        return CborSExprGenerator.encodeExpressions(expression, null, null, null, null, expressionAttributeNames, expressionAttributeValues).get((Object)ExpressionType.Condition);
    }

    public static byte[] encodeProjectionExpression(String expression, Map<String, String> eAttrStrs) {
        return CborSExprGenerator.encodeExpressionsWithStringAttributeNames(null, null, null, null, expression, eAttrStrs, null).get((Object)ExpressionType.Projection);
    }

    public static byte[] encodeUpdateExpression(String expression, Map<String, String> eAttrStrs, Map<String, AttributeValue> eAttrVals) {
        return CborSExprGenerator.encodeExpressionsWithStringAttributeNames(null, null, null, expression, null, eAttrStrs, eAttrVals).get((Object)ExpressionType.Update);
    }

    @Override
    public void enterComparator(@NotNull DynamoDbGrammarParser.ComparatorContext ctx) {
        ++this.mNestingLevel;
    }

    @Override
    public void exitComparator(@NotNull DynamoDbGrammarParser.ComparatorContext ctx) {
        byte[] arg2 = this.mStack.pop();
        byte[] func = this.mStack.pop();
        byte[] arg1 = this.mStack.pop();
        this.mStack.push(this.encodeArray(func, arg1, arg2));
        --this.mNestingLevel;
    }

    @Override
    public void exitComparator_symbol(@NotNull DynamoDbGrammarParser.Comparator_symbolContext ctx) {
        Function func = null;
        switch (ctx.getText()) {
            case "=": {
                func = Function.Equal;
                break;
            }
            case "<>": {
                func = Function.NotEqual;
                break;
            }
            case "<": {
                func = Function.LessThan;
                break;
            }
            case "<=": {
                func = Function.LessEqual;
                break;
            }
            case ">": {
                func = Function.GreaterThan;
                break;
            }
            case ">=": {
                func = Function.GreaterEqual;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid function " + ctx.getText());
            }
        }
        this.mStack.push(this.encodeFunctionCode(func));
    }

    @Override
    public void exitPath(@NotNull DynamoDbGrammarParser.PathContext ctx) {
        byte[][] components = new byte[ctx.getChildCount()][];
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            components[ctx.getChildCount() - i - 1] = this.mStack.pop();
        }
        this.mStack.push(this.encodeFunction(Function.DocumentPath, components));
    }

    @Override
    public void exitListAccess(@NotNull DynamoDbGrammarParser.ListAccessContext ctx) {
        String value = ctx.getText();
        try {
            int ordinal = Integer.parseInt(value.substring(1, value.length() - 1));
            this.mStack.push(this.encodeListAccess(ordinal));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression: List index is not within the allowable range");
        }
    }

    @Override
    public void exitId(@NotNull DynamoDbGrammarParser.IdContext ctx) {
        String id = ctx.getText();
        if (id.charAt(0) == '#') {
            AttributeValue sub = this.mExpressionAttributeNames.get(id);
            if (sub == null) {
                throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression. Substitution value not provided for " + id);
            }
            this.mUnusedExpressionAttributeNames.remove(id);
            this.mStack.push(this.encodeAttributeValue(sub));
        } else {
            this.mStack.push(this.encodeDocumentPathElement(id));
        }
    }

    @Override
    public void exitLiteralSub(@NotNull DynamoDbGrammarParser.LiteralSubContext ctx) {
        String literal = ctx.getText();
        this.mStack.push(this.encodeVariable(literal.substring(1)));
    }

    @Override
    public void exitAnd(@NotNull DynamoDbGrammarParser.AndContext ctx) {
        byte[] arg2 = this.mStack.pop();
        byte[] arg1 = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.And, arg1, arg2));
    }

    @Override
    public void exitOr(@NotNull DynamoDbGrammarParser.OrContext ctx) {
        byte[] arg2 = this.mStack.pop();
        byte[] arg1 = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.Or, arg1, arg2));
    }

    @Override
    public void exitNegation(@NotNull DynamoDbGrammarParser.NegationContext ctx) {
        byte[] arg = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.Not, new byte[][]{arg}));
    }

    @Override
    public void enterIn(@NotNull DynamoDbGrammarParser.InContext ctx) {
        ++this.mNestingLevel;
    }

    @Override
    public void exitIn(@NotNull DynamoDbGrammarParser.InContext ctx) {
        int numArgs = 1 + (ctx.getChildCount() - 3) / 2;
        byte[][] args = new byte[numArgs - 1][];
        while (numArgs-- > 1) {
            args[numArgs - 1] = this.mStack.pop();
        }
        byte[] arg1 = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.In, arg1, this.encodeArray(args)));
        --this.mNestingLevel;
    }

    @Override
    public void enterBetween(@NotNull DynamoDbGrammarParser.BetweenContext ctx) {
        ++this.mNestingLevel;
    }

    @Override
    public void exitBetween(@NotNull DynamoDbGrammarParser.BetweenContext ctx) {
        byte[] arg3 = this.mStack.pop();
        byte[] arg2 = this.mStack.pop();
        byte[] arg1 = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.Between, arg1, arg2, arg3));
        --this.mNestingLevel;
    }

    @Override
    public void enterFunctionCall(@NotNull DynamoDbGrammarParser.FunctionCallContext ctx) {
        String funcName = ctx.ID().getText();
        if (this.mType != null) {
            switch (this.mType) {
                case Update: {
                    this.validateNotEquals(this.mType, funcName, "attribute_exists", "attribute_not_exists", "attribute_type", "begins_with", "contains", "size");
                    if (this.mNestingLevel <= 0 || funcName.equalsIgnoreCase("if_not_exists")) break;
                    throw new IllegalArgumentException("Only if_not_exists() function can be nested");
                }
                case Condition: 
                case Filter: {
                    this.validateNotEquals(this.mType, funcName, "if_not_exists", "list_append");
                    if (this.mNestingLevel == 0 && funcName.toLowerCase().equals("size")) {
                        String expTypeStr = this.mType == null ? "" : this.mType.name();
                        throw new IllegalArgumentException("Invalid " + expTypeStr + "Expression: The function is not allowed to be used this way in an expression");
                    }
                    if (this.mNestingLevel <= 0 || funcName.toLowerCase().equals("size")) break;
                    throw new IllegalArgumentException("Only size() function is allowed to be nested");
                }
            }
        }
        ++this.mNestingLevel;
    }

    private void validateNotEquals(ExpressionType expType, String actual, String ... notExpected) {
        for (String n : notExpected) {
            if (!actual.equalsIgnoreCase(n)) continue;
            String expTypeStr = expType == null ? "" : expType.name();
            throw new IllegalArgumentException("Invalid " + expTypeStr + "Expression: The function is not allowed in a " + expTypeStr.toLowerCase() + " expression");
        }
    }

    @Override
    public void exitFunctionCall(@NotNull DynamoDbGrammarParser.FunctionCallContext ctx) {
        String funcName = ctx.ID().getText();
        Function func = null;
        switch (funcName.toLowerCase()) {
            case "attribute_exists": {
                func = Function.AttributeExists;
                break;
            }
            case "attribute_not_exists": {
                func = Function.AttributeNotExists;
                break;
            }
            case "attribute_type": {
                func = Function.AttributeType;
                break;
            }
            case "begins_with": {
                func = Function.BeginsWith;
                break;
            }
            case "contains": {
                func = Function.Contains;
                break;
            }
            case "size": {
                func = Function.Size;
                break;
            }
            case "if_not_exists": {
                func = Function.IfNotExists;
                break;
            }
            case "list_append": {
                func = Function.ListAppend;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression: Invalid function name: function: " + funcName.toLowerCase());
            }
        }
        int numArgs = (ctx.getChildCount() - 2) / 2;
        byte[][] args = new byte[numArgs][];
        while (numArgs-- > 0) {
            args[numArgs] = this.mStack.pop();
        }
        this.mStack.push(this.encodeFunction(func, args));
        --this.mNestingLevel;
    }

    @Override
    public void exitProjection(@NotNull DynamoDbGrammarParser.ProjectionContext ctx) {
        int numPaths = (ctx.getChildCount() + 1) / 2;
        byte[][] paths = new byte[numPaths][];
        while (numPaths-- > 0) {
            paths[numPaths] = this.mStack.pop();
        }
        this.mStack.push(this.encodeArray(paths));
    }

    @Override
    public void exitUpdate(@NotNull DynamoDbGrammarParser.UpdateContext ctx) {
        byte[][] updates = new byte[this.mStack.size()][];
        int remaining = this.mStack.size();
        while (remaining > 0) {
            updates[--remaining] = this.mStack.pop();
        }
        this.mStack.push(this.encodeArray(updates));
    }

    @Override
    public void exitSet_action(@NotNull DynamoDbGrammarParser.Set_actionContext ctx) {
        byte[] operand = this.mStack.pop();
        byte[] path = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.SetAction, path, operand));
    }

    @Override
    public void exitRemove_action(@NotNull DynamoDbGrammarParser.Remove_actionContext ctx) {
        byte[] path = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.RemoveAction, new byte[][]{path}));
    }

    @Override
    public void exitAdd_action(@NotNull DynamoDbGrammarParser.Add_actionContext ctx) {
        byte[] value = this.mStack.pop();
        byte[] path = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.AddAction, path, value));
    }

    @Override
    public void exitDelete_action(@NotNull DynamoDbGrammarParser.Delete_actionContext ctx) {
        byte[] value = this.mStack.pop();
        byte[] path = this.mStack.pop();
        this.mStack.push(this.encodeFunction(Function.DeleteAction, path, value));
    }

    @Override
    public void enterPlusMinus(@NotNull DynamoDbGrammarParser.PlusMinusContext ctx) {
        ++this.mNestingLevel;
    }

    @Override
    public void exitPlusMinus(@NotNull DynamoDbGrammarParser.PlusMinusContext ctx) {
        String operator;
        byte[] op2 = this.mStack.pop();
        byte[] op1 = this.mStack.pop();
        Function func = null;
        switch (operator = ctx.getChild(1).getText()) {
            case "+": {
                func = Function.Plus;
                break;
            }
            case "-": {
                func = Function.Minus;
                break;
            }
            default: {
                throw new IllegalArgumentException("Must be +/-");
            }
        }
        this.mStack.push(this.encodeFunction(func, op1, op2));
        --this.mNestingLevel;
    }

    private byte[] encodeFunction(Function func, byte[] ... arguments) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborArrayPrefix(tail, arguments.length + 1);
        tail = this.mPool.chainAppendCborInteger(tail, func.ordinal());
        for (int i = 0; i < arguments.length; ++i) {
            tail = this.mPool.chainAppend(tail, arguments[i]);
        }
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeVariable(String varName) {
        SegmentPool.Segment tail;
        String fullName = ATTRIBUTE_VALUE_PREFIX + varName;
        AttributeValue val = this.mExpressionAttributeValues.get(fullName);
        if (val == null) {
            throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression: An expression attribute value used in expression is not defined: attribute value: " + fullName);
        }
        this.mUnusedExpressionAttributeValues.remove(fullName);
        Integer varId = this.mVariableNameById.get(varName);
        if (varId == null) {
            varId = this.mVariableValues.size();
            this.mVariableNameById.put(varName, varId);
            this.mVariableValues.add(this.encodeAttributeValue(val));
        }
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborArrayPrefix(tail, 2);
        tail = this.mPool.chainAppendCborInteger(tail, Function.Variable.ordinal());
        tail = this.mPool.chainAppendCborInteger(tail, varId.intValue());
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeArray(byte[] ... arguments) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborArrayPrefix(tail, arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            tail = this.mPool.chainAppend(tail, arguments[i]);
        }
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeListAccess(int ordinal) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborTypePrefix(tail, 192, 3324L);
        tail = this.mPool.chainAppendCborInteger(tail, ordinal);
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeFunctionCode(Function func) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborInteger(tail, func.ordinal());
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeDocumentPathElement(String str) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        tail = this.mPool.chainAppendCborString(tail, str);
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private byte[] encodeAttributeValue(AttributeValue val) {
        SegmentPool.Segment tail;
        SegmentPool.Segment head = tail = this.mPool.alloc();
        CborPackerCore.appendValue(this.mPool, tail, AttributeValueUtil.from(val));
        return this.mPool.chainCopyAndRecycle(head, 0);
    }

    private void validateIntermediateState() {
        if (this.mStack.size() != 1) {
            throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression, Stack size = " + this.mStack.size());
        }
        if (this.mNestingLevel != 0) {
            throw new IllegalArgumentException("Invalid " + this.mType.name() + "Expression, Nesting level = " + this.mNestingLevel);
        }
    }

    private void validateFinalState() {
        if (!this.mUnusedExpressionAttributeNames.isEmpty()) {
            String names = CborSExprGenerator.joinMissingNames(this.mUnusedExpressionAttributeNames);
            throw new IllegalArgumentException("Value provided in ExpressionAttributeNames unused in expressions: keys: {" + names + "}");
        }
        if (!this.mUnusedExpressionAttributeValues.isEmpty()) {
            String names = CborSExprGenerator.joinMissingNames(this.mUnusedExpressionAttributeValues);
            throw new IllegalArgumentException("Value provided in ExpressionAttributeValues unused in expressions: keys: {" + names + "}");
        }
    }

    private static String joinMissingNames(Collection<String> names) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    class BoundedSizeStack<E>
    extends Stack<E> {
        private static final long serialVersionUID = 1L;
        private final int mMaxSize;

        BoundedSizeStack(int maxSize) {
            this.mMaxSize = maxSize;
        }

        @Override
        public E push(E item) {
            if (this.size() >= this.mMaxSize) {
                throw new IllegalArgumentException("Invalid " + CborSExprGenerator.this.mType.name() + "Expression: The expression contains too many operators " + this.mMaxSize);
            }
            return super.push(item);
        }
    }
}

