/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits.expr;

public enum Function {
    Equal,
    NotEqual,
    LessThan,
    GreaterEqual,
    GreaterThan,
    LessEqual,
    And,
    Or,
    Not,
    Between,
    In,
    AttributeExists,
    AttributeNotExists,
    AttributeType,
    BeginsWith,
    Contains,
    Size,
    Variable,
    DocumentPath,
    SetAction,
    AddAction,
    DeleteAction,
    RemoveAction,
    IfNotExists,
    ListAppend,
    Plus,
    Minus;

    private static final Function[] BY_ORD;

    public static Function find(int ordinal) {
        if (ordinal < 0 || ordinal >= BY_ORD.length) {
            throw new IllegalArgumentException("invalid id " + ordinal);
        }
        return BY_ORD[ordinal];
    }

    public String toString() {
        switch (this) {
            case Equal: {
                return "=";
            }
            case NotEqual: {
                return "<>";
            }
            case LessThan: {
                return "<";
            }
            case GreaterEqual: {
                return ">=";
            }
            case GreaterThan: {
                return ">";
            }
            case LessEqual: {
                return "<=";
            }
            case Variable: {
                return ":";
            }
            case DocumentPath: {
                return ".";
            }
            case IfNotExists: {
                return "if_not_exists";
            }
            case ListAppend: {
                return "list_append";
            }
            case Size: {
                return "size";
            }
            case Contains: {
                return "contains";
            }
            case AttributeExists: {
                return "attribute_exists";
            }
            case AttributeNotExists: {
                return "attribute_not_exists";
            }
            case AttributeType: {
                return "attribute_type";
            }
            case Plus: {
                return "+";
            }
            case Minus: {
                return "-";
            }
            case Between: {
                return "between";
            }
            case In: {
                return "in";
            }
            case BeginsWith: {
                return "begins_with";
            }
        }
        return this.name();
    }

    static {
        BY_ORD = Function.values();
    }
}

