/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.DaxCborInputStream;
import com.amazon.dax.bits.DaxCborOutputStream;
import com.amazon.dax.client.SessionVersion;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ClientTube
implements Closeable {
    private static final String MAGIC_STRING = "J7yne5G";
    public static final String USER_AGENT_STRING = "UserAgent";
    public static final long MAX_EXPIRE = Long.MAX_VALUE;
    private final Closeable mSocket;
    private final DaxCborInputStream mInput;
    private final DaxCborOutputStream mOutput;
    private final String mUserAgent;
    private long mAuthExp = 0L;
    ClientTube mNextTube;
    boolean mUsed;
    final SessionVersion mVersion;
    final long mTubeExpiryTimeMillis;
    private String mAccessKeyId;

    public ClientTube(Socket socket, SessionVersion version, String userAgent) throws IOException {
        this.mSocket = socket;
        this.mInput = new DaxCborInputStream(socket.getInputStream());
        this.mOutput = new DaxCborOutputStream(socket.getOutputStream());
        this.mVersion = version;
        this.mUserAgent = userAgent;
        this.mTubeExpiryTimeMillis = Long.MAX_VALUE;
        this.init(this.mVersion.mSession);
    }

    public ClientTube(Socket socket, SessionVersion version, String userAgent, long expiryTimeMillis) throws IOException {
        this.mSocket = socket;
        this.mInput = new DaxCborInputStream(socket.getInputStream());
        this.mOutput = new DaxCborOutputStream(socket.getOutputStream());
        this.mVersion = version;
        this.mUserAgent = userAgent;
        this.mTubeExpiryTimeMillis = expiryTimeMillis;
        this.init(this.mVersion.mSession);
    }

    public ClientTube(Closeable socket, SessionVersion version, String userAgent, long expiryTimeMillis, InputStream is, OutputStream os) throws IOException {
        this.mSocket = socket;
        this.mInput = new DaxCborInputStream(is);
        this.mOutput = new DaxCborOutputStream(os);
        this.mVersion = version;
        this.mUserAgent = userAgent;
        this.mTubeExpiryTimeMillis = expiryTimeMillis;
        this.init(this.mVersion.mSession);
    }

    ClientTube(DaxCborInputStream in, DaxCborOutputStream out) throws IOException {
        this(in, out, null, Long.MAX_VALUE);
    }

    ClientTube(DaxCborInputStream in, DaxCborOutputStream out, SessionVersion version) throws IOException {
        this(in, out, version, Long.MAX_VALUE);
    }

    ClientTube(DaxCborInputStream in, DaxCborOutputStream out, SessionVersion version, long expiryTimeMillis) throws IOException {
        this.mSocket = null;
        this.mInput = in;
        this.mOutput = out;
        this.mVersion = version;
        this.mUserAgent = "";
        this.mTubeExpiryTimeMillis = expiryTimeMillis;
    }

    public DaxCborInputStream getInputStream() {
        return this.mInput;
    }

    public DaxCborOutputStream getOutputStream() {
        return this.mOutput;
    }

    @Override
    public void close() {
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init(byte[] session) throws IOException {
        this.mOutput.writeString(MAGIC_STRING);
        this.mOutput.write(0);
        if (session == null) {
            this.mOutput.writeNull();
        } else {
            this.mOutput.writeBytes(session);
        }
        this.mOutput.writeMapHeader(1);
        this.mOutput.writeString(USER_AGENT_STRING);
        this.mOutput.writeString(this.mUserAgent);
        this.mOutput.write(0);
        this.mOutput.flush();
    }

    public void setAuthExp(long authExp) {
        this.mAuthExp = authExp;
    }

    public long getAuthExp() {
        return this.mAuthExp;
    }

    public void invalidateAuth() {
        this.mAuthExp = 0L;
    }

    public boolean checkAndUpdateAccessKeyId(String other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("AWSCredentialsProvider provided null AWSAccessKeyId");
        }
        boolean equality = other.equals(this.mAccessKeyId);
        if (!equality) {
            this.mAccessKeyId = other;
        }
        return equality;
    }
}

