/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.DaxConnectorBase;
import com.amazon.dax.client.SessionVersion;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Future;

public class DaxConnector
extends DaxConnectorBase {
    DaxConnector(Connector connector, int timeoutMs, int maxPending, LazyClock clock, long tubeTtlMs) {
        this(connector, timeoutMs, maxPending, "", clock, tubeTtlMs);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent) {
        this(connector, timeoutMs, maxPending, userAgent, -1);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, LazyClock clock, long tubeTtlMs) {
        this(connector, timeoutMs, maxPending, userAgent, -1, clock, tubeTtlMs);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs) {
        this(connector, timeoutMs, maxPending, userAgent, connectTimeoutMs, LazyClock.instance(), Long.MAX_VALUE);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs, LazyClock clock, long tubeTtlMs) {
        super(connector, timeoutMs, maxPending, userAgent, connectTimeoutMs, clock, tubeTtlMs);
    }

    @Override
    public Future<?> connect(final SocketAddress sa, int timeoutMs, final SessionVersion version, final Connector.Listener<ClientTube> lt) {
        int timeout;
        Future<?> job = null;
        int n = timeout = timeoutMs <= 0 ? this.mConnectTimeoutMs : timeoutMs;
        if (this.mBound.tryAcquire()) {
            job = this.mConnector.connect(new Connector.Supplier<Socket>(){
                int connTimeout;
                {
                    this.connTimeout = timeout <= 0 ? DaxConnector.this.mConnector.getConnectTimeout() : timeout;
                }

                @Override
                public Socket get() throws IOException {
                    Socket socket = new Socket();
                    try {
                        socket.connect(sa, this.connTimeout >> 2);
                    }
                    catch (Throwable t) {
                        Connector.silentClose(socket);
                        socket = new Socket();
                        try {
                            socket.connect(sa, this.connTimeout);
                        }
                        catch (Throwable t2) {
                            Connector.silentClose(socket);
                            t2.addSuppressed(t);
                            throw Connector.check(t2);
                        }
                    }
                    return socket;
                }
            }, new Connector.Listener<Socket>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handle(Socket sock, Throwable e) {
                    ClientTube tube = null;
                    try {
                        if (e == null) {
                            try {
                                tube = DaxConnector.this.newTube(sock, version);
                            }
                            catch (Throwable t) {
                                Connector.silentClose(sock);
                                e = Connector.check(t);
                            }
                        }
                    }
                    finally {
                        DaxConnector.this.mBound.release();
                    }
                    lt.handle(tube, e);
                }
            });
            if (job == null) {
                this.mBound.release();
            }
            return job;
        }
        return null;
    }
}

