/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.SessionVersion;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;

public abstract class DaxConnectorBase
implements Closeable {
    protected final Connector mConnector;
    protected final int mTimeout;
    protected final Semaphore mBound;
    protected final String mUserAgent;
    protected final int mConnectTimeoutMs;
    private final LazyClock mClock;
    protected final long mTubeTtlMs;
    private final long mTubeTtlJitterMs;

    public DaxConnectorBase(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs, LazyClock clock, long tubeTtlMs) {
        this.mConnector = connector;
        this.mTimeout = timeoutMs;
        this.mBound = new Semaphore(maxPending);
        this.mUserAgent = userAgent;
        this.mConnectTimeoutMs = connectTimeoutMs;
        this.mClock = clock != null ? clock : LazyClock.instance();
        this.mTubeTtlMs = tubeTtlMs;
        this.mTubeTtlJitterMs = DaxConnectorBase.calculateTubeExpiryJitterMillis(tubeTtlMs);
    }

    @Override
    public void close() {
    }

    public Future<?> connect(SocketAddress sa, SessionVersion s, Connector.Listener<ClientTube> lt) {
        return this.connect(sa, -1, s, lt);
    }

    public abstract Future<?> connect(SocketAddress var1, int var2, SessionVersion var3, Connector.Listener<ClientTube> var4);

    protected long calculateTubeExpiryMillis(long tubeTTLMs) {
        if (tubeTTLMs == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.mClock.getCurrentTime() + ThreadLocalRandom.current().nextLong(this.mTubeTtlJitterMs) + tubeTTLMs;
    }

    private static long calculateTubeExpiryJitterMillis(long tubeTtlMs) {
        return (long)Math.max(5000.0, 0.1 * (double)tubeTtlMs);
    }

    protected ClientTube newTube(Socket sock, SessionVersion version) throws IOException {
        sock.setTcpNoDelay(true);
        sock.setSoTimeout(this.mTimeout);
        sock.setKeepAlive(true);
        return new ClientTube(sock, version, this.mUserAgent, this.calculateTubeExpiryMillis(this.mTubeTtlMs));
    }
}

