/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;

public final class DaxHostnameVerifier {
    private final String mHostname;
    private final HostnameVerifier mHostnameVerifier;

    public static DaxHostnameVerifier getNoOpVerifier() {
        return NoOpVerifierHolder.NO_OP_VERIFIER;
    }

    private DaxHostnameVerifier() {
        this.mHostname = null;
        this.mHostnameVerifier = new NoopHostnameVerifier();
    }

    public DaxHostnameVerifier(String hostname) {
        this.mHostname = hostname;
        this.mHostnameVerifier = new DefaultHostnameVerifier();
    }

    public void verifyHostname(SSLSocket socket) throws SSLPeerUnverifiedException {
        boolean verified = this.mHostnameVerifier.verify(this.mHostname, socket.getSession());
        if (!verified) {
            throw new SSLPeerUnverifiedException("Hostname verification failed. Certificate does not match expected common name: " + this.mHostname);
        }
    }

    private static final class NoOpVerifierHolder {
        private static final DaxHostnameVerifier NO_OP_VERIFIER = new DaxHostnameVerifier();

        private NoOpVerifierHolder() {
        }
    }
}

