/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.DaxConnectorBase;
import com.amazon.dax.client.DaxHostnameVerifier;
import com.amazon.dax.client.SessionVersion;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DaxTlsConnector
extends DaxConnectorBase {
    protected final DaxHostnameVerifier mHostnameVerifier;

    public DaxTlsConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, LazyClock clock, long tubeTtlMs, DaxHostnameVerifier hostnameVerifier) {
        this(connector, timeoutMs, maxPending, userAgent, -1, clock, tubeTtlMs, hostnameVerifier);
    }

    public DaxTlsConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs, DaxHostnameVerifier hostnameVerifier) {
        this(connector, timeoutMs, maxPending, userAgent, connectTimeoutMs, LazyClock.instance(), Long.MAX_VALUE, hostnameVerifier);
    }

    public DaxTlsConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs, LazyClock clock, long tubeTtlMs, DaxHostnameVerifier hostnameVerifier) {
        super(connector, timeoutMs, maxPending, userAgent, connectTimeoutMs, clock, tubeTtlMs);
        this.mHostnameVerifier = hostnameVerifier;
    }

    @Override
    public Future<?> connect(final SocketAddress sa, int timeoutMs, final SessionVersion version, final Connector.Listener<ClientTube> lt) {
        int timeout;
        Future<?> job = null;
        int n = timeout = timeoutMs <= 0 ? this.mConnectTimeoutMs : timeoutMs;
        if (this.mBound.tryAcquire()) {
            job = this.mConnector.connect(new Connector.Supplier<SSLSocket>(){
                int connTimeout;
                {
                    this.connTimeout = timeout <= 0 ? DaxTlsConnector.this.mConnector.getConnectTimeout() : timeout;
                }

                @Override
                public SSLSocket get() throws IOException {
                    SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    SSLSocket socket = (SSLSocket)sslFact.createSocket();
                    try {
                        socket.connect(sa, this.connTimeout >> 2);
                        DaxTlsConnector.this.mHostnameVerifier.verifyHostname(socket);
                    }
                    catch (Throwable t) {
                        Connector.silentClose(socket);
                        sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
                        socket = (SSLSocket)sslFact.createSocket();
                        try {
                            socket.connect(sa, this.connTimeout);
                            DaxTlsConnector.this.mHostnameVerifier.verifyHostname(socket);
                        }
                        catch (Throwable t2) {
                            Connector.silentClose(socket);
                            t2.addSuppressed(t);
                            throw Connector.check(t2);
                        }
                    }
                    return socket;
                }
            }, new Connector.Listener<SSLSocket>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handle(SSLSocket sock, Throwable e) {
                    ClientTube tube = null;
                    try {
                        if (e == null) {
                            try {
                                tube = DaxTlsConnector.this.newTube(sock, version);
                            }
                            catch (Throwable t) {
                                Connector.silentClose(sock);
                                e = Connector.check(t);
                            }
                        }
                    }
                    finally {
                        DaxTlsConnector.this.mBound.release();
                    }
                    lt.handle(tube, e);
                }
            });
            if (job == null) {
                this.mBound.release();
            }
            return job;
        }
        return null;
    }
}

