/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.DaxConnector;
import com.amazon.dax.client.DaxConnectorBase;
import com.amazon.dax.client.SessionVersion;
import com.amazon.dax.client.TubePool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SocketTubePool
implements TubePool {
    private static final Log LOG = LogFactory.getLog(SocketTubePool.class);
    private static final long DEFAULT_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    private static final long LOG_INTERVAL_NS = 1000000000L;
    private static final int DEFAULT_MIN_IDLE_SIZE = 1;
    private final DaxConnectorBase mConnector;
    private final InetSocketAddress mSockAddr;
    private final int mConnectTimeoutMs;
    private final long mTimeoutNanos;
    private final Lock mLock = new ReentrantLock();
    private final Condition mAvail = this.mLock.newCondition();
    private final LazyClock mClock;
    private final int mMinIdleSize;
    protected ClientTube mHeadTube;
    protected ClientTube mLastActiveTube;
    protected SessionVersion mSession;
    private boolean mClosed;
    private int mIdleSize;
    private int mActiveOffset;
    private int mWaiters;
    private Throwable mLastConnectError;
    private long mNextLogTime = System.nanoTime() - 1000000000L - 1L;

    public SocketTubePool(String hostname, int port, String userAgent) {
        this(new InetSocketAddress(hostname, port), userAgent);
    }

    public SocketTubePool(String hostname, int port, DaxConnectorBase connector) {
        this(new InetSocketAddress(hostname, port), SessionVersion.create(), connector, null);
    }

    public SocketTubePool(InetSocketAddress sockAddr, String userAgent) {
        this(sockAddr, SessionVersion.create(), new DaxConnector(new Connector(2000), 60000, 100, userAgent), null);
    }

    public SocketTubePool(String hostname, int port, String userAgent, long tubeTtlMs) {
        this(new InetSocketAddress(hostname, port), userAgent, LazyClock.instance(), tubeTtlMs);
    }

    public SocketTubePool(InetSocketAddress sockAddr, String userAgent, LazyClock clock, long tubeTtlMs) {
        this(sockAddr, SessionVersion.create(), (DaxConnectorBase)new DaxConnector(new Connector(2000), 60000, 100, userAgent, clock, tubeTtlMs), null, clock);
    }

    public SocketTubePool(String hostname, int port, String userAgent, long tubeTtlMs, DaxConnectorBase daxConnector) {
        this(new InetSocketAddress(hostname, port), userAgent, LazyClock.instance(), tubeTtlMs, daxConnector);
    }

    public SocketTubePool(InetSocketAddress sockAddr, String userAgent, LazyClock clock, long tubeTtlMs, DaxConnectorBase daxConnector) {
        this(sockAddr, SessionVersion.create(), daxConnector, null, clock);
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnector connector, ClientTube tube) {
        this(sockAddr, session, (DaxConnectorBase)connector, tube, LazyClock.instance());
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnectorBase connector, ClientTube tube) {
        this(sockAddr, session, connector, tube, LazyClock.instance());
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnectorBase connector, ClientTube tube, LazyClock clock) {
        this(sockAddr, session, connector, tube, -1, clock, 1);
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnectorBase connector, ClientTube tube, int timeoutMs) {
        this(sockAddr, session, connector, tube, timeoutMs, LazyClock.instance(), 1);
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnectorBase connector, ClientTube tube, int timeoutMs, int minIdleSize) {
        this(sockAddr, session, connector, tube, timeoutMs, LazyClock.instance(), minIdleSize);
    }

    public SocketTubePool(InetSocketAddress sockAddr, SessionVersion session, DaxConnectorBase connector, ClientTube tube, int timeoutMs, LazyClock clock, int minIdleSize) {
        this.mSockAddr = sockAddr;
        this.mSession = session;
        this.mConnector = connector;
        this.mConnectTimeoutMs = timeoutMs;
        this.mTimeoutNanos = this.mConnectTimeoutMs <= 0 ? DEFAULT_TIMEOUT_NS : TimeUnit.MILLISECONDS.toNanos(this.mConnectTimeoutMs);
        this.mMinIdleSize = minIdleSize <= 0 ? 1 : minIdleSize;
        this.mIdleSize = 0;
        this.mHeadTube = tube;
        if (tube != null) {
            this.mLastActiveTube = tube;
            this.mIdleSize = 1;
        }
        this.mActiveOffset = 0;
        this.mClock = clock != null ? clock : LazyClock.instance();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ClientTube alloc() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void recycle(ClientTube tube) {
        if (tube == null) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.isExpired(tube)) {
                this.mAvail.signal();
            } else if (tube.mVersion == this.mSession) {
                if (!this.mClosed || this.mWaiters > 0) {
                    tube.mNextTube = this.mHeadTube;
                    this.mHeadTube = tube;
                    ++this.mIdleSize;
                    if (this.mLastActiveTube != null) {
                        ++this.mActiveOffset;
                    }
                    this.mAvail.signal();
                    return;
                }
            } else if (this.mClosed) {
                this.mAvail.signal();
            }
        }
        finally {
            this.mLock.unlock();
        }
        tube.close();
    }

    @Override
    public void reset(ClientTube tube) {
        if (tube == null) {
            return;
        }
        tube.close();
        this.mLock.lock();
        try {
            if (tube.mVersion != this.mSession) {
                return;
            }
            this.versionBump();
            tube = this.clearTubeList();
            this.mAvail.signalAll();
        }
        finally {
            this.mLock.unlock();
        }
        SocketTubePool.closeAll(tube);
    }

    @Override
    public void close() {
        ClientTube head;
        this.mLock.lock();
        try {
            this.mClosed = true;
            this.versionBump();
            head = this.clearTubeList();
            this.mAvail.signalAll();
        }
        finally {
            this.mLock.unlock();
        }
        SocketTubePool.closeAll(head);
    }

    int waiters() {
        this.mLock.lock();
        try {
            int n = this.mWaiters;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    int size() {
        this.mLock.lock();
        try {
            int n = this.mIdleSize;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void versionBump() {
        this.mSession = SessionVersion.create();
    }

    private ClientTube tryTakeHeadTube() {
        ClientTube tube = this.mHeadTube;
        if (tube != null) {
            this.mHeadTube = tube.mNextTube;
            if (this.mLastActiveTube == tube) {
                this.mLastActiveTube = this.mHeadTube;
                this.mActiveOffset = 0;
            } else if (this.mLastActiveTube != null) {
                --this.mActiveOffset;
            }
            tube.mNextTube = null;
            --this.mIdleSize;
        }
        return tube;
    }

    private ClientTube clearTubeList() {
        ClientTube head = this.mHeadTube;
        this.mHeadTube = null;
        this.mLastActiveTube = null;
        this.mActiveOffset = 0;
        this.mIdleSize = 0;
        return head;
    }

    private void setLastError(InetSocketAddress addr, Throwable e) {
        this.mLock.lock();
        this.mLastConnectError = e;
        long now = System.nanoTime();
        if (this.mNextLogTime - now <= 0L) {
            LOG.warn((Object)("error connecting to " + addr + " " + e), e);
            this.mNextLogTime = now + 1000000000L;
        }
        this.mAvail.signal();
        this.mLock.unlock();
    }

    private static void closeAll(ClientTube head) {
        while (head != null) {
            ClientTube next = head.mNextTube;
            head.mNextTube = null;
            head.close();
            head = next;
        }
    }

    protected boolean isExpired(ClientTube tube) {
        return tube.mTubeExpiryTimeMillis != Long.MAX_VALUE && this.mClock.getCurrentTime() - tube.mTubeExpiryTimeMillis >= 0L;
    }

    private Future<?> connect(SessionVersion session) {
        return this.mConnector.connect(this.mSockAddr, this.mConnectTimeoutMs, session, new Connector.Listener<ClientTube>(){

            @Override
            public void handle(ClientTube value, Throwable e) {
                if (e != null) {
                    SocketTubePool.this.setLastError(SocketTubePool.this.mSockAddr, e);
                } else {
                    SocketTubePool.this.recycle(value);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reapIdleTubes() {
        ClientTube toReap = null;
        this.mLock.lock();
        try {
            if (this.mLastActiveTube != null && this.mIdleSize > this.mMinIdleSize) {
                int idleTubeCount;
                toReap = this.mLastActiveTube.mNextTube;
                ClientTube prev = this.mLastActiveTube;
                for (idleTubeCount = this.mActiveOffset + 1; toReap != null && idleTubeCount < this.mMinIdleSize; ++idleTubeCount) {
                    prev = toReap;
                    toReap = toReap.mNextTube;
                }
                prev.mNextTube = null;
                this.mIdleSize = idleTubeCount;
            }
            this.mLastActiveTube = this.mHeadTube;
            this.mActiveOffset = 0;
        }
        finally {
            this.mLock.unlock();
        }
        SocketTubePool.closeAll(toReap);
    }
}

