/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.cluster;

import com.amazon.dax.client.cluster.Router;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomRouter<T>
implements Router<T> {
    private final T[] mValues;
    private final int mLeaderCnt;

    public RandomRouter(T[] values, int leaderCnt) {
        if (values == null) {
            throw new IllegalArgumentException("routes must not be null");
        }
        if (leaderCnt > values.length) {
            throw new IllegalArgumentException("leader count must be <= routes");
        }
        this.mValues = values;
        this.mLeaderCnt = leaderCnt;
    }

    @Override
    public T nextLeader(T prev) {
        return this.next(prev, this.mLeaderCnt);
    }

    @Override
    public T nextAny(T prev) {
        return this.next(prev, this.mValues.length);
    }

    private T next(T prev, int len) {
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return this.mValues[0];
        }
        int idx = ThreadLocalRandom.current().nextInt(len);
        if (this.mValues[idx] == prev && ++idx >= len) {
            idx -= len;
        }
        return this.mValues[idx];
    }

    @Override
    public int size() {
        return this.mValues.length;
    }

    @Override
    public int leadersCount() {
        return this.mLeaderCnt;
    }
}

