/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodb;

import com.amazon.cbor.SegmentPool;
import com.amazon.dax.Constants;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumMap;
import java.util.Map;

public final class DaxRequestEncoder {
    private DaxRequestEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeOptionalArgs(EnumMap<Constants.DaxDataRequestParam, Object> args, SegmentPool pool) throws IOException {
        SegmentPool.Segment head;
        SegmentPool.Segment tail = head = pool.alloc();
        try {
            if (args == null || args.isEmpty()) {
                pool.chainAppend(tail, (byte)-10);
                byte[] byArray = pool.chainCopyAndTrim(head, 0);
                return byArray;
            }
            tail = pool.chainAppendCborMapStreamPrefix(tail);
            block10: for (Map.Entry<Constants.DaxDataRequestParam, Object> entry : args.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                tail = pool.chainAppendCborInteger(tail, entry.getKey().ordinal());
                switch (entry.getKey()) {
                    case ReturnItemCollectionMetrics: 
                    case ReturnConsumedCapacity: 
                    case ReturnValues: 
                    case Select: 
                    case Limit: 
                    case Segment: 
                    case TotalSegments: {
                        tail = pool.chainAppendCborInteger(tail, ((Integer)value).intValue());
                        continue block10;
                    }
                    case ConsistentRead: 
                    case ScanIndexForward: {
                        tail = pool.chainAppendCborInteger(tail, (Boolean)value != false ? 1L : 0L);
                        continue block10;
                    }
                    case ConditionExpression: 
                    case ExclusiveStartKey: 
                    case ProjectionExpression: 
                    case FilterExpression: 
                    case IndexName: 
                    case UpdateExpression: {
                        tail = pool.chainAppendCborBytes(tail, (byte[])value);
                        continue block10;
                    }
                    case ClientRequestToken: {
                        tail = pool.chainAppendCborString(tail, (String)value);
                        continue block10;
                    }
                }
                throw new UnsupportedEncodingException("Unknown value type: " + (Object)((Object)entry.getKey()));
            }
            pool.chainAppendCborStreamBreak(tail);
            Object object = pool.chainCopyAndTrim(head, 0);
            return object;
        }
        finally {
            pool.chainRecycle(head);
        }
    }

    public static byte[] encodeItemOperationsOptionalParams(int returnValue, int returnConsumedCapacity, int returnItemCollectionMetrics, byte[] conditionsExpression, byte[] updateExpression, String clientRequestToken, SegmentPool segmentPool) throws IOException {
        EnumMap<Constants.DaxDataRequestParam, Object> optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Object>(Constants.DaxDataRequestParam.class);
        if (returnValue != DynamoNumerals.ReturnValue.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnValues, Integer.valueOf(returnValue));
        }
        if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, Integer.valueOf(returnConsumedCapacity));
        }
        if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnItemCollectionMetrics, Integer.valueOf(returnItemCollectionMetrics));
        }
        if (conditionsExpression != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.ConditionExpression, conditionsExpression);
        }
        if (updateExpression != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.UpdateExpression, updateExpression);
        }
        if (clientRequestToken != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.ClientRequestToken, (Object)clientRequestToken);
        }
        return DaxRequestEncoder.encodeOptionalArgs(optionalArgs, segmentPool);
    }
}

