/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.client.DaxHostnameVerifier;
import com.amazon.dax.client.HostPort;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.util.StringUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientConfig {
    private static final Log LOG = LogFactory.getLog(ClientConfig.class);
    protected static final int DEFAULT_MAX_PENDING_CONNECTIONS_PER_HOST = 10;
    protected static final int DEFAULT_UNHEALTHY_CONSECUTIVE_ERROR_COUNT = 5;
    protected static final long DEFAULT_CLUSTER_UPDATE_INTERVAL_MS = 4000L;
    protected static final long DEFAULT_CLUSTER_UPDATE_THRESHOLD_MS = 125L;
    protected static final long DEFAULT_CONNECT_TIMEOUT_MS = 1000L;
    protected static final long DEFAULT_REQUEST_TIMEOUT_MS = 60000L;
    protected static final long DEFAULT_HEALTH_CHECK_INTERVAL_MS = 5000L;
    protected static final long DEFAULT_HEALTH_CHECK_TIMEOUT_MS = 1000L;
    protected static final long DEFAULT_IDLE_CONNECTION_TIMEOUT_MS = 30000L;
    protected static final int DEFAULT_READ_RETRIES = 2;
    protected static final int DEFAULT_WRITE_RETRIES = 2;
    protected static final long DEFAULT_MAX_RETRY_DELAY_MS = 7000L;
    protected static final long DEFAULT_THREAD_KEEP_ALIVE_MS = 10000L;
    protected static final int DEFAULT_MIN_IDLE_CONNECTION_SIZE = 1;
    private int mMaxPendingConnectsPerHost;
    private int mUnhealthyConsecutiveErrorCount;
    private long mClusterUpdateThreshold;
    private long mClusterUpdateInterval;
    private long mConnectTimeout;
    private long mRequestTimeout;
    private long mHealthCheckInterval;
    private long mHealthCheckTimeout;
    private long mIdleConnectionTimeout;
    private int mMinIdleConnectionSize;
    private int mWriteRetries;
    private int mReadRetries;
    private long mMaxRetryDelay;
    private long mThreadKeepAlive;
    private HostPort[] mHostPorts;
    private boolean mIsEncrypted;
    @Deprecated
    public AWSCredentialsProvider mProvider;
    @Deprecated
    public String mRegion;
    private DaxHostnameVerifier mHostVerifier;

    ClientConfig(ClientConfig anotherConfig) {
        this();
        if (anotherConfig != null) {
            this.mMaxPendingConnectsPerHost = anotherConfig.mMaxPendingConnectsPerHost;
            this.mUnhealthyConsecutiveErrorCount = anotherConfig.mUnhealthyConsecutiveErrorCount;
            this.mClusterUpdateThreshold = anotherConfig.mClusterUpdateThreshold;
            this.mClusterUpdateInterval = anotherConfig.mClusterUpdateInterval;
            this.mConnectTimeout = anotherConfig.mConnectTimeout;
            this.mRequestTimeout = anotherConfig.mRequestTimeout;
            this.mHealthCheckInterval = anotherConfig.mHealthCheckInterval;
            this.mHealthCheckTimeout = anotherConfig.mHealthCheckTimeout;
            this.mIdleConnectionTimeout = anotherConfig.mIdleConnectionTimeout;
            this.mMinIdleConnectionSize = anotherConfig.mMinIdleConnectionSize;
            this.mWriteRetries = anotherConfig.mWriteRetries;
            this.mReadRetries = anotherConfig.mReadRetries;
            this.mMaxRetryDelay = anotherConfig.mMaxRetryDelay;
            this.mThreadKeepAlive = anotherConfig.mThreadKeepAlive;
            this.mHostPorts = anotherConfig.mHostPorts;
            this.mHostVerifier = anotherConfig.mHostVerifier;
            this.mProvider = anotherConfig.mProvider;
            this.mRegion = anotherConfig.mRegion;
        }
    }

    public ClientConfig() {
        this.withConnectTimeout(1000L, TimeUnit.MILLISECONDS);
        this.withRequestTimeout(60000L, TimeUnit.MILLISECONDS);
        this.withHealthCheckInterval(5000L, TimeUnit.MILLISECONDS);
        this.withHealthCheckTimeout(1000L, TimeUnit.MILLISECONDS);
        this.withIdleConnectionTimeout(30000L, TimeUnit.MILLISECONDS);
        this.withMinIdleConnectionSize(1);
        this.withClusterUpdateInterval(4000L, TimeUnit.MILLISECONDS);
        this.withClusterUpdateThreshold(125L, TimeUnit.MILLISECONDS);
        this.withThreadKeepAlive(10000L, TimeUnit.MILLISECONDS);
        this.withMaxPendingConnectsPerHost(10);
        this.withUnhealthyConsecutiveErrorCount(5);
        this.withWriteRetries(2);
        this.withReadRetries(2);
        this.withMaxRetryDelay(7000L, TimeUnit.MILLISECONDS);
    }

    public boolean isEncrypted() {
        return this.mIsEncrypted;
    }

    public HostPort[] getHostPorts() {
        return this.mHostPorts;
    }

    public DaxHostnameVerifier getHostVerifier() {
        return this.mHostVerifier;
    }

    public void setEndpoints(String ... hosts) {
        this.setEndpoints(false, hosts);
    }

    public void setEndpoints(boolean skipHostnameVerification, String ... hosts) {
        HostPort[] hostPort = new HostPort[hosts.length];
        boolean isEncrypted = false;
        for (int i = 0; i < hostPort.length; ++i) {
            HostPort h = HostPort.parse(hosts[i]);
            DaxHostnameVerifier hv = null;
            String scheme = h.scheme();
            if (isEncrypted != scheme.equals("daxs")) {
                if (i == 0) {
                    isEncrypted = true;
                } else {
                    throw new IllegalArgumentException("Inconsistency between the schemes of provided endpoints.");
                }
            }
            if (scheme.equals("daxs")) {
                if (i > 0) {
                    throw new IllegalArgumentException("Only one encrypted endpoint URL is allowed");
                }
                hv = !skipHostnameVerification ? new DaxHostnameVerifier(h.host()) : DaxHostnameVerifier.getNoOpVerifier();
            }
            hostPort[i] = h;
            this.mHostVerifier = hv;
        }
        if (!isEncrypted && skipHostnameVerification) {
            LOG.warn((Object)"Skipping hostname verification has no effect on unencrypted connections");
        }
        this.mHostPorts = hostPort;
        this.mIsEncrypted = isEncrypted;
    }

    public ClientConfig withEndpoints(String ... hosts) {
        this.setEndpoints(hosts);
        return this;
    }

    public ClientConfig withEndpoints(boolean skipHostnameVerification, String ... hosts) {
        this.setEndpoints(skipHostnameVerification, hosts);
        return this;
    }

    public long getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public void setConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.mConnectTimeout = ClientConfig.toNanos(connectTimeout, unit);
    }

    public ClientConfig withConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.setConnectTimeout(connectTimeout, unit);
        return this;
    }

    public long getRequestTimeout() {
        return this.mRequestTimeout;
    }

    public void setRequestTimeout(long RequestTimeout, TimeUnit unit) {
        this.mRequestTimeout = ClientConfig.toNanos(RequestTimeout, unit);
    }

    public ClientConfig withRequestTimeout(long RequestTimeout, TimeUnit unit) {
        this.setRequestTimeout(RequestTimeout, unit);
        return this;
    }

    public long getHealthCheckTimeout() {
        return this.mHealthCheckTimeout;
    }

    public void setHealthCheckTimeout(long healthCheckTimeout, TimeUnit unit) {
        this.mHealthCheckTimeout = ClientConfig.toNanos(healthCheckTimeout, unit);
    }

    public ClientConfig withHealthCheckTimeout(long healthCheckTimeout, TimeUnit unit) {
        this.setHealthCheckTimeout(healthCheckTimeout, unit);
        return this;
    }

    public long getHealthCheckInterval() {
        return this.mHealthCheckInterval;
    }

    public void setHealthCheckInterval(long healthCheckInterval, TimeUnit unit) {
        this.mHealthCheckInterval = ClientConfig.toNanos(healthCheckInterval, unit);
    }

    public ClientConfig withHealthCheckInterval(long healthCheckInterval, TimeUnit unit) {
        this.setHealthCheckInterval(healthCheckInterval, unit);
        return this;
    }

    public long getIdleConnectionTimeout() {
        return this.mIdleConnectionTimeout;
    }

    public void setIdleConnectionTimeout(long idleTimeout, TimeUnit unit) {
        this.mIdleConnectionTimeout = ClientConfig.toNanos(idleTimeout, unit);
    }

    public ClientConfig withIdleConnectionTimeout(long idleTimeout, TimeUnit unit) {
        this.setIdleConnectionTimeout(idleTimeout, unit);
        return this;
    }

    public int getMinIdleConnectionSize() {
        return this.mMinIdleConnectionSize;
    }

    public void setMinIdleConnectionSize(int size) {
        this.mMinIdleConnectionSize = size;
    }

    public ClientConfig withMinIdleConnectionSize(int size) {
        this.setMinIdleConnectionSize(size);
        return this;
    }

    public int getWriteRetries() {
        return this.mWriteRetries;
    }

    public void setWriteRetries(int writeRetries) {
        this.mWriteRetries = writeRetries;
    }

    public ClientConfig withWriteRetries(int writeRetries) {
        this.setWriteRetries(writeRetries);
        return this;
    }

    public int getMaxPendingConnectsPerHost() {
        return this.mMaxPendingConnectsPerHost;
    }

    public void setMaxPendingConnectsPerHost(int maxPending) {
        this.mMaxPendingConnectsPerHost = maxPending;
    }

    public ClientConfig withMaxPendingConnectsPerHost(int maxPending) {
        this.setMaxPendingConnectsPerHost(maxPending);
        return this;
    }

    public int getReadRetries() {
        return this.mReadRetries;
    }

    public void setReadRetries(int readRetries) {
        this.mReadRetries = readRetries;
    }

    public ClientConfig withReadRetries(int readRetries) {
        this.setReadRetries(readRetries);
        return this;
    }

    public long getThreadKeepAlive() {
        return this.mThreadKeepAlive;
    }

    public void setThreadKeepAlive(long threadKeepAlive, TimeUnit unit) {
        this.mThreadKeepAlive = ClientConfig.toNanos(threadKeepAlive, unit);
    }

    public ClientConfig withThreadKeepAlive(long threadKeepAlive, TimeUnit unit) {
        this.setThreadKeepAlive(threadKeepAlive, unit);
        return this;
    }

    public long getClusterUpdateInterval() {
        return this.mClusterUpdateInterval;
    }

    public void setClusterUpdateInterval(long clusterUpdateInterval, TimeUnit unit) {
        this.mClusterUpdateInterval = ClientConfig.toNanos(clusterUpdateInterval, unit);
    }

    public ClientConfig withClusterUpdateInterval(long clusterUpdateInterval, TimeUnit unit) {
        this.setClusterUpdateInterval(clusterUpdateInterval, unit);
        return this;
    }

    public long getClusterUpdateThreshold() {
        return this.mClusterUpdateThreshold;
    }

    public void setClusterUpdateThreshold(long clusterUpdateThreshold, TimeUnit unit) {
        this.mClusterUpdateThreshold = ClientConfig.toNanos(clusterUpdateThreshold, unit);
    }

    public ClientConfig withClusterUpdateThreshold(long clusterUpdateThreshold, TimeUnit unit) {
        this.setClusterUpdateThreshold(clusterUpdateThreshold, unit);
        return this;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.mProvider;
    }

    public void setCredentialsProvider(AWSCredentialsProvider provider) {
        this.mProvider = provider;
    }

    public ClientConfig withCredentialsProvider(AWSCredentialsProvider provider) {
        this.setCredentialsProvider(provider);
        return this;
    }

    public long getMaxRetryDelay() {
        return this.mMaxRetryDelay;
    }

    public void setMaxRetryDelay(long retryDelayCap, TimeUnit unit) {
        this.mMaxRetryDelay = ClientConfig.toNanos(retryDelayCap, unit);
    }

    public ClientConfig withMaxRetryDelay(long retryDelayCap, TimeUnit unit) {
        this.setMaxRetryDelay(retryDelayCap, unit);
        return this;
    }

    public String getRegion() {
        return this.mRegion;
    }

    public void setRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region must not be null");
        }
        this.setRegion(region.getName());
    }

    public void setRegion(String region) {
        if (StringUtils.isNullOrEmpty((String)region)) {
            throw new IllegalArgumentException("Region must not be null or empty");
        }
        this.mRegion = region;
    }

    public ClientConfig withRegion(Region region) {
        this.setRegion(region);
        return this;
    }

    public ClientConfig withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public int getUnhealthyConsecutiveErrorCount() {
        return this.mUnhealthyConsecutiveErrorCount;
    }

    public void setUnhealthyConsecutiveErrorCount(int errorCount) {
        this.mUnhealthyConsecutiveErrorCount = errorCount;
    }

    public ClientConfig withUnhealthyConsecutiveErrorCount(int errorCount) {
        this.setUnhealthyConsecutiveErrorCount(errorCount);
        return this;
    }

    private static long toNanos(long timeout, TimeUnit unit) {
        if (timeout > 0L) {
            timeout = unit.toNanos(timeout);
        }
        return timeout < 0L ? -1L : timeout;
    }
}

