/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.Encoder;
import com.amazon.cbor.SegmentPool;
import com.amazon.cbor.Utils;
import com.amazon.dax.Constants;
import com.amazon.dax.bits.DaxCborInputStream;
import com.amazon.dax.bits.SegmentPool;
import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.bits.expr.ExpressionType;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.DaxConnector;
import com.amazon.dax.client.DaxConnectorBase;
import com.amazon.dax.client.DaxHostnameVerifier;
import com.amazon.dax.client.DaxTlsConnector;
import com.amazon.dax.client.SessionVersion;
import com.amazon.dax.client.SocketTubePool;
import com.amazon.dax.client.TubePool;
import com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import com.amazon.dax.client.dynamodbv2.AmazonDaxClient;
import com.amazon.dax.client.dynamodbv2.AttributeValueDecoder;
import com.amazon.dax.client.dynamodbv2.AttributeValueEncoder;
import com.amazon.dax.client.dynamodbv2.ClientConfig;
import com.amazon.dax.client.dynamodbv2.DaxResponseDecoder;
import com.amazon.dax.client.dynamodbv2.DocumentPath;
import com.amazon.dax.client.dynamodbv2.DynamoDBExpressionInfo;
import com.amazon.dax.client.dynamodbv2.DynamoDBV1Converter;
import com.amazon.dax.client.dynamodbv2.DynamoDbObjectHelpers;
import com.amazon.dax.client.dynamodbv2.ExceptionListener;
import com.amazon.dax.client.dynamodbv2.ExceptionTranslator;
import com.amazon.dax.client.dynamodbv2.RefreshingCache;
import com.amazon.dax.client.dynamodbv2.RequestValidator;
import com.amazon.dax.client.dynamodbv2.SimpleCache;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazon.dax.client.exceptions.DaxTransactionCanceledException;
import com.amazon.dax.client.exceptions.MalformedResultException;
import com.amazon.dax.client.generated.DaxClientStubs;
import com.amazon.dax.client.retry.DaxBackoffStrategy;
import com.amazon.dax.client.retry.ReadRetryHandler;
import com.amazon.dax.client.retry.RetryHandler;
import com.amazon.dax.client.retry.WriteRetryHandler;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.services.dynamodbv2.AbstractAmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionCheck;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.Delete;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.Get;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TransactGetItem;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactionCanceledException;
import com.amazonaws.services.dynamodbv2.model.Update;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.waiters.AmazonDynamoDBWaiters;
import com.amazonaws.util.CollectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class DaxClient
extends AbstractAmazonDynamoDB
implements AmazonDaxClient {
    public static final String KEY_CACHE_TTL_MILLIS_PROPERTY = DaxClient.class.getCanonicalName() + ".KEY_CACHE_TTL_MILLIS";
    private static final String USER_AGENT_PREFIX = "DaxJavaClient-";
    private static final String CLIENT_VERSION_UNKNOWN = "unknown";
    private static final String USER_AGENT;
    private static final String TXN_VALIDATION_ERROR_MSG = "transactItems.%d.member.%s.%s";
    private final DaxClientStubs mStubs;
    private final RefreshingCache<String, List<AttributeDefinition>> mKeyCache;
    private SimpleCache<Long, List<String>> mAttrListCache;
    private final SimpleCache<List<String>, Long> mAttrListIdCache;
    private final SegmentPool mSegPool;
    private final TubePool mTubePool;
    private final AWSCredentialsProvider mCreds;
    private static final int CACHE_SIZE = 1000;
    private static final int MAX_WRITE_BATCH_SIZE = 25;
    private static final Constants.DaxResponseParam[] RESPONSE_PARAMS;
    private static final int DEFAULT_ITEM_LIMIT = 100;
    public final long KEY_CACHE_TTL_MILLIS = Long.getLong(KEY_CACHE_TTL_MILLIS_PROPERTY, 60000L);
    private static final String DEFAULT_REGION = "us-east-1";
    private final int mReadRetryCount;
    private final int mWriteRetryCount;
    private final BackoffStrategy mBackoffStrategy;
    private final Supplier<RetryHandler> mReadRetryHandlerSupplier;
    private final Supplier<RetryHandler> mWriteRetryHandlerSupplier;
    protected ExceptionListener mExceptionListener;

    public static DaxClient newTestInstance(String hostname, int port) throws Exception {
        return DaxClient.newTestInstance(hostname, port, null, null);
    }

    public static DaxClient newTestInstance(String hostname, int port, String region, ExceptionListener exceptionListener) throws Exception {
        AWSCredentialsProvider testCredentials = new AWSCredentialsProvider(){
            private final AWSCredentials mCreds = new BasicAWSCredentials("ACCESS_KEY", "SECRET_KEY");

            public AWSCredentials getCredentials() {
                return this.mCreds;
            }

            public void refresh() {
            }
        };
        return new DaxClient(new SocketTubePool(hostname, port, DaxClient.getUserAgent()), region, testCredentials, exceptionListener);
    }

    public DaxClient(TubePool tubePool, String region, AWSCredentialsProvider credentialsProvider, int readRetries, int writeRetries) throws IOException {
        this(tubePool, region, credentialsProvider, null, readRetries, writeRetries, null);
    }

    public DaxClient(String hostname, int port) throws IOException {
        this(hostname, port, null);
    }

    public DaxClient(String hostname, int port, AWSCredentialsProvider credsProvider) throws IOException {
        this(hostname, port, null, credsProvider);
    }

    public DaxClient(String hostname, int port, String region, AWSCredentialsProvider credsProvider) throws IOException {
        this(new SocketTubePool(hostname, port, DaxClient.getUserAgent()), region, credsProvider, null);
    }

    public DaxClient(String hostname, int port, String region, AWSCredentialsProvider credsProvider, long tubeTtlMs, int readRetryCount, int writeRetryCount) throws IOException {
        this(new SocketTubePool(hostname, port, DaxClient.getUserAgent(), tubeTtlMs), region, credsProvider, null, readRetryCount, writeRetryCount, null);
    }

    public DaxClient(TubePool pool, AWSCredentialsProvider creds) {
        this(pool, null, creds, null);
    }

    public DaxClient(TubePool pool, String region, AWSCredentialsProvider creds, ExceptionListener el) {
        this(pool, region, creds, el, 0, 0, null);
    }

    DaxClient(TubePool pool, String region, AWSCredentialsProvider creds, ExceptionListener el, int readRetryCount, int writeRetryCount, BackoffStrategy backoffStrategy) {
        this.mCreds = creds != null ? creds : new DefaultAWSCredentialsProviderChain();
        this.mTubePool = pool;
        if (region == null) {
            region = DEFAULT_REGION;
        }
        this.mStubs = new DaxClientStubs(this.mTubePool, region, USER_AGENT, this.mCreds);
        this.mSegPool = SegmentPool.withCapacity(1024);
        this.mKeyCache = new RefreshingCache<String, List<AttributeDefinition>>(1000, new RefreshingCache.Fetcher<String, List<AttributeDefinition>>(){

            @Override
            public List<AttributeDefinition> fetch(String key) throws AmazonClientException {
                return DaxClient.this.defineKeySchema(key);
            }
        }, this.KEY_CACHE_TTL_MILLIS);
        this.mAttrListCache = new SimpleCache<Long, List<String>>(1000){

            @Override
            protected List<String> fetch(Long key) throws AmazonClientException {
                return DaxClient.this.defineAttributeList(key);
            }
        };
        this.mAttrListIdCache = new SimpleCache<List<String>, Long>(1000){

            @Override
            protected Long fetch(List<String> key) throws AmazonClientException {
                return DaxClient.this.defineAttributeListId(key);
            }
        };
        this.mExceptionListener = el;
        this.mReadRetryCount = readRetryCount;
        this.mWriteRetryCount = writeRetryCount;
        this.mBackoffStrategy = backoffStrategy == null ? new DaxBackoffStrategy() : backoffStrategy;
        this.mReadRetryHandlerSupplier = new Supplier<RetryHandler>(){

            @Override
            public RetryHandler get() throws AmazonClientException {
                return new ReadRetryHandler(DaxClient.this.mBackoffStrategy, DaxClient.this.mReadRetryCount);
            }
        };
        this.mWriteRetryHandlerSupplier = new Supplier<RetryHandler>(){

            @Override
            public RetryHandler get() throws AmazonClientException {
                return new WriteRetryHandler(DaxClient.this.mBackoffStrategy, DaxClient.this.mWriteRetryCount);
            }
        };
    }

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public void setEndpoint(String endpoint) {
        throw new UnsupportedOperationException("setEndpoint(String) is not supported for cache client");
    }

    public void setRegion(Region region) {
        if (region == null) {
            throw new AmazonClientException("Region must not be null");
        }
        this.setRegion(region.getName());
    }

    @Override
    public void setRegion(String region) {
        if (region == null || region.isEmpty()) {
            throw new AmazonClientException("Region must contain a valid name, found: " + region);
        }
        this.mStubs.setRegion(region);
    }

    void setAuthTTLMillis(long authTTLMillis) {
        this.mStubs.setAuthTTLMillis(authTTLMillis);
    }

    void setAttrListCache(SimpleCache<Long, List<String>> attrListCache) {
        this.mAttrListCache = attrListCache;
    }

    private <R> R invoke(Supplier<R> operation, Supplier<RetryHandler> retryHandlerSupplier) throws AmazonClientException {
        RetryHandler retryHandler = retryHandlerSupplier.get();
        while (true) {
            retryHandler.beforeRequest();
            try {
                R res = operation.get();
                if (this.mExceptionListener != null) {
                    this.mExceptionListener.onSuccess();
                }
                return res;
            }
            catch (AmazonClientException lastException) {
                retryHandler.onException(lastException);
                if (this.mExceptionListener != null && !(lastException.getCause() instanceof IOException)) {
                    this.mExceptionListener.onSuccess();
                }
                if (!retryHandler.canRetry()) {
                    throw retryHandler.lastException();
                }
                retryHandler.pauseBeforeRetry();
                continue;
            }
            break;
        }
    }

    public CreateTableResult createTable(CreateTableRequest request) throws AmazonClientException {
        CreateTableResult createTableResult;
        SegmentPool.Segment headSegment;
        ClientTube tube = null;
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        RequestValidator.validateCreateTableRequest(request);
        SegmentPool.Segment segment = headSegment = this.mSegPool.alloc();
        try {
            List gsis;
            String hash;
            AttributeDefinition[] keyNames;
            segment = this.mSegPool.chainAppendCborMapStreamPrefix(segment);
            segment = this.mSegPool.chainAppendCborString(segment, "TableName");
            segment = this.mSegPool.chainAppendCborString(segment, request.getTableName());
            segment = this.writeKeySchema(segment, request.getKeySchema());
            String range = "";
            if (request.getKeySchema().size() == 1) {
                keyNames = new AttributeDefinition[1];
                hash = ((KeySchemaElement)request.getKeySchema().get(0)).getAttributeName();
            } else {
                keyNames = new AttributeDefinition[2];
                if (((KeySchemaElement)request.getKeySchema().get(0)).getKeyType().equals("HASH")) {
                    hash = ((KeySchemaElement)request.getKeySchema().get(0)).getAttributeName();
                    range = ((KeySchemaElement)request.getKeySchema().get(1)).getAttributeName();
                } else {
                    hash = ((KeySchemaElement)request.getKeySchema().get(1)).getAttributeName();
                    range = ((KeySchemaElement)request.getKeySchema().get(0)).getAttributeName();
                }
            }
            segment = this.mSegPool.chainAppendCborString(segment, "AttributeDefinitions");
            List aDefs = request.getAttributeDefinitions();
            segment = this.mSegPool.chainAppendCborArrayPrefix(segment, aDefs.size());
            for (Object ad : aDefs) {
                segment = this.mSegPool.chainAppendCborMapPrefix(segment, 2);
                segment = this.mSegPool.chainAppendCborString(segment, "AttributeName");
                segment = this.mSegPool.chainAppendCborString(segment, ad.getAttributeName());
                segment = this.mSegPool.chainAppendCborString(segment, "AttributeType");
                segment = this.mSegPool.chainAppendCborString(segment, ad.getAttributeType());
                if (ad.getAttributeName().equals(hash)) {
                    keyNames[0] = ad;
                    continue;
                }
                if (!ad.getAttributeName().equals(range)) continue;
                keyNames[1] = ad;
            }
            List lsis = request.getLocalSecondaryIndexes();
            if (lsis != null && !lsis.isEmpty()) {
                segment = this.mSegPool.chainAppendCborString(segment, "LocalSecondaryIndexes");
                segment = this.mSegPool.chainAppendCborArrayPrefix(segment, lsis.size());
                for (LocalSecondaryIndex lsi : lsis) {
                    RequestValidator.validateLocalSecondaryIndex(lsi);
                    segment = this.writeIndex(segment, lsi.getIndexName(), lsi.getKeySchema(), lsi.getProjection());
                }
            }
            if ((gsis = request.getGlobalSecondaryIndexes()) != null && !gsis.isEmpty()) {
                segment = this.mSegPool.chainAppendCborString(segment, "GlobalSecondaryIndexes");
                segment = this.mSegPool.chainAppendCborArrayPrefix(segment, gsis.size());
                for (GlobalSecondaryIndex gsi : gsis) {
                    RequestValidator.validateGlobalSecondaryIndex(gsi);
                    segment = this.writeIndex(segment, gsi.getIndexName(), gsi.getKeySchema(), gsi.getProjection(), gsi.getProvisionedThroughput());
                }
            }
            ProvisionedThroughput pt = request.getProvisionedThroughput();
            segment = this.writeProvisionedThroughput(pt, segment);
            this.mSegPool.chainAppendCborStreamBreak(segment);
            tube = this.mStubs.createTable_N313431286_1(this.mSegPool.chainCopyAndTrim(headSegment, 0));
            DaxCborInputStream input = tube.getInputStream();
            TableDescription description = DynamoDbObjectHelpers.readTableDescription(input);
            this.mKeyCache.put(request.getTableName(), Arrays.asList(keyNames));
            createTableResult = new CreateTableResult().withTableDescription(description);
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(headSegment);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(headSegment);
        this.mTubePool.recycle(tube);
        return createTableResult;
    }

    SegmentPool.Segment writeKeySchema(SegmentPool.Segment segment, List<KeySchemaElement> kses) throws IOException {
        RequestValidator.validateNotNull(kses, "keySchemaElements");
        segment = this.mSegPool.chainAppendCborString(segment, "KeySchema");
        segment = this.mSegPool.chainAppendCborArrayPrefix(segment, kses.size());
        for (KeySchemaElement kse : kses) {
            RequestValidator.validateNotNull(kse, "keySchemaElement");
            segment = this.mSegPool.chainAppendCborMapPrefix(segment, 2);
            segment = this.mSegPool.chainAppendCborString(segment, "AttributeName");
            segment = this.mSegPool.chainAppendCborString(segment, kse.getAttributeName());
            segment = this.mSegPool.chainAppendCborString(segment, "KeyType");
            segment = this.mSegPool.chainAppendCborString(segment, kse.getKeyType());
        }
        return segment;
    }

    SegmentPool.Segment writeIndex(SegmentPool.Segment segment, String indexName, List<KeySchemaElement> kses, Projection proj) throws IOException {
        return this.writeIndex(segment, indexName, kses, proj, null);
    }

    SegmentPool.Segment writeIndex(SegmentPool.Segment segment, String indexName, List<KeySchemaElement> kses, Projection proj, ProvisionedThroughput pt) throws IOException {
        segment = this.mSegPool.chainAppendCborMapPrefix(segment, pt == null ? 3 : 4);
        segment = this.mSegPool.chainAppendCborString(segment, "IndexName");
        segment = this.mSegPool.chainAppendCborString(segment, indexName);
        segment = this.writeKeySchema(segment, kses);
        segment = this.mSegPool.chainAppendCborString(segment, "Projection");
        segment = this.mSegPool.chainAppendCborMapPrefix(segment, 2);
        segment = this.mSegPool.chainAppendCborString(segment, "NonKeyAttributes");
        if (proj.getNonKeyAttributes() == null) {
            segment = this.mSegPool.chainAppend(segment, (byte)-10);
        } else {
            segment = this.mSegPool.chainAppendCborArrayPrefix(segment, proj.getNonKeyAttributes().size());
            for (String s : proj.getNonKeyAttributes()) {
                segment = this.mSegPool.chainAppendCborString(segment, s);
            }
        }
        segment = this.mSegPool.chainAppendCborString(segment, "ProjectionType");
        segment = this.mSegPool.chainAppendCborString(segment, proj.getProjectionType());
        if (pt != null) {
            segment = this.writeProvisionedThroughput(pt, segment);
        }
        return segment;
    }

    private SegmentPool.Segment writeProvisionedThroughput(ProvisionedThroughput pt, SegmentPool.Segment segment) {
        if (pt != null) {
            segment = this.mSegPool.chainAppendCborString(segment, "ProvisionedThroughput");
            segment = this.mSegPool.chainAppendCborMapPrefix(segment, 2);
            segment = this.mSegPool.chainAppendCborString(segment, "ReadCapacityUnits");
            segment = this.mSegPool.chainAppendCborInteger(segment, pt.getReadCapacityUnits());
            segment = this.mSegPool.chainAppendCborString(segment, "WriteCapacityUnits");
            segment = this.mSegPool.chainAppendCborInteger(segment, pt.getWriteCapacityUnits());
        }
        return segment;
    }

    private SegmentPool.Segment writeAttributeDefinitions(List<AttributeDefinition> aDefs, SegmentPool.Segment segment) {
        if (aDefs != null) {
            segment = this.mSegPool.chainAppendCborString(segment, "AttributeDefinitions");
            segment = this.mSegPool.chainAppendCborArrayPrefix(segment, aDefs.size());
            for (AttributeDefinition ad : aDefs) {
                segment = this.mSegPool.chainAppendCborMapPrefix(segment, 2);
                segment = this.mSegPool.chainAppendCborString(segment, "AttributeName");
                segment = this.mSegPool.chainAppendCborString(segment, ad.getAttributeName());
                segment = this.mSegPool.chainAppendCborString(segment, "AttributeType");
                segment = this.mSegPool.chainAppendCborString(segment, ad.getAttributeType());
            }
        }
        return segment;
    }

    public CreateTableResult createTable(List<AttributeDefinition> attributeDefinitions, String table, List<KeySchemaElement> keySchema, ProvisionedThroughput pv) throws AmazonClientException {
        return this.createTable(new CreateTableRequest(attributeDefinitions, table, keySchema, pv));
    }

    public UpdateTableResult updateTable(UpdateTableRequest request) throws AmazonClientException {
        SegmentPool.Segment head;
        SegmentPool.Segment seg = head = this.mSegPool.alloc();
        ClientTube tube = null;
        try {
            this.validateRequestCredentials((AmazonWebServiceRequest)request);
            RequestValidator.validateTableName(request.getTableName());
            RequestValidator.validate(request.getProvisionedThroughput());
            seg = this.mSegPool.chainAppendCborMapStreamPrefix(seg);
            seg = this.mSegPool.chainAppendCborString(seg, "TableName");
            seg = this.mSegPool.chainAppendCborString(seg, request.getTableName());
            List aDefs = request.getAttributeDefinitions();
            seg = this.writeAttributeDefinitions(aDefs, seg);
            List updates = request.getGlobalSecondaryIndexUpdates();
            if (updates != null) {
                seg = this.mSegPool.chainAppendCborString(seg, "GlobalSecondaryIndexUpdates");
                seg = this.mSegPool.chainAppendCborArrayPrefix(seg, updates.size());
                seg = this.writeGSIUpdates(updates, seg);
            }
            ProvisionedThroughput pt = request.getProvisionedThroughput();
            seg = this.writeProvisionedThroughput(pt, seg);
            StreamSpecification spec = request.getStreamSpecification();
            if (spec != null) {
                seg = this.mSegPool.chainAppendCborString(seg, "StreamSpecification");
                seg = this.mSegPool.chainAppendCborMapPrefix(seg, 2);
                seg = this.mSegPool.chainAppendCborString(seg, "StreamEnabled");
                seg = this.mSegPool.chainAppend(seg, (byte)(spec.getStreamEnabled() != false ? 245 : 244));
                seg = this.mSegPool.chainAppendCborString(seg, "StreamViewType");
                seg = this.mSegPool.chainAppendCborString(seg, spec.getStreamViewType());
            }
            seg = this.mSegPool.chainAppendCborStreamBreak(seg);
            tube = this.mStubs.updateTable_383747477_1(this.mSegPool.chainCopyAndRecycle(head, 0));
            DaxCborInputStream input = tube.getInputStream();
            TableDescription description = DynamoDbObjectHelpers.readTableDescription(input);
            UpdateTableResult updateTableResult = new UpdateTableResult().withTableDescription(description);
            this.mTubePool.recycle(tube);
            return updateTableResult;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
    }

    private SegmentPool.Segment writeGSIUpdates(List<GlobalSecondaryIndexUpdate> updates, SegmentPool.Segment seg) throws IOException {
        for (GlobalSecondaryIndexUpdate update : updates) {
            CreateGlobalSecondaryIndexAction action;
            if (update.getCreate() != null) {
                seg = this.mSegPool.chainAppendCborArrayPrefix(seg, 2);
                seg = this.mSegPool.chainAppendCborInteger(seg, DynamoNumerals.GSIUpdate.CREATE.mCode);
                action = update.getCreate();
                seg = this.writeIndex(seg, action.getIndexName(), action.getKeySchema(), action.getProjection(), action.getProvisionedThroughput());
                continue;
            }
            if (update.getDelete() != null) {
                seg = this.mSegPool.chainAppendCborArrayPrefix(seg, 2);
                seg = this.mSegPool.chainAppendCborInteger(seg, DynamoNumerals.GSIUpdate.DELETE.mCode);
                seg = this.mSegPool.chainAppendCborString(seg, update.getDelete().getIndexName());
                continue;
            }
            if (update.getUpdate() == null) continue;
            seg = this.mSegPool.chainAppendCborArrayPrefix(seg, 3);
            seg = this.mSegPool.chainAppendCborInteger(seg, DynamoNumerals.GSIUpdate.UPDATE.mCode);
            action = update.getUpdate();
            seg = this.mSegPool.chainAppendCborString(seg, action.getIndexName());
            seg = this.mSegPool.chainAppendCborMapPrefix(seg, 2);
            seg = this.mSegPool.chainAppendCborString(seg, "ReadCapacityUnits");
            seg = this.mSegPool.chainAppendCborInteger(seg, action.getProvisionedThroughput().getReadCapacityUnits());
            seg = this.mSegPool.chainAppendCborString(seg, "WriteCapacityUnits");
            seg = this.mSegPool.chainAppendCborInteger(seg, action.getProvisionedThroughput().getWriteCapacityUnits());
        }
        return seg;
    }

    public UpdateTableResult updateTable(String table, ProvisionedThroughput pv) throws AmazonClientException {
        return this.updateTable(new UpdateTableRequest(table, pv));
    }

    public DeleteTableResult deleteTable(DeleteTableRequest request) throws AmazonClientException {
        String tableName = request.getTableName();
        ClientTube tube = null;
        try {
            this.validateRequestCredentials((AmazonWebServiceRequest)request);
            RequestValidator.validateTableName(request.getTableName());
            tube = this.mStubs.deleteTable_2120496185_1(Encoder.encodeUtf8(tableName));
            DaxCborInputStream input = tube.getInputStream();
            TableDescription table = DynamoDbObjectHelpers.readTableDescription(input);
            DeleteTableResult deleteTableResult = new DeleteTableResult().withTableDescription(table);
            this.mTubePool.recycle(tube);
            return deleteTableResult;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
    }

    public DeleteTableResult deleteTable(String table) throws AmazonClientException {
        return this.deleteTable(new DeleteTableRequest(table));
    }

    public DescribeLimitsResult describeLimits(DescribeLimitsRequest describeLimitsRequest) throws AmazonClientException {
        ClientTube tube = null;
        try {
            this.validateRequestCredentials((AmazonWebServiceRequest)describeLimitsRequest);
            tube = this.mStubs.describeLimits_N475661135_1();
            DaxCborInputStream in = tube.getInputStream();
            int len = in.readArrayLength();
            if (len != 4) {
                throw new UnsupportedEncodingException("Expected 4 fields from server. Received only " + len);
            }
            DescribeLimitsResult result = new DescribeLimitsResult();
            result.withAccountMaxReadCapacityUnits(Long.valueOf(in.readLong()));
            result.withAccountMaxWriteCapacityUnits(Long.valueOf(in.readLong()));
            result.withTableMaxReadCapacityUnits(Long.valueOf(in.readLong()));
            result.withTableMaxWriteCapacityUnits(Long.valueOf(in.readLong()));
            DescribeLimitsResult describeLimitsResult = result;
            this.mTubePool.recycle(tube);
            return describeLimitsResult;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
    }

    public DescribeTableResult describeTable(DescribeTableRequest request) throws AmazonClientException {
        String tableName = request.getTableName();
        ClientTube tube = null;
        try {
            this.validateRequestCredentials((AmazonWebServiceRequest)request);
            RequestValidator.validateTableName(request.getTableName());
            tube = this.mStubs.describeTable_N819330193_1(Encoder.encodeUtf8(tableName));
            DaxCborInputStream input = tube.getInputStream();
            TableDescription table = DynamoDbObjectHelpers.readTableDescription(input);
            DescribeTableResult describeTableResult = new DescribeTableResult().withTable(table);
            this.mTubePool.recycle(tube);
            return describeTableResult;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
    }

    public DescribeTableResult describeTable(String table) throws AmazonClientException {
        return this.describeTable(new DescribeTableRequest(table));
    }

    public GetItemResult getItem(final GetItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<GetItemResult>(){

            @Override
            public GetItemResult get() {
                return DaxClient.this.executeGetItem(request);
            }
        }, this.mReadRetryHandlerSupplier);
    }

    GetItemResult executeGetItem(GetItemRequest request) throws AmazonClientException {
        GetItemResult getItemResult;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(null, null, request.getProjectionExpression(), null, null, null, null, null, request.getAttributesToGet(), null, null, null, request.getExpressionAttributeNames(), null);
        SegmentPool.Segment keyHead = this.mSegPool.alloc();
        String tableName = request.getTableName();
        List<AttributeDefinition> keys = this.mKeyCache.get(tableName);
        ClientTube tube = null;
        try {
            boolean hasKwargs;
            SegmentPool.Segment keyTail = AttributeValueEncoder.validateAndEncodeKey(this.mSegPool, keyHead, request.getKey(), keys);
            byte[] kwargs = null;
            Map<Integer, DocumentPath> projectionOrdinals = null;
            boolean bl = hasKwargs = request.getAttributesToGet() != null || request.getConsistentRead() != null || request.getProjectionExpression() != null || request.getReturnConsumedCapacity() != null;
            if (hasKwargs) {
                AtomicReference<Map<Integer, DocumentPath>> projectionOrdinalsRef = new AtomicReference<Map<Integer, DocumentPath>>();
                kwargs = this.encodeGetItemKwargs(request, projectionOrdinalsRef);
                projectionOrdinals = projectionOrdinalsRef.get();
            }
            tube = this.mStubs.getItem_263244906_1(Encoder.encodeUtf8(tableName), this.mSegPool.chainCopyAndTrim(keyHead, 0), kwargs);
            DaxCborInputStream input = tube.getInputStream();
            GetItemResult result = this.decodeGetItemResult(input, request.getKey(), projectionOrdinals);
            if (DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity()) != DynamoNumerals.ReturnConsumedCapacity.NONE && null == result.getConsumedCapacity()) {
                result.setConsumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(tableName));
            }
            getItemResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(keyHead);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(keyHead);
        this.mTubePool.recycle(tube);
        return getItemResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodeGetItemKwargs(GetItemRequest request, AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals) {
        SegmentPool.Segment kwargsHead = this.mSegPool.alloc();
        try {
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity;
            Object object;
            DynamoDBExpressionInfo exp = null;
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            String projectionExpression = exp.getProjectionExpression();
            Map<String, String> expressionAttributeNames = exp.getExpressionAttributeNames();
            SegmentPool.Segment kwargsTail = kwargsHead;
            kwargsTail = this.mSegPool.chainAppendCborMapStreamPrefix(kwargsTail);
            if (projectionExpression != null) {
                projectionOrdinals.compareAndSet(null, new HashMap());
                byte[] projection = AttributeValueEncoder.encodeProjection(projectionExpression, expressionAttributeNames);
                AttributeValueEncoder.prepareProjection(projectionExpression, expressionAttributeNames, projectionOrdinals.get());
                kwargsTail = this.mSegPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ProjectionExpression.ordinal());
                kwargsTail = this.mSegPool.chainAppendCborBytes(kwargsTail, projection);
                if (expressionAttributeNames != null) {
                    kwargsTail = this.mSegPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ExpressionAttributeNames.ordinal());
                    kwargsTail = this.mSegPool.chainAppendCborMapPrefix(kwargsTail, expressionAttributeNames.size());
                    object = expressionAttributeNames.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry name = (Map.Entry)object.next();
                        kwargsTail = this.mSegPool.chainAppendCborString(kwargsTail, (String)name.getKey());
                        kwargsTail = this.mSegPool.chainAppendCborString(kwargsTail, (String)name.getValue());
                    }
                }
            }
            if (request.getConsistentRead() != null && request.getConsistentRead().booleanValue()) {
                kwargsTail = this.mSegPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ConsistentRead.ordinal());
                kwargsTail = this.mSegPool.chainAppend(kwargsTail, (byte)-11);
            }
            if ((returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity())) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                kwargsTail = this.mSegPool.chainAppendCborInteger(kwargsTail, Constants.DaxDataRequestParam.ReturnConsumedCapacity.ordinal());
                kwargsTail = this.mSegPool.chainAppendCborInteger(kwargsTail, returnConsumedCapacity.mCode);
            }
            this.mSegPool.chainAppendCborStreamBreak(kwargsTail);
            object = this.mSegPool.chainCopyAndTrim(kwargsHead, 0);
            return object;
        }
        finally {
            this.mSegPool.chainRecycle(kwargsHead);
        }
    }

    private GetItemResult decodeGetItemResult(DaxCborInputStream input, Map<String, AttributeValue> key, Map<Integer, DocumentPath> projectionOrdinals) throws IOException {
        GetItemResult result = new GetItemResult();
        if (input.tryReadNull()) {
            return result;
        }
        int i = input.streamMapLength();
        while (input.itemsRemaining(i)) {
            int paramId = input.readInt();
            Constants.DaxResponseParam param = RESPONSE_PARAMS[paramId];
            this.decodeGetItemResultEntry(param, input, result, key, projectionOrdinals);
            --i;
        }
        return result;
    }

    private void decodeGetItemResultEntry(Constants.DaxResponseParam param, DaxCborInputStream input, GetItemResult result, Map<String, AttributeValue> key, Map<Integer, DocumentPath> projectionOrdinals) throws IOException {
        switch (param) {
            case Item: {
                Map<String, AttributeValue> item = AttributeValueDecoder.decodeValue(input, this.mAttrListCache, projectionOrdinals);
                if (item == null) break;
                if (projectionOrdinals == null) {
                    item.putAll(key);
                }
                result.setItem(item);
                break;
            }
            case ConsumedCapacity: {
                result.setConsumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(input));
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Unknown value type: " + param.name());
            }
        }
    }

    public GetItemResult getItem(String table, Map<String, AttributeValue> key) throws AmazonClientException {
        return this.getItem(new GetItemRequest(table, key));
    }

    public GetItemResult getItem(String table, Map<String, AttributeValue> key, Boolean consistentRead) throws AmazonClientException {
        return this.getItem(new GetItemRequest(table, key, consistentRead));
    }

    public BatchGetItemResult batchGetItem(final BatchGetItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult get() {
                return DaxClient.this.executeBatchGetItem(request);
            }
        }, this.mReadRetryHandlerSupplier);
    }

    BatchGetItemResult executeBatchGetItem(BatchGetItemRequest request) throws AmazonClientException {
        BatchGetItemResult batchGetItemResult;
        SegmentPool.Segment requestTail;
        RequestValidator.validate(request);
        SegmentPool.Segment requestHead = requestTail = this.mSegPool.alloc();
        SegmentPool.Segment keyHead = this.mSegPool.alloc();
        HashMap<String, Map<Integer, DocumentPath>> tableProjOrdinals = new HashMap<String, Map<Integer, DocumentPath>>();
        HashMap<String, List<AttributeDefinition>> keysPerTable = new HashMap<String, List<AttributeDefinition>>();
        ClientTube tube = null;
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(UnsignedComparator.INSTANCE);
        Map requestByTable = request.getRequestItems();
        try {
            requestTail = this.mSegPool.chainAppendCborMapPrefix(requestTail, requestByTable.size());
            for (Map.Entry tableAndRequest : requestByTable.entrySet()) {
                Map<String, String> expressionAttributeNames;
                String tableName = (String)tableAndRequest.getKey();
                KeysAndAttributes kaas = (KeysAndAttributes)tableAndRequest.getValue();
                requestTail = this.mSegPool.chainAppendCborString(requestTail, tableName);
                requestTail = this.mSegPool.chainAppendCborArrayPrefix(requestTail, 3);
                requestTail = kaas.getConsistentRead() == null || kaas.getConsistentRead() == false ? this.mSegPool.chainAppend(requestTail, (byte)-12) : this.mSegPool.chainAppend(requestTail, (byte)-11);
                DynamoDBExpressionInfo exp = null;
                exp = DynamoDBV1Converter.isV1Request(kaas) ? DynamoDBV1Converter.convertV1RequestToV2(kaas) : new DynamoDBExpressionInfo(kaas);
                String projectionExpression = exp.getProjectionExpression();
                byte[] proj = AttributeValueEncoder.encodeProjection(projectionExpression, expressionAttributeNames = exp.getExpressionAttributeNames());
                if (proj != null) {
                    Map<Integer, DocumentPath> projOrdinals = AttributeValueEncoder.prepareProjection(exp);
                    requestTail = this.mSegPool.chainAppendCborBytes(requestTail, proj);
                    tableProjOrdinals.put(tableName, projOrdinals);
                } else {
                    requestTail = this.mSegPool.chainAppend(requestTail, (byte)-10);
                }
                List keys = kaas.getKeys() == null ? Collections.emptyList() : kaas.getKeys();
                requestTail = this.mSegPool.chainAppendCborArrayPrefix(requestTail, keys.size());
                List<AttributeDefinition> tableKeys = this.mKeyCache.get(tableName);
                keysPerTable.put(tableName, tableKeys);
                keySet.clear();
                for (Map key : keys) {
                    AttributeValueEncoder.validateAndEncodeKey(this.mSegPool, keyHead, key, tableKeys);
                    byte[] encodedKey = this.mSegPool.chainCopyAndTrim(keyHead, 0);
                    if (!keySet.add(encodedKey)) {
                        throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                    }
                    requestTail = this.mSegPool.chainAppendCborBytes(requestTail, encodedKey);
                }
            }
            byte[] kwargs = null;
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            EnumMap<Constants.DaxDataRequestParam, Integer> optionalArgs = null;
            if (returnConsumedCapacity.mCode != DynamoNumerals.ReturnConsumedCapacity.NONE.mCode) {
                optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Integer>(Constants.DaxDataRequestParam.class);
                optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, returnConsumedCapacity.mCode);
            }
            kwargs = DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.mSegPool);
            tube = this.mStubs.batchGetItem_N697851100_1(this.mSegPool.chainCopyAndTrim(requestHead, 0), kwargs);
            DaxCborInputStream input = tube.getInputStream();
            int arrayLen = input.readArrayLength();
            if (arrayLen != 2) {
                throw new UnsupportedEncodingException("BatchGetResponse needs to have two elements, instead had: " + arrayLen);
            }
            BatchGetItemResult result = AttributeValueDecoder.decodeBatchGet(input, keysPerTable, this.mAttrListCache, tableProjOrdinals);
            for (Map.Entry entry : result.getUnprocessedKeys().entrySet()) {
                String tableName = (String)entry.getKey();
                KeysAndAttributes kaasOut = (KeysAndAttributes)entry.getValue();
                KeysAndAttributes kaasIn = (KeysAndAttributes)requestByTable.get(tableName);
                kaasOut.setProjectionExpression(kaasIn.getProjectionExpression());
                kaasOut.setConsistentRead(kaasIn.getConsistentRead());
                kaasOut.setAttributesToGet((Collection)kaasIn.getAttributesToGet());
                kaasOut.setExpressionAttributeNames(kaasIn.getExpressionAttributeNames());
            }
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(this.verifyBatchConsumedCapacity(result.getConsumedCapacity(), requestByTable.keySet()));
            }
            batchGetItemResult = result;
        }
        catch (Throwable t) {
            try {
                throw this.handleException(t, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.recycle(keyHead);
                this.mSegPool.recycle(requestHead);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.recycle(keyHead);
        this.mSegPool.recycle(requestHead);
        this.mTubePool.recycle(tube);
        return batchGetItemResult;
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> request) throws AmazonClientException {
        return this.batchGetItem(new BatchGetItemRequest(request));
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> request, String returnConsumedCapacity) throws AmazonClientException {
        return this.batchGetItem(new BatchGetItemRequest(request, returnConsumedCapacity));
    }

    public PutItemResult putItem(final PutItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<PutItemResult>(){

            @Override
            public PutItemResult get() {
                return DaxClient.this.executePutItem(request);
            }
        }, this.mWriteRetryHandlerSupplier);
    }

    PutItemResult executePutItem(PutItemRequest request) throws AmazonClientException {
        PutItemResult putItemResult;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(request.getConditionExpression(), null, null, null, null, request.getConditionalOperator(), request.getExpected(), null, null, null, null, null, request.getExpressionAttributeNames(), request.getExpressionAttributeValues());
        SegmentPool.Segment keyHeadSeg = this.mSegPool.alloc();
        SegmentPool.Segment valueHeadSeg = this.mSegPool.alloc();
        String tableName = request.getTableName();
        DaxClient.validateTableName(tableName);
        ClientTube tube = null;
        DynamoDBExpressionInfo exp = null;
        try {
            ItemCollectionMetrics itemCollectionMetrics;
            List<AttributeDefinition> keys = this.mKeyCache.get(tableName);
            Map attributes = request.getItem();
            AttributeValueEncoder.encodeKey(this.mSegPool, keyHeadSeg, attributes, keys);
            int offset = AttributeValueEncoder.encodeAttributes(request.getItem(), keys, this.mAttrListIdCache, this.mSegPool, valueHeadSeg);
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            DynamoNumerals.ReturnValue returnValue = DynamoNumerals.ReturnValue.fromName(request.getReturnValues());
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.getReturnItemCollectionMetrics());
            byte[] optional = this.encodeItemOperationsOptionalParams(returnValue.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, AttributeValueEncoder.encodeConditionalExp(exp), null);
            tube = this.mStubs.putItem_N2106490455_1(Encoder.encodeUtf8(tableName), this.mSegPool.chainCopyAndTrim(keyHeadSeg, 0), this.mSegPool.chainCopyAndTrim(valueHeadSeg, offset), optional);
            PutItemResult result = new PutItemResult();
            DaxCborInputStream input = tube.getInputStream();
            Map<Constants.DaxResponseParam, Object> response = DaxResponseDecoder.decodeResponse(input, this.mAttrListCache, keys);
            Map item = (Map)response.get((Object)Constants.DaxResponseParam.Attributes);
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                ConsumedCapacity consumedCapacity = (ConsumedCapacity)response.get((Object)Constants.DaxResponseParam.ConsumedCapacity);
                if (null == consumedCapacity) {
                    consumedCapacity = DaxResponseDecoder.newZeroConsumedCapacity(tableName);
                }
                result.setConsumedCapacity(consumedCapacity);
            }
            if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE && (itemCollectionMetrics = (ItemCollectionMetrics)response.get((Object)Constants.DaxResponseParam.ItemCollectionMetrics)) != null) {
                result.setItemCollectionMetrics(itemCollectionMetrics);
            }
            if (item != null) {
                for (AttributeDefinition key : keys) {
                    String keyName = key.getAttributeName();
                    item.put(keyName, attributes.get(keyName));
                }
                result.setAttributes(item);
            }
            putItemResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(keyHeadSeg);
                this.mSegPool.chainRecycle(valueHeadSeg);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(keyHeadSeg);
        this.mSegPool.chainRecycle(valueHeadSeg);
        this.mTubePool.recycle(tube);
        return putItemResult;
    }

    public PutItemResult putItem(String table, Map<String, AttributeValue> item) throws AmazonClientException {
        return this.putItem(new PutItemRequest(table, item));
    }

    public PutItemResult putItem(String table, Map<String, AttributeValue> item, String returnValues) throws AmazonClientException {
        return this.putItem(new PutItemRequest(table, item, returnValues));
    }

    public TransactGetItemsResult transactGetItems(final TransactGetItemsRequest request) {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<TransactGetItemsResult>(){

            @Override
            public TransactGetItemsResult get() {
                return DaxClient.this.executeTransactGetItems(request);
            }
        }, this.mReadRetryHandlerSupplier);
    }

    TransactGetItemsResult executeTransactGetItems(TransactGetItemsRequest request) throws AmazonClientException {
        TransactGetItemsResult transactGetItemsResult;
        SegmentPool.Segment projectionExprsTail;
        SegmentPool.Segment tableNamesTail;
        SegmentPool.Segment keysTail;
        if (request.getTransactItems() == null) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at 'transactItems' failed to satisfy constraint: Member must not be null");
        }
        SegmentPool.Segment singleKeyHead = this.mSegPool.alloc();
        SegmentPool.Segment keysHead = keysTail = this.mSegPool.alloc();
        SegmentPool.Segment tableNamesHead = tableNamesTail = this.mSegPool.alloc();
        SegmentPool.Segment projectionExprsHead = projectionExprsTail = this.mSegPool.alloc();
        ClientTube tube = null;
        HashMap<String, List<AttributeDefinition>> keysPerTable = new HashMap<String, List<AttributeDefinition>>();
        ArrayList<Map<String, AttributeValue>> keysPerRequest = new ArrayList<Map<String, AttributeValue>>(request.getTransactItems().size());
        ArrayList<Map<Integer, DocumentPath>> projectionOrdinalsPerRequest = new ArrayList<Map<Integer, DocumentPath>>(request.getTransactItems().size());
        if (request.getTransactItems().size() < 1) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.getTransactItems() + "' at 'transactItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        try {
            keysTail = this.mSegPool.chainAppendCborArrayPrefix(keysTail, request.getTransactItems().size());
            tableNamesTail = this.mSegPool.chainAppendCborArrayPrefix(tableNamesTail, request.getTransactItems().size());
            projectionExprsTail = this.mSegPool.chainAppendCborArrayPrefix(projectionExprsTail, request.getTransactItems().size());
            int i = 0;
            for (TransactGetItem transactGetItem : request.getTransactItems()) {
                if (transactGetItem == null) {
                    throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.getTransactItems() + "' at 'transactItems' failed to satisfy constraint: Member must not be null");
                }
                if (transactGetItem.getGet() == null) {
                    throw ExceptionTranslator.createValidationException("Invalid Request: TransactWriteRequest should contain Get request");
                }
                Get get = transactGetItem.getGet();
                Map key = get.getKey();
                String tableName = get.getTableName();
                String projectionExpr = get.getProjectionExpression();
                RequestValidator.validateTableName(tableName, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "get", "tableName"));
                RequestValidator.validateTransactItem(key, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "get", "key"));
                RequestValidator.validateExpression(null, null, projectionExpr, null, null, null, null, null, null, null, null, null, get.getExpressionAttributeNames(), null);
                List<AttributeDefinition> tableKeys = this.mKeyCache.get(tableName);
                keysPerTable.put(tableName, tableKeys);
                keysPerRequest.add(key);
                AttributeValueEncoder.validateAndEncodeKey(this.mSegPool, singleKeyHead, key, tableKeys);
                keysTail = this.mSegPool.chainAppendCborBytes(keysTail, this.mSegPool.chainCopyAndTrim(singleKeyHead, 0));
                tableNamesTail = this.mSegPool.chainAppendCborBytes(tableNamesTail, Encoder.encodeUtf8(tableName));
                if (projectionExpr != null) {
                    HashMap<Integer, DocumentPath> projectionOrdinals = new HashMap<Integer, DocumentPath>();
                    AttributeValueEncoder.prepareProjection(projectionExpr, get.getExpressionAttributeNames(), projectionOrdinals);
                    projectionOrdinalsPerRequest.add(projectionOrdinals);
                    projectionExprsTail = this.mSegPool.chainAppendCborBytes(projectionExprsTail, AttributeValueEncoder.encodeProjection(projectionExpr, get.getExpressionAttributeNames()));
                } else {
                    projectionExprsTail = this.mSegPool.chainAppendCborNull(projectionExprsTail);
                    projectionOrdinalsPerRequest.add(null);
                }
                ++i;
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            byte[] kwargs = this.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, DynamoNumerals.ReturnItemCollectionMetrics.NONE.mCode, null, null);
            tube = this.mStubs.transactGetItems_1866287579_1(this.mSegPool.chainCopyAndTrim(tableNamesHead, 0), this.mSegPool.chainCopyAndTrim(keysHead, 0), this.mSegPool.chainCopyAndTrim(projectionExprsHead, 0), kwargs);
            DaxCborInputStream inputStream = tube.getInputStream();
            TransactGetItemsResult result = null;
            result = DaxResponseDecoder.decodeTransactGet(inputStream, keysPerRequest, projectionOrdinalsPerRequest, this.mAttrListCache);
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(this.verifyBatchConsumedCapacity(result.getConsumedCapacity(), keysPerTable.keySet()));
            }
            transactGetItemsResult = result;
        }
        catch (Throwable t) {
            try {
                throw this.handleTransactionException(t, keysPerRequest, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.recycle(singleKeyHead);
                this.mSegPool.recycle(keysHead);
                this.mSegPool.recycle(tableNamesHead);
                this.mSegPool.recycle(projectionExprsHead);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.recycle(singleKeyHead);
        this.mSegPool.recycle(keysHead);
        this.mSegPool.recycle(tableNamesHead);
        this.mSegPool.recycle(projectionExprsHead);
        this.mTubePool.recycle(tube);
        return transactGetItemsResult;
    }

    public TransactWriteItemsResult transactWriteItems(final TransactWriteItemsRequest request) {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<TransactWriteItemsResult>(){

            @Override
            public TransactWriteItemsResult get() {
                return DaxClient.this.executeTransactWriteItems(request);
            }
        }, this.mWriteRetryHandlerSupplier);
    }

    TransactWriteItemsResult executeTransactWriteItems(TransactWriteItemsRequest request) throws AmazonClientException {
        TransactWriteItemsResult transactWriteItemsResult;
        SegmentPool.Segment rvOnConditionCheckTail;
        SegmentPool.Segment conditionExprsTail;
        SegmentPool.Segment updateExprsTail;
        SegmentPool.Segment tableNamesTail;
        SegmentPool.Segment operationsTail;
        SegmentPool.Segment valuesTail;
        SegmentPool.Segment keysTail;
        if (request.getTransactItems() == null) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at 'transactItems' failed to satisfy constraint: Member must not be null");
        }
        SegmentPool.Segment singleKeyHead = this.mSegPool.alloc();
        SegmentPool.Segment singleValueHead = this.mSegPool.alloc();
        SegmentPool.Segment keysHead = keysTail = this.mSegPool.alloc();
        SegmentPool.Segment valuesHead = valuesTail = this.mSegPool.alloc();
        SegmentPool.Segment operationsHead = operationsTail = this.mSegPool.alloc();
        SegmentPool.Segment tableNamesHead = tableNamesTail = this.mSegPool.alloc();
        SegmentPool.Segment updateExprsHead = updateExprsTail = this.mSegPool.alloc();
        SegmentPool.Segment conditionExprsHead = conditionExprsTail = this.mSegPool.alloc();
        SegmentPool.Segment rvOnConditionCheckHead = rvOnConditionCheckTail = this.mSegPool.alloc();
        ClientTube tube = null;
        HashMap<String, TreeSet<byte[]>> keySetPerTable = new HashMap<String, TreeSet<byte[]>>();
        HashMap<String, List<AttributeDefinition>> keysPerTable = new HashMap<String, List<AttributeDefinition>>();
        ArrayList<Map<String, AttributeValue>> keysPerRequest = new ArrayList<Map<String, AttributeValue>>(request.getTransactItems().size());
        if (request.getTransactItems().size() < 1) {
            throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.getTransactItems() + "' at 'transactItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
        }
        try {
            keysTail = this.mSegPool.chainAppendCborArrayPrefix(keysTail, request.getTransactItems().size());
            valuesTail = this.mSegPool.chainAppendCborArrayPrefix(valuesTail, request.getTransactItems().size());
            operationsTail = this.mSegPool.chainAppendCborArrayPrefix(operationsTail, request.getTransactItems().size());
            tableNamesTail = this.mSegPool.chainAppendCborArrayPrefix(tableNamesTail, request.getTransactItems().size());
            rvOnConditionCheckTail = this.mSegPool.chainAppendCborArrayPrefix(rvOnConditionCheckTail, request.getTransactItems().size());
            updateExprsTail = this.mSegPool.chainAppendCborArrayPrefix(updateExprsTail, request.getTransactItems().size());
            conditionExprsTail = this.mSegPool.chainAppendCborArrayPrefix(conditionExprsTail, request.getTransactItems().size());
            int i = 0;
            for (TransactWriteItem transactWriteItem : request.getTransactItems()) {
                if (transactWriteItem == null) {
                    throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + request.getTransactItems() + "' at 'transactItems' failed to satisfy constraint: Member must not be null");
                }
                String tableName = null;
                String updateExpr = null;
                String conditionExpr = null;
                String rvOnConditionCheckFailure = null;
                DynamoNumerals.Operation operation = null;
                Map key = null;
                Map item = null;
                Map eAttrVal = null;
                Map eAttrName = null;
                String opName = null;
                int operations = 0;
                if (transactWriteItem.getConditionCheck() != null) {
                    ++operations;
                    ConditionCheck check = transactWriteItem.getConditionCheck();
                    tableName = check.getTableName();
                    operation = DynamoNumerals.Operation.CHECK;
                    key = check.getKey();
                    conditionExpr = check.getConditionExpression();
                    if (conditionExpr == null) {
                        throw ExceptionTranslator.createValidationException("Value null at '" + String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "conditionCheck", "conditionExpression") + "' failed to satisfy constraint: Member must not be null");
                    }
                    eAttrName = check.getExpressionAttributeNames();
                    eAttrVal = check.getExpressionAttributeValues();
                    rvOnConditionCheckFailure = check.getReturnValuesOnConditionCheckFailure();
                    opName = "conditionCheck";
                }
                if (transactWriteItem.getPut() != null) {
                    ++operations;
                    Put put = transactWriteItem.getPut();
                    tableName = put.getTableName();
                    operation = DynamoNumerals.Operation.PUT;
                    item = put.getItem();
                    conditionExpr = put.getConditionExpression();
                    eAttrName = put.getExpressionAttributeNames();
                    eAttrVal = put.getExpressionAttributeValues();
                    rvOnConditionCheckFailure = put.getReturnValuesOnConditionCheckFailure();
                    opName = "put";
                }
                if (transactWriteItem.getDelete() != null) {
                    ++operations;
                    Delete delete = transactWriteItem.getDelete();
                    tableName = delete.getTableName();
                    operation = DynamoNumerals.Operation.DELETE;
                    key = delete.getKey();
                    conditionExpr = delete.getConditionExpression();
                    eAttrName = delete.getExpressionAttributeNames();
                    eAttrVal = delete.getExpressionAttributeValues();
                    rvOnConditionCheckFailure = delete.getReturnValuesOnConditionCheckFailure();
                    opName = "delete";
                }
                if (transactWriteItem.getUpdate() != null) {
                    ++operations;
                    Update update = transactWriteItem.getUpdate();
                    tableName = update.getTableName();
                    operation = DynamoNumerals.Operation.PARTIAL_UPDATE;
                    key = update.getKey();
                    conditionExpr = update.getConditionExpression();
                    updateExpr = update.getUpdateExpression();
                    if (updateExpr == null) {
                        throw ExceptionTranslator.createValidationException("1 validation error detected: Value null at '" + String.format(TXN_VALIDATION_ERROR_MSG, i + 1, "update", "updateExpression") + "' failed to satisfy constraint: Member must not be null");
                    }
                    eAttrName = update.getExpressionAttributeNames();
                    eAttrVal = update.getExpressionAttributeValues();
                    rvOnConditionCheckFailure = update.getReturnValuesOnConditionCheckFailure();
                    opName = "update";
                }
                if (operations > 1) {
                    throw ExceptionTranslator.createValidationException("TransactItems can only contain one of ConditionCheck, Put, Update or Delete");
                }
                if (operations == 0) {
                    throw ExceptionTranslator.createValidationException("Invalid Request: TransactWriteRequest should contain Delete or Put or Update request");
                }
                RequestValidator.validateTableName(tableName, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, opName, "tableName"));
                RequestValidator.validateTransactItem(opName.equals("put") ? item : key, String.format(TXN_VALIDATION_ERROR_MSG, i + 1, opName, opName.equals("put") ? "item" : "key"));
                RequestValidator.validateExpression(conditionExpr, updateExpr, null, null, null, null, null, null, null, null, null, null, eAttrName, eAttrVal);
                List<AttributeDefinition> tableKeys = this.mKeyCache.get(tableName);
                keysPerTable.put(tableName, tableKeys);
                keysPerRequest.add(com.amazon.dax.client.utils.Utils.extractKey(item == null ? key : item, tableKeys));
                if (key != null) {
                    RequestValidator.validateKey(key, tableKeys);
                }
                AttributeValueEncoder.encodeKey(this.mSegPool, singleKeyHead, item == null ? key : item, tableKeys);
                byte[] keyBytes = this.mSegPool.chainCopyAndTrim(singleKeyHead, 0);
                TreeSet<byte[]> keySet = (TreeSet<byte[]>)keySetPerTable.get(tableName);
                if (keySet == null) {
                    keySet = new TreeSet<byte[]>(UnsignedComparator.INSTANCE);
                    keySetPerTable.put(tableName, keySet);
                }
                if (!keySet.add(keyBytes)) {
                    throw ExceptionTranslator.createValidationException("Transaction request cannot include multiple operations on one item");
                }
                keysTail = this.mSegPool.chainAppendCborBytes(keysTail, keyBytes);
                if (item != null) {
                    int offset = AttributeValueEncoder.encodeAttributes(item, tableKeys, this.mAttrListIdCache, this.mSegPool, singleValueHead);
                    valuesTail = this.mSegPool.chainAppendCborBytes(valuesTail, this.mSegPool.chainCopyAndTrim(singleValueHead, offset));
                } else {
                    valuesTail = this.mSegPool.chainAppendCborNull(valuesTail);
                }
                operationsTail = this.mSegPool.chainAppendCborInteger(operationsTail, operation.mCode);
                tableNamesTail = this.mSegPool.chainAppendCborBytes(tableNamesTail, Encoder.encodeUtf8(tableName));
                rvOnConditionCheckTail = rvOnConditionCheckFailure != null ? this.mSegPool.chainAppendCborInteger(rvOnConditionCheckTail, DynamoNumerals.ReturnValueOnConditionCheckFailure.fromName((String)rvOnConditionCheckFailure).mCode) : this.mSegPool.chainAppendCborInteger(rvOnConditionCheckTail, DynamoNumerals.ReturnValueOnConditionCheckFailure.NONE.mCode);
                Map<ExpressionType, byte[]> encodedExprs = AttributeValueEncoder.encodeExpressions(conditionExpr, null, null, updateExpr, null, eAttrName, eAttrVal);
                byte[] condExp = encodedExprs.get((Object)ExpressionType.Condition);
                byte[] updateExp = encodedExprs.get((Object)ExpressionType.Update);
                conditionExprsTail = condExp != null ? this.mSegPool.chainAppendCborBytes(conditionExprsTail, condExp) : this.mSegPool.chainAppendCborNull(conditionExprsTail);
                updateExprsTail = updateExp != null ? this.mSegPool.chainAppendCborBytes(updateExprsTail, updateExp) : this.mSegPool.chainAppendCborNull(updateExprsTail);
                ++i;
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.getReturnItemCollectionMetrics());
            String clientRequestToken = request.getClientRequestToken();
            if (clientRequestToken == null) {
                clientRequestToken = UUID.randomUUID().toString();
                request.setClientRequestToken(clientRequestToken);
            }
            byte[] kwargs = this.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, null, null, clientRequestToken);
            tube = this.mStubs.transactWriteItems_N1160037738_1(this.mSegPool.chainCopyAndTrim(operationsHead, 0), this.mSegPool.chainCopyAndTrim(tableNamesHead, 0), this.mSegPool.chainCopyAndTrim(keysHead, 0), this.mSegPool.chainCopyAndTrim(valuesHead, 0), null, this.mSegPool.chainCopyAndTrim(rvOnConditionCheckHead, 0), this.mSegPool.chainCopyAndTrim(conditionExprsHead, 0), this.mSegPool.chainCopyAndTrim(updateExprsHead, 0), kwargs);
            DaxCborInputStream inputStream = tube.getInputStream();
            TransactWriteItemsResult result = null;
            result = DaxResponseDecoder.decodeTransactWrite(inputStream, keysPerTable, keysPerRequest, null, this.mAttrListCache);
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(this.verifyBatchConsumedCapacity(result.getConsumedCapacity(), keysPerTable.keySet()));
            }
            if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE && result.getItemCollectionMetrics() == null) {
                result.setItemCollectionMetrics(new HashMap());
            }
            transactWriteItemsResult = result;
        }
        catch (Throwable t) {
            try {
                throw this.handleTransactionException(t, keysPerRequest, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.recycle(singleKeyHead);
                this.mSegPool.recycle(singleValueHead);
                this.mSegPool.recycle(keysHead);
                this.mSegPool.recycle(valuesHead);
                this.mSegPool.recycle(operationsHead);
                this.mSegPool.recycle(tableNamesHead);
                this.mSegPool.recycle(rvOnConditionCheckHead);
                this.mSegPool.recycle(updateExprsHead);
                this.mSegPool.recycle(conditionExprsHead);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.recycle(singleKeyHead);
        this.mSegPool.recycle(singleValueHead);
        this.mSegPool.recycle(keysHead);
        this.mSegPool.recycle(valuesHead);
        this.mSegPool.recycle(operationsHead);
        this.mSegPool.recycle(tableNamesHead);
        this.mSegPool.recycle(rvOnConditionCheckHead);
        this.mSegPool.recycle(updateExprsHead);
        this.mSegPool.recycle(conditionExprsHead);
        this.mTubePool.recycle(tube);
        return transactWriteItemsResult;
    }

    public BatchWriteItemResult batchWriteItem(final BatchWriteItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult get() {
                return DaxClient.this.executeBatchWriteItem(request);
            }
        }, this.mWriteRetryHandlerSupplier);
    }

    BatchWriteItemResult executeBatchWriteItem(BatchWriteItemRequest request) throws AmazonClientException {
        BatchWriteItemResult batchWriteItemResult;
        SegmentPool.Segment requestTail;
        SegmentPool.Segment requestHead = requestTail = this.mSegPool.alloc();
        SegmentPool.Segment keyHead = this.mSegPool.alloc();
        SegmentPool.Segment valueHead = this.mSegPool.alloc();
        ClientTube tube = null;
        HashMap<String, List<AttributeDefinition>> keysPerTable = new HashMap<String, List<AttributeDefinition>>();
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(UnsignedComparator.INSTANCE);
        try {
            if (request.getRequestItems() == null) {
                throw new IllegalArgumentException("1 validation error detected: Value '" + request.getRequestItems() + "' at 'requestItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
            }
            HashMap requestByTable = new HashMap();
            for (Map.Entry requestEntry : request.getRequestItems().entrySet()) {
                if (CollectionUtils.isNullOrEmpty((Collection)((Collection)requestEntry.getValue()))) continue;
                requestByTable.put(requestEntry.getKey(), requestEntry.getValue());
            }
            requestTail = this.mSegPool.chainAppendCborMapPrefix(requestTail, requestByTable.size());
            int totalRequests = 0;
            for (Map.Entry entry : requestByTable.entrySet()) {
                String tableName = (String)entry.getKey();
                RequestValidator.validateTableName(tableName);
                List writeRequests = (List)entry.getValue();
                if ((totalRequests += writeRequests.size()) > 25) {
                    throw new IllegalArgumentException("Batch size should be less than 25");
                }
                List<AttributeDefinition> tableKeys = this.mKeyCache.get(tableName);
                keysPerTable.put(tableName, tableKeys);
                keySet.clear();
                requestTail = this.mSegPool.chainAppendCborString(requestTail, tableName);
                int maxSizeHeaderLen = Encoder.calculateCborFieldSize(writeRequests.size() * 2);
                requestTail = this.mSegPool.chainRequire(requestTail, maxSizeHeaderLen);
                requestTail.mEnd += maxSizeHeaderLen;
                SegmentPool.Segment itemArrayStartSegment = requestTail;
                int itemArrayStartOffset = requestTail.mEnd;
                int requestItemCount = 0;
                boolean isEmpty = true;
                for (WriteRequest writeRequest : writeRequests) {
                    if (writeRequest == null) continue;
                    isEmpty = false;
                    RequestValidator.validate(writeRequest);
                    if (writeRequest.getPutRequest() != null) {
                        PutRequest putRequest = writeRequest.getPutRequest();
                        Map attributes = putRequest.getItem();
                        RequestValidator.validateBatchWriteItem(attributes);
                        AttributeValueEncoder.encodeKey(this.mSegPool, keyHead, attributes, tableKeys);
                        int offset = AttributeValueEncoder.encodeAttributes(attributes, tableKeys, this.mAttrListIdCache, this.mSegPool, valueHead);
                        byte[] key = this.mSegPool.chainCopyAndTrim(keyHead, 0);
                        if (!keySet.add(key)) {
                            throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                        }
                        requestTail = this.mSegPool.chainAppendCborBytes(requestTail, key);
                        requestTail = this.mSegPool.chainAppendCborBytes(requestTail, this.mSegPool.chainCopyAndTrim(valueHead, offset));
                        ++requestItemCount;
                        continue;
                    }
                    if (writeRequest.getDeleteRequest() == null) continue;
                    DeleteRequest deleteRequest = writeRequest.getDeleteRequest();
                    Map keys = deleteRequest.getKey();
                    AttributeValueEncoder.encodeKey(this.mSegPool, keyHead, keys, tableKeys);
                    byte[] key = this.mSegPool.chainCopyAndTrim(keyHead, 0);
                    if (!keySet.add(key)) {
                        throw new IllegalArgumentException("Provided list of item keys contains duplicates");
                    }
                    requestTail = this.mSegPool.chainAppendCborBytes(requestTail, key);
                    requestTail = this.mSegPool.chainAppend(requestTail, (byte)-10);
                    ++requestItemCount;
                }
                if (isEmpty) {
                    throw ExceptionTranslator.createValidationException("1 validation error detected: Value '{" + tableName + "=" + writeRequests + "}' at 'requestItems' failed to satisfy constraint: Map value must satisfy constraint: [Member must have length less than or equal to 25, Member must have length greater than or equal to 1");
                }
                Encoder.prependCborTypePrefix(itemArrayStartSegment.mBytes, itemArrayStartOffset, 128, requestItemCount * 2);
            }
            if (totalRequests == 0) {
                throw new IllegalArgumentException("1 validation error detected: Value '" + requestByTable + "' at 'requestItems' failed to satisfy constraint: Member must have length greater than or equal to 1");
            }
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.getReturnItemCollectionMetrics());
            byte[] optional = this.encodeItemOperationsOptionalParams(DynamoNumerals.ReturnValue.NONE.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, null, null);
            tube = this.mStubs.batchWriteItem_116217951_1(this.mSegPool.chainCopyAndTrim(requestHead, 0), optional);
            DaxCborInputStream inputStream = tube.getInputStream();
            BatchWriteItemResult result = AttributeValueDecoder.decodeBatchWrite(inputStream, keysPerTable, this.mAttrListCache);
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(this.verifyBatchConsumedCapacity(result.getConsumedCapacity(), requestByTable.keySet()));
            }
            if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE && result.getItemCollectionMetrics() == null) {
                result.setItemCollectionMetrics(new HashMap());
            }
            batchWriteItemResult = result;
        }
        catch (Throwable t) {
            try {
                throw this.handleException(t, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.recycle(keyHead);
                this.mSegPool.recycle(valueHead);
                this.mSegPool.recycle(requestHead);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.recycle(keyHead);
        this.mSegPool.recycle(valueHead);
        this.mSegPool.recycle(requestHead);
        this.mTubePool.recycle(tube);
        return batchWriteItemResult;
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> request) throws AmazonClientException {
        return this.batchWriteItem(new BatchWriteItemRequest(request));
    }

    public DeleteItemResult deleteItem(final DeleteItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<DeleteItemResult>(){

            @Override
            public DeleteItemResult get() {
                return DaxClient.this.executeDeleteItem(request);
            }
        }, this.mWriteRetryHandlerSupplier);
    }

    DeleteItemResult executeDeleteItem(DeleteItemRequest request) throws AmazonClientException {
        DeleteItemResult deleteItemResult;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(request.getConditionExpression(), null, null, null, null, request.getConditionalOperator(), request.getExpected(), null, null, null, null, null, request.getExpressionAttributeNames(), request.getExpressionAttributeValues());
        SegmentPool.Segment headSegment = this.mSegPool.alloc();
        String tableName = request.getTableName();
        List<AttributeDefinition> keys = this.mKeyCache.get(tableName);
        ClientTube tube = null;
        DynamoDBExpressionInfo exp = null;
        try {
            ItemCollectionMetrics itemCollectionMetrics;
            AttributeValueEncoder.validateAndEncodeKey(this.mSegPool, headSegment, request.getKey(), keys);
            DynamoNumerals.ReturnValue retVal = DynamoNumerals.ReturnValue.fromName(request.getReturnValues());
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            DynamoNumerals.ReturnValue returnValue = DynamoNumerals.ReturnValue.fromName(request.getReturnValues());
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.getReturnItemCollectionMetrics());
            byte[] optional = this.encodeItemOperationsOptionalParams(returnValue.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, AttributeValueEncoder.encodeConditionalExp(exp), null);
            tube = this.mStubs.deleteItem_1013539361_1(Encoder.encodeUtf8(tableName), this.mSegPool.chainCopyAndTrim(headSegment, 0), optional);
            DaxCborInputStream input = tube.getInputStream();
            DeleteItemResult result = new DeleteItemResult();
            Map<Constants.DaxResponseParam, Object> response = DaxResponseDecoder.decodeResponse(input, this.mAttrListCache, keys);
            Map item = (Map)response.get((Object)Constants.DaxResponseParam.Attributes);
            ConsumedCapacity consumedCapacity = (ConsumedCapacity)response.get((Object)Constants.DaxResponseParam.ConsumedCapacity);
            if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                if (null == consumedCapacity) {
                    consumedCapacity = DaxResponseDecoder.newZeroConsumedCapacity(tableName);
                }
                result.setConsumedCapacity(consumedCapacity);
            }
            if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE && (itemCollectionMetrics = (ItemCollectionMetrics)response.get((Object)Constants.DaxResponseParam.ItemCollectionMetrics)) != null) {
                result.setItemCollectionMetrics(itemCollectionMetrics);
            }
            if (item != null) {
                if (keys.size() == request.getKey().size()) {
                    item.putAll(request.getKey());
                } else {
                    for (AttributeDefinition key : keys) {
                        String keyName = key.getAttributeName();
                        item.put(keyName, request.getKey().get(keyName));
                    }
                }
                result.setAttributes(item);
            }
            deleteItemResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(headSegment);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(headSegment);
        this.mTubePool.recycle(tube);
        return deleteItemResult;
    }

    public DeleteItemResult deleteItem(String table, Map<String, AttributeValue> key) throws AmazonClientException {
        return this.deleteItem(new DeleteItemRequest(table, key));
    }

    public DeleteItemResult deleteItem(String table, Map<String, AttributeValue> key, String returnValues) throws AmazonClientException {
        return this.deleteItem(new DeleteItemRequest(table, key, returnValues));
    }

    public UpdateItemResult updateItem(final UpdateItemRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<UpdateItemResult>(){

            @Override
            public UpdateItemResult get() {
                return DaxClient.this.executeUpdateItem(request);
            }
        }, this.mWriteRetryHandlerSupplier);
    }

    UpdateItemResult executeUpdateItem(UpdateItemRequest request) throws AmazonClientException {
        UpdateItemResult updateItemResult;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(request.getConditionExpression(), request.getUpdateExpression(), null, null, null, request.getConditionalOperator(), request.getExpected(), request.getAttributeUpdates(), null, null, null, null, request.getExpressionAttributeNames(), request.getExpressionAttributeValues());
        DynamoDBExpressionInfo exp = null;
        exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
        SegmentPool.Segment keyHeadSeg = this.mSegPool.alloc();
        String tableName = request.getTableName();
        ClientTube tube = null;
        try {
            List<AttributeDefinition> keys = this.mKeyCache.get(tableName);
            AttributeValueEncoder.validateAndEncodeKey(this.mSegPool, keyHeadSeg, request.getKey(), keys);
            Map<ExpressionType, byte[]> encodedExprs = AttributeValueEncoder.encodeExpressions(exp.getConditionExpression(), null, null, exp.getUpdateExpression(), null, exp.getExpressionAttributeNames(), exp.getExpressionAttributeValues());
            byte[] condExp = encodedExprs.get((Object)ExpressionType.Condition);
            byte[] updateExp = encodedExprs.get((Object)ExpressionType.Update);
            DynamoNumerals.ReturnValue returnValue = DynamoNumerals.ReturnValue.fromName(request.getReturnValues());
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.getReturnItemCollectionMetrics());
            byte[] optional = this.encodeItemOperationsOptionalParams(returnValue.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, condExp, updateExp);
            tube = this.mStubs.updateItem_1425579023_1(Encoder.encodeUtf8(tableName), this.mSegPool.chainCopyAndTrim(keyHeadSeg, 0), optional);
            DaxCborInputStream input = tube.getInputStream();
            UpdateItemResult result = DaxResponseDecoder.decodeUpdateItemResult(input, this.mAttrListCache, keys, request);
            if (null == result.getConsumedCapacity() && returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(request.getTableName()));
            }
            updateItemResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(keyHeadSeg);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(keyHeadSeg);
        this.mTubePool.recycle(tube);
        return updateItemResult;
    }

    private byte[] encodeItemOperationsOptionalParams(int returnValue, int returnConsumedCapacity, int returnItemCollectionMetrics, byte[] conditionsExpression, byte[] updateExpression) throws IOException {
        return this.encodeItemOperationsOptionalParams(returnValue, returnConsumedCapacity, returnItemCollectionMetrics, conditionsExpression, updateExpression, null);
    }

    private byte[] encodeItemOperationsOptionalParams(int returnValue, int returnConsumedCapacity, int returnItemCollectionMetrics, byte[] conditionsExpression, byte[] updateExpression, String clientRequestToken) throws IOException {
        EnumMap<Constants.DaxDataRequestParam, Object> optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Object>(Constants.DaxDataRequestParam.class);
        if (returnValue != DynamoNumerals.ReturnValue.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnValues, Integer.valueOf(returnValue));
        }
        if (returnConsumedCapacity != DynamoNumerals.ReturnConsumedCapacity.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, Integer.valueOf(returnConsumedCapacity));
        }
        if (returnItemCollectionMetrics != DynamoNumerals.ReturnItemCollectionMetrics.NONE.mCode) {
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnItemCollectionMetrics, Integer.valueOf(returnItemCollectionMetrics));
        }
        if (conditionsExpression != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.ConditionExpression, conditionsExpression);
        }
        if (updateExpression != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.UpdateExpression, updateExpression);
        }
        if (clientRequestToken != null) {
            optionalArgs.put(Constants.DaxDataRequestParam.ClientRequestToken, clientRequestToken);
        }
        return DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.mSegPool);
    }

    public UpdateItemResult updateItem(String table, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) throws AmazonClientException {
        return this.updateItem(new UpdateItemRequest(table, key, attributeUpdates));
    }

    public UpdateItemResult updateItem(String table, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) throws AmazonClientException {
        return this.updateItem(new UpdateItemRequest(table, key, attributeUpdates, returnValues));
    }

    public QueryResult query(final QueryRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<QueryResult>(){

            @Override
            public QueryResult get() {
                return DaxClient.this.executeQuery(request);
            }
        }, this.mReadRetryHandlerSupplier);
    }

    QueryResult executeQuery(QueryRequest request) throws AmazonClientException {
        QueryResult queryResult;
        SegmentPool.Segment tail;
        byte[] projection;
        byte[] filter;
        byte[] keyConds;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(null, null, request.getProjectionExpression(), request.getFilterExpression(), request.getKeyConditionExpression(), request.getConditionalOperator(), null, null, request.getAttributesToGet(), request.getQueryFilter(), null, request.getKeyConditions(), request.getExpressionAttributeNames(), request.getExpressionAttributeValues());
        RequestValidator.checkAndThrowIfSelectIsInvalidForProjectionExpression(request.getProjectionExpression(), request.getSelect());
        RequestValidator.checkAndThrowIfSelectIsInvalidForAttributestoGet(request.getAttributesToGet(), request.getSelect(), request.getProjectionExpression());
        DynamoDBExpressionInfo exp = null;
        exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
        try {
            Map<ExpressionType, byte[]> exprs = AttributeValueEncoder.encodeExpressions(null, exp.getKeyConditionExpression(), exp.getFilterExpression(), null, exp.getProjectionExpression(), exp.getExpressionAttributeNames(), exp.getExpressionAttributeValues());
            keyConds = exprs.get((Object)ExpressionType.KeyCondition);
            filter = exprs.get((Object)ExpressionType.Filter);
            projection = exprs.get((Object)ExpressionType.Projection);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionTranslator.createValidationException(e.getMessage());
        }
        Map<Integer, DocumentPath> projOrdinals = AttributeValueEncoder.prepareProjection(exp);
        byte[] tName = Encoder.encodeUtf8(request.getTableName());
        String ix = request.getIndexName();
        byte[] ixName = ix == null ? null : Encoder.encodeUtf8(ix);
        Integer limit = request.getLimit();
        RequestValidator.validateLimit(limit);
        SegmentPool.Segment head = tail = this.mSegPool.alloc();
        ClientTube tube = null;
        try {
            DaxCborInputStream input;
            QueryResult result;
            List<AttributeDefinition> keys = this.mKeyCache.get(request.getTableName());
            byte[] startExclusiveKey = null;
            if (request.getExclusiveStartKey() != null) {
                tail = ixName == null ? AttributeValueEncoder.encodeKey(this.mSegPool, tail, request.getExclusiveStartKey(), keys) : AttributeValueEncoder.encodeCompoundKey(this.mSegPool, tail, request.getExclusiveStartKey());
                startExclusiveKey = this.mSegPool.chainCopyAndTrim(head, 0);
            }
            int select = DynamoNumerals.SelectValue.fromName((String)request.getSelect()).mCode;
            this.validateRequiredParamsForSelect(select, ix);
            Boolean scanFwd = request.getScanIndexForward();
            Boolean consistentRead = request.getConsistentRead();
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            EnumMap<Constants.DaxDataRequestParam, Object> optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Object>(Constants.DaxDataRequestParam.class);
            optionalArgs.put(Constants.DaxDataRequestParam.IndexName, ixName);
            optionalArgs.put(Constants.DaxDataRequestParam.FilterExpression, filter);
            optionalArgs.put(Constants.DaxDataRequestParam.ProjectionExpression, projection);
            if (request.getSelect() != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.Select, Integer.valueOf(select));
            }
            optionalArgs.put(Constants.DaxDataRequestParam.ExclusiveStartKey, startExclusiveKey);
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, Integer.valueOf(returnConsumedCapacity.mCode));
            if (limit != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.Limit, limit);
            }
            optionalArgs.put(Constants.DaxDataRequestParam.ScanIndexForward, Boolean.valueOf(scanFwd != null ? scanFwd : true));
            optionalArgs.put(Constants.DaxDataRequestParam.ConsistentRead, Boolean.valueOf(consistentRead != null ? consistentRead : false));
            byte[] optional = null;
            if (optionalArgs.size() > 0) {
                optional = DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.mSegPool);
            }
            if (null == (result = DaxResponseDecoder.decodeQueryResult(input = (tube = this.mStubs.query_N931250863_1(tName, keyConds, optional)).getInputStream(), this.mAttrListCache, keys, ix, projOrdinals, request)).getConsumedCapacity() && DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(request.getTableName()));
            }
            queryResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(head);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(head);
        this.mTubePool.recycle(tube);
        return queryResult;
    }

    private int testAndSetLimitIfAbsent(Integer limit) {
        if (null == limit) {
            return 100;
        }
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than or equal to 1");
        }
        return limit;
    }

    private void validateRequiredParamsForSelect(int selectValueCode, String ix) {
        if (selectValueCode == DynamoNumerals.SelectValue.ALL_PROJECTED_ATTRIBUTES.mCode && (null == ix || ix.trim().length() == 0)) {
            throw new IllegalArgumentException("ALL_PROJECTED_ATTRIBUTES is allowed only when querying an index. Index cannot be empty.");
        }
    }

    public ScanResult scan(final ScanRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        return this.invoke(new Supplier<ScanResult>(){

            @Override
            public ScanResult get() {
                return DaxClient.this.executeScan(request);
            }
        }, this.mReadRetryHandlerSupplier);
    }

    ScanResult executeScan(ScanRequest request) throws AmazonClientException {
        ScanResult scanResult;
        SegmentPool.Segment tail;
        Map<Integer, DocumentPath> projOrdinals;
        byte[] projection;
        byte[] filterExp;
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateExpression(null, null, request.getProjectionExpression(), request.getFilterExpression(), null, request.getConditionalOperator(), null, null, request.getAttributesToGet(), null, request.getScanFilter(), null, request.getExpressionAttributeNames(), request.getExpressionAttributeValues());
        DynamoDBExpressionInfo exp = null;
        try {
            exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
            Map<ExpressionType, byte[]> exprs = AttributeValueEncoder.encodeExpressions(null, null, exp.getFilterExpression(), null, exp.getProjectionExpression(), exp.getExpressionAttributeNames(), exp.getExpressionAttributeValues());
            filterExp = exprs.get((Object)ExpressionType.Filter);
            projection = exprs.get((Object)ExpressionType.Projection);
            projOrdinals = AttributeValueEncoder.prepareProjection(exp);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionTranslator.createValidationException(e.getMessage());
        }
        byte[] tName = Encoder.encodeUtf8(request.getTableName());
        String ix = request.getIndexName();
        byte[] ixName = ix == null ? null : Encoder.encodeUtf8(ix);
        DynamoNumerals.SelectValue select = DynamoNumerals.SelectValue.fromName(request.getSelect());
        if (DynamoNumerals.SelectValue.ALL_PROJECTED_ATTRIBUTES.equals((Object)select) && ix == null) {
            throw ExceptionTranslator.createValidationException("ALL_PROJECTED_ATTRIBUTES can be used only when Querying using an IndexName");
        }
        SegmentPool.Segment head = tail = this.mSegPool.alloc();
        ClientTube tube = null;
        try {
            DaxCborInputStream input;
            ScanResult result;
            List<AttributeDefinition> keys = this.mKeyCache.get(request.getTableName());
            if (request.getExclusiveStartKey() != null) {
                tail = ixName == null ? AttributeValueEncoder.encodeKey(this.mSegPool, tail, request.getExclusiveStartKey(), keys) : AttributeValueEncoder.encodeCompoundKey(this.mSegPool, tail, request.getExclusiveStartKey());
            }
            Integer limit = request.getLimit();
            Boolean consistentRead = request.getConsistentRead();
            DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity());
            EnumMap<Constants.DaxDataRequestParam, Object> optionalArgs = new EnumMap<Constants.DaxDataRequestParam, Object>(Constants.DaxDataRequestParam.class);
            optionalArgs.put(Constants.DaxDataRequestParam.IndexName, ixName);
            optionalArgs.put(Constants.DaxDataRequestParam.FilterExpression, filterExp);
            optionalArgs.put(Constants.DaxDataRequestParam.ProjectionExpression, projection);
            if (request.getSelect() != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.Select, Integer.valueOf(select.mCode));
            }
            optionalArgs.put(Constants.DaxDataRequestParam.ExclusiveStartKey, this.mSegPool.chainCopyAndTrim(head, 0));
            optionalArgs.put(Constants.DaxDataRequestParam.ReturnConsumedCapacity, Integer.valueOf(returnConsumedCapacity.mCode));
            optionalArgs.put(Constants.DaxDataRequestParam.ConsistentRead, Boolean.valueOf(consistentRead != null ? consistentRead : false));
            if (limit != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.Limit, limit);
            }
            if (request.getSegment() != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.Segment, request.getSegment());
            }
            if (request.getTotalSegments() != null) {
                optionalArgs.put(Constants.DaxDataRequestParam.TotalSegments, request.getTotalSegments());
            }
            byte[] optional = null;
            if (optionalArgs.size() > 0) {
                optional = DaxRequestEncoder.encodeOptionalArgs(optionalArgs, this.mSegPool);
            }
            if (null == (result = DaxResponseDecoder.decodeScanResult(input = (tube = this.mStubs.scan_N1875390620_1(tName, optional)).getInputStream(), this.mAttrListCache, keys, ix, projOrdinals, request)).getConsumedCapacity() && DynamoNumerals.ReturnConsumedCapacity.fromName(request.getReturnConsumedCapacity()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
                result.setConsumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(request.getTableName()));
            }
            scanResult = result;
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mSegPool.chainRecycle(head);
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        this.mSegPool.chainRecycle(head);
        this.mTubePool.recycle(tube);
        return scanResult;
    }

    public ScanResult scan(String table, List<String> attributes) throws AmazonClientException {
        return this.scan(new ScanRequest(table).withAttributesToGet(attributes));
    }

    public ScanResult scan(String table, Map<String, Condition> filter) throws AmazonClientException {
        return this.scan(new ScanRequest(table).withScanFilter(filter));
    }

    public ScanResult scan(String table, List<String> attributes, Map<String, Condition> filter) throws AmazonClientException {
        return this.scan(new ScanRequest(table).withAttributesToGet(attributes).withScanFilter(filter));
    }

    public ListTablesResult listTables(ListTablesRequest request) throws AmazonClientException {
        this.validateRequestCredentials((AmazonWebServiceRequest)request);
        Integer limit = request.getLimit();
        if (limit == null) {
            limit = 0;
        }
        ListTablesResult result = new ListTablesResult();
        ClientTube tube = null;
        try {
            tube = this.mStubs.listTables_1874119219_1(request.getExclusiveStartTableName(), limit);
            DaxCborInputStream input = tube.getInputStream();
            result.setTableNames((Collection)((List)input.readObject()));
            result.setLastEvaluatedTableName((String)input.readObject());
            this.mTubePool.recycle(tube);
        }
        catch (Throwable e) {
            try {
                throw this.handleException(e, tube);
            }
            catch (Throwable throwable) {
                this.mTubePool.recycle(tube);
                throw throwable;
            }
        }
        return result;
    }

    public ListTablesResult listTables() throws AmazonClientException {
        return this.listTables(new ListTablesRequest());
    }

    public ListTablesResult listTables(String exclusiveStartTableName) throws AmazonClientException {
        return this.listTables(new ListTablesRequest(exclusiveStartTableName));
    }

    public ListTablesResult listTables(String exclusiveStartTableName, Integer limit) throws AmazonClientException {
        return this.listTables(new ListTablesRequest(exclusiveStartTableName, limit));
    }

    public ListTablesResult listTables(Integer limit) throws AmazonClientException {
        return this.listTables(new ListTablesRequest().withLimit(limit));
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        throw null;
    }

    public AmazonDynamoDBWaiters waiters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AttributeDefinition> defineKeySchema(String tableName) throws AmazonClientException {
        ClientTube tube = null;
        try {
            tube = this.mStubs.defineKeySchema_N742646399_1(Encoder.encodeUtf8(tableName));
            DaxCborInputStream input = tube.getInputStream();
            ArrayList<AttributeDefinition> schema = new ArrayList<AttributeDefinition>();
            int pairs = input.readMapLength();
            for (int i = 0; i < pairs; ++i) {
                schema.add(new AttributeDefinition((String)input.readObject(), (String)input.readObject()));
            }
            ArrayList<AttributeDefinition> arrayList = schema;
            return arrayList;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    @Override
    public Long defineAttributeListId(List<String> attributeNames, List<String> keyNames) throws AmazonClientException {
        for (String k : keyNames) {
            attributeNames.remove(k);
        }
        return this.defineAttributeListId(attributeNames);
    }

    @Override
    public Long defineAttributeListId(List<String> attributeNames) throws AmazonClientException {
        if (attributeNames.isEmpty()) {
            return 1L;
        }
        ClientTube tube = null;
        try {
            tube = this.mStubs.defineAttributeListId_N1230579644_1(attributeNames);
            DaxCborInputStream input = tube.getInputStream();
            Long l = input.readLong();
            return l;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    @Override
    public List<String> defineAttributeList(Long attributeListId) throws AmazonClientException {
        if (attributeListId == 1L) {
            return Collections.emptyList();
        }
        ClientTube tube = null;
        try {
            tube = this.mStubs.defineAttributeList_670678385_1(attributeListId);
            DaxCborInputStream input = tube.getInputStream();
            List list = (List)input.readObject();
            return list;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    @Override
    public List<ServiceEndpoint> endpoints() throws AmazonClientException {
        ClientTube tube = null;
        try {
            tube = this.mStubs.endpoints_455855874_1();
            DaxCborInputStream input = tube.getInputStream();
            int count = input.readArrayLength();
            if (count <= 0) {
                List<ServiceEndpoint> list = Collections.emptyList();
                return list;
            }
            ArrayList<ServiceEndpoint> eps = new ArrayList<ServiceEndpoint>(count);
            while (count-- > 0) {
                ServiceEndpoint se = ServiceEndpoint.readFrom(input);
                eps.add(se);
            }
            ArrayList<ServiceEndpoint> arrayList = eps;
            return arrayList;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    @Override
    public List<Integer> services() throws AmazonClientException {
        ClientTube tube = null;
        try {
            tube = this.mStubs.services_N1016793520_1();
            DaxCborInputStream input = tube.getInputStream();
            List list = (List)input.readObject();
            return list;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    @Override
    public List<Integer> methods(int serviceId) throws AmazonClientException {
        ClientTube tube = null;
        try {
            tube = this.mStubs.methods_785068263_1(serviceId);
            DaxCborInputStream input = tube.getInputStream();
            List list = (List)input.readObject();
            return list;
        }
        catch (Throwable e) {
            throw this.handleException(e, tube);
        }
        finally {
            this.mTubePool.recycle(tube);
        }
    }

    public void shutdown() {
        this.mTubePool.close();
    }

    public void reapIdleConnections() {
        this.mTubePool.reapIdleTubes();
    }

    protected AmazonClientException handleTransactionException(Throwable txe, List<Map<String, AttributeValue>> keys, ClientTube tube) {
        AmazonClientException ex = this.handleException(txe, tube);
        if (ex instanceof TransactionCanceledException) {
            DaxTransactionCanceledException tce = (DaxTransactionCanceledException)((Object)txe);
            try {
                int requestLength = keys.size();
                if (tce.getReasonCodes().length != requestLength) {
                    throw new MalformedResultException("Cancellation reasons must be the same length as transact write items in the request");
                }
                ArrayList<CancellationReason> cancellationReasons = new ArrayList<CancellationReason>(requestLength);
                DaxCborInputStream reasonItemsStream = new DaxCborInputStream(tce.getReasonItems());
                for (int i = 0; i < requestLength; ++i) {
                    Map<String, AttributeValue> item = AttributeValueDecoder.decodeValue(reasonItemsStream, this.mAttrListCache, null);
                    if (item != null) {
                        item.putAll(keys.get(i));
                    }
                    cancellationReasons.add(new CancellationReason().withCode(tce.getReasonCodes()[i]).withMessage(tce.getReasonMsgs()[i]).withItem(item));
                }
                ((TransactionCanceledException)ex).setCancellationReasons(cancellationReasons);
                return ex;
            }
            catch (Throwable t) {
                return this.handleException(t, tube);
            }
        }
        return ex;
    }

    protected AmazonClientException handleException(Throwable e, ClientTube tube) {
        try {
            throw e;
        }
        catch (DaxServiceException dce) {
            return ExceptionTranslator.translateException(dce);
        }
        catch (AmazonClientException de) {
            this.mTubePool.reset(tube);
            return de;
        }
        catch (IllegalArgumentException iae) {
            this.mTubePool.reset(tube);
            return ExceptionTranslator.createValidationException(iae.getMessage());
        }
        catch (IOException ioe) {
            if (!DaxClient.isPoolTimeout(ioe)) {
                this.mTubePool.reset(tube);
                if (this.mExceptionListener != null) {
                    this.mExceptionListener.onIoException(ioe);
                }
            }
            return new AmazonClientException((Throwable)ioe);
        }
        catch (Exception ex) {
            this.mTubePool.reset(tube);
            return new AmazonClientException((Throwable)ex);
        }
        catch (Throwable t) {
            this.mTubePool.reset(tube);
            this.castAndThrow(e);
            return null;
        }
    }

    private static boolean isPoolTimeout(IOException e) {
        return e != null && e instanceof ConnectException && e.getMessage() != null && e.getMessage().startsWith("Timeout");
    }

    private <E extends Throwable> void castAndThrow(Throwable e) throws E {
        throw e;
    }

    private List<ConsumedCapacity> verifyBatchConsumedCapacity(List<ConsumedCapacity> consumedCapacityByTable, Set<String> tables) {
        HashSet<String> tablesWithConsumedCapacity = new HashSet<String>();
        if (consumedCapacityByTable == null) {
            consumedCapacityByTable = new ArrayList<ConsumedCapacity>();
        }
        for (ConsumedCapacity capacity : consumedCapacityByTable) {
            if (capacity == null) continue;
            tablesWithConsumedCapacity.add(capacity.getTableName());
        }
        for (String table : tables) {
            if (tablesWithConsumedCapacity.contains(table)) continue;
            ConsumedCapacity consumedCapacity = new ConsumedCapacity();
            consumedCapacity.setTableName(table);
            consumedCapacity.setCapacityUnits(Double.valueOf(0.0));
            consumedCapacityByTable.add(consumedCapacity);
        }
        return consumedCapacityByTable;
    }

    private static boolean isValid(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == '-';
    }

    private static void validateTableName(String tableName) {
        if (tableName == null) {
            throw ExceptionTranslator.createValidationException("Invalid table/index name.  Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
        int sz = (tableName = tableName.trim()).length();
        if (sz < 3 || sz > 255) {
            throw ExceptionTranslator.createValidationException("Invalid table/index name.  Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
        for (int i = 0; i < sz; ++i) {
            if (DaxClient.isValid(tableName.charAt(i))) continue;
            throw ExceptionTranslator.createValidationException("Invalid table/index name.  Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'");
        }
    }

    private static String readClientVersion() {
        String version = null;
        try {
            InputStream in = DaxClient.class.getResourceAsStream("client.properties");
            Properties props = new Properties();
            props.load(in);
            in.close();
            version = props.getProperty("version");
            if (version != null) {
                return version;
            }
        }
        catch (Throwable in) {
            // empty catch block
        }
        try {
            version = DaxClient.class.getPackage().getImplementationVersion();
            return version == null ? CLIENT_VERSION_UNKNOWN : version;
        }
        catch (Throwable t) {
            return CLIENT_VERSION_UNKNOWN;
        }
    }

    private void validateRequestCredentials(AmazonWebServiceRequest request) {
        if (request.getRequestCredentialsProvider() != null || request.getRequestCredentials() != null) {
            throw new AmazonClientException("DAX does not support overriding the AWSCredentialsProvider on individual requests (e.g., by calling setRequestCredentialsProvider).");
        }
    }

    public static Builder builder(ClientConfig config) {
        return new Builder(config);
    }

    static {
        RESPONSE_PARAMS = Constants.DaxResponseParam.values();
        USER_AGENT = USER_AGENT_PREFIX + DaxClient.readClientVersion();
    }

    public static final class Builder {
        private String region;
        private AWSCredentialsProvider credentialsProvider;
        private int readRetries;
        private int writeRetries;
        private BackoffStrategy backoffStrategy;
        private String hostname;
        private int port;
        private long tubeTtlMs = TimeUnit.MINUTES.toMillis(1L);
        private int minIdleConnectionSize;
        private int requestTimeoutMs;
        private int maxPendingConnectsPerHost;
        private int connectTimeoutMs;
        private long threadKeepAliveNs;
        private boolean useSSL = false;

        private Builder(ClientConfig config) {
            if (config.getHostPorts() != null && config.getHostPorts().length == 1) {
                this.withHostname(config.getHostPorts()[0].host());
                this.withPort(config.getHostPorts()[0].port());
            }
            this.withRegion(config.getRegion());
            this.withCredentialsProvider(config.getCredentialsProvider());
            this.withReadRetries(config.getReadRetries());
            this.withWriteRetries(config.getWriteRetries());
            this.withRequestTimeoutMs((int)TimeUnit.NANOSECONDS.toMillis(config.getRequestTimeout()));
            this.withConnectTimeoutMs((int)TimeUnit.NANOSECONDS.toMillis(config.getConnectTimeout()));
            this.withMaxPendingConnectsPerHost(config.getMaxPendingConnectsPerHost());
            this.withMinIdleConnectionSize(config.getMinIdleConnectionSize());
            this.withThreadKeepAliveNs(config.getThreadKeepAlive());
            this.withSSL(config.isEncrypted());
        }

        public DaxClient build() {
            Connector connector = new Connector(this.connectTimeoutMs, this.threadKeepAliveNs);
            DaxConnectorBase daxConnector = this.useSSL ? new DaxTlsConnector(connector, this.requestTimeoutMs, this.maxPendingConnectsPerHost, DaxClient.getUserAgent(), this.connectTimeoutMs, null, this.tubeTtlMs, DaxHostnameVerifier.getNoOpVerifier()) : new DaxConnector(connector, this.requestTimeoutMs, this.maxPendingConnectsPerHost, DaxClient.getUserAgent(), this.connectTimeoutMs, null, this.tubeTtlMs);
            SocketTubePool tubePool = new SocketTubePool(new InetSocketAddress(this.hostname, this.port), SessionVersion.create(), daxConnector, null, this.connectTimeoutMs, null, this.minIdleConnectionSize);
            return new DaxClient(tubePool, this.region, this.credentialsProvider, null, this.readRetries, this.writeRetries, this.backoffStrategy);
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withReadRetries(int readRetries) {
            this.readRetries = readRetries;
            return this;
        }

        public Builder withWriteRetries(int writeRetries) {
            this.writeRetries = writeRetries;
            return this;
        }

        public Builder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withTubeTtlMs(long tubeTtlMs) {
            this.tubeTtlMs = tubeTtlMs;
            return this;
        }

        public Builder withMinIdleConnectionSize(int minIdleConnectionSize) {
            this.minIdleConnectionSize = minIdleConnectionSize;
            return this;
        }

        public Builder withRequestTimeoutMs(int requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
            return this;
        }

        public Builder withMaxPendingConnectsPerHost(int maxPendingConnectsPerHost) {
            this.maxPendingConnectsPerHost = maxPendingConnectsPerHost;
            return this;
        }

        public Builder withConnectTimeoutMs(int connectionTimeoutMs) {
            this.connectTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder withThreadKeepAliveNs(long threadKeepAliveNs) {
            this.threadKeepAliveNs = threadKeepAliveNs;
            return this;
        }

        public Builder withSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }
    }

    public static interface Supplier<T> {
        public T get() throws AmazonClientException;
    }

    private static enum UnsignedComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] a, byte[] b) {
            return Utils.compareUnsigned(a, b);
        }
    }
}

