/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.dynamodb.AttributeValue;
import com.amazon.dax.bits.dynamodb.AttributeValueUtil;
import com.amazon.dax.client.dynamodbv2.DynamoDBExpressionInfo;
import com.amazon.dax.client.dynamodbv2.ExceptionTranslator;
import com.amazon.dax.client.dynamodbv2.RequestValidator;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamoDBV1Converter {
    private static final String VALUE_PREFIX = ":val";
    private static final String NAME_PREFIX = "#key";

    public static boolean isV1Request(UpdateItemRequest updateRequest) {
        return !DynamoDBV1Converter.isMapEmpty(updateRequest.getExpected()) || !DynamoDBV1Converter.isMapEmpty(updateRequest.getAttributeUpdates());
    }

    public static boolean isV1Request(QueryRequest queryRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)queryRequest.getAttributesToGet()) || !DynamoDBV1Converter.isMapEmpty(queryRequest.getQueryFilter()) || !DynamoDBV1Converter.isMapEmpty(queryRequest.getKeyConditions());
    }

    public static boolean isV1Request(ScanRequest scanRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)scanRequest.getAttributesToGet()) || !DynamoDBV1Converter.isMapEmpty(scanRequest.getScanFilter());
    }

    public static boolean isV1Request(PutItemRequest putItemRequest) {
        return !DynamoDBV1Converter.isMapEmpty(putItemRequest.getExpected());
    }

    public static boolean isV1Request(DeleteItemRequest deleteItemRequest) {
        return !DynamoDBV1Converter.isMapEmpty(deleteItemRequest.getExpected());
    }

    public static boolean isV1Request(GetItemRequest getItemRequest) {
        return !CollectionUtils.isNullOrEmpty((Collection)getItemRequest.getAttributesToGet());
    }

    public static boolean isV1Request(KeysAndAttributes keysAndAttributes) {
        return !CollectionUtils.isNullOrEmpty((Collection)keysAndAttributes.getAttributesToGet());
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(GetItemRequest request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.getAttributesToGet(), exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(UpdateItemRequest request) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrVal = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String updateExpression = null;
        String conditionExpression = null;
        if (!DynamoDBV1Converter.isMapEmpty(request.getExpected())) {
            conditionExpression = DynamoDBV1Converter.convertExpectedToCondExpr(request.getExpected(), request.getConditionalOperator(), exprAttrVal, exprAttrName);
        }
        if (!DynamoDBV1Converter.isMapEmpty(request.getAttributeUpdates())) {
            updateExpression = DynamoDBV1Converter.convertUpdateAttributesToUpdateExpr(request.getAttributeUpdates(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(conditionExpression).setUpdateExpression(updateExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(DeleteItemRequest request) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrVal = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String condExpr = DynamoDBV1Converter.convertExpectedToCondExpr(request.getExpected(), request.getConditionalOperator(), exprAttrVal, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(condExpr).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(QueryRequest request) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrVal;
        String projectionExpression = request.getProjectionExpression();
        String keyConditionsExpression = request.getKeyConditionExpression();
        String filterExpression = request.getFilterExpression();
        HashMap<String, String> exprAttrName = request.getExpressionAttributeNames();
        if (!(exprAttrName != null || CollectionUtils.isNullOrEmpty((Collection)request.getAttributesToGet()) && DynamoDBV1Converter.isMapEmpty(request.getQueryFilter()) && DynamoDBV1Converter.isMapEmpty(request.getKeyConditions()))) {
            exprAttrName = new HashMap();
        } else if (exprAttrName != null) {
            exprAttrName = new HashMap<String, String>(exprAttrName);
        }
        if (request.getAttributesToGet() != null) {
            projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.getAttributesToGet(), exprAttrName);
        }
        if (!((exprAttrVal = request.getExpressionAttributeValues()) != null || DynamoDBV1Converter.isMapEmpty(request.getKeyConditions()) && DynamoDBV1Converter.isMapEmpty(request.getQueryFilter()))) {
            exprAttrVal = new HashMap();
        } else if (exprAttrVal != null) {
            exprAttrVal = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>(exprAttrVal);
        }
        if (request.getKeyConditions() != null) {
            keyConditionsExpression = DynamoDBV1Converter.convertKeyCondToExpr(request.getKeyConditions(), exprAttrVal, exprAttrName);
        }
        if (request.getQueryFilter() != null) {
            filterExpression = DynamoDBV1Converter.convertFilterToExpression(request.getQueryFilter(), request.getConditionalOperator(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setKeyConditionExpression(keyConditionsExpression).setFilterExpression(filterExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(ScanRequest request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrVal = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        String projectionExpression = null;
        String filterExpression = null;
        if (request.getAttributesToGet() != null) {
            projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.getAttributesToGet(), exprAttrName);
        }
        if (!DynamoDBV1Converter.isMapEmpty(request.getScanFilter())) {
            filterExpression = DynamoDBV1Converter.convertFilterToExpression(request.getScanFilter(), request.getConditionalOperator(), exprAttrVal, exprAttrName);
        }
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setFilterExpression(filterExpression).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(PutItemRequest request) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrVal = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String condExpr = DynamoDBV1Converter.convertExpectedToCondExpr(request.getExpected(), request.getConditionalOperator(), exprAttrVal, exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setConditionExpression(condExpr).setExpressionAttributeValues(exprAttrVal).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    public static DynamoDBExpressionInfo convertV1RequestToV2(KeysAndAttributes request) {
        HashMap<String, String> exprAttrName = new HashMap<String, String>();
        String projectionExpression = DynamoDBV1Converter.convertAttrToGetToProjExpr(request.getAttributesToGet(), exprAttrName);
        return new DynamoDBExpressionInfo.DynamoDBExpressionInfoBuilder().setProjectionExpression(projectionExpression).setExpressionAttributeNames(exprAttrName).createDynamoDBExpressionInfo();
    }

    private static <T, V> boolean isMapEmpty(Map<T, V> map) {
        return null == map || map.isEmpty();
    }

    private static <T> void convertToExpressionAttributeString(StringBuilder sb, Iterable<T> attrs, String prefix, String delimiter, Map<String, T> eans) {
        boolean addDelimiter = false;
        for (T attr : attrs) {
            String exprName = DynamoDBV1Converter.appendToExpAttrMap(attr, eans, prefix);
            if (addDelimiter) {
                sb.append(delimiter);
            } else {
                addDelimiter = true;
            }
            sb.append(exprName);
        }
    }

    public static String convertAttrToGetToProjExpr(List<String> attrToGet, Map<String, String> newExpressionAttributeNames) {
        if (attrToGet == null) {
            throw new IllegalArgumentException("attrToGet cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        DynamoDBV1Converter.convertToExpressionAttributeString(sb, attrToGet, NAME_PREFIX, ",", newExpressionAttributeNames);
        return sb.toString();
    }

    private static String getOrDefaultCondition(String condOperator) {
        if (condOperator == null) {
            return "AND";
        }
        return condOperator;
    }

    public static String convertFilterToExpression(Map<String, Condition> filter, String condOperator, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        condOperator = DynamoDBV1Converter.getOrDefaultCondition(condOperator);
        for (Map.Entry<String, Condition> entry : filter.entrySet()) {
            if (entry.getValue() == null) continue;
            if (b) {
                sb.append(' ').append(condOperator).append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeToFilterExpression(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrName);
        }
        if (sb.toString().isEmpty()) {
            return null;
        }
        return sb.toString();
    }

    private static void encodeToFilterExpression(StringBuilder sb, String keyName, Condition condition, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        String eName = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrName, NAME_PREFIX);
        String compOp = condition.getComparisonOperator();
        RequestValidator.validateComparisonOperator(compOp, keyName);
        List avl = condition.getAttributeValueList();
        DynamoDBV1Converter.constructFilterOrExpectedCompOpExpression(sb, compOp, eName, keyName, avl, eAttrVal, "Unsupported operator on ExpectedAttributeValue: " + condition);
    }

    private static void constructFilterOrExpectedCompOpExpression(StringBuilder sb, String compOp, String eName, String keyName, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, String errorMessage) {
        String op;
        switch (ComparisonOperator.fromValue((String)compOp)) {
            case BETWEEN: {
                DynamoDBV1Converter.handleBetweenCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case BEGINS_WITH: {
                DynamoDBV1Converter.handleBeginsWithCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case NOT_CONTAINS: {
                sb.append("attribute_exists(").append(eName).append(") AND NOT ");
            }
            case CONTAINS: {
                DynamoDBV1Converter.handleContainsCondition(sb, compOp, eName, avl, eAttrVal, keyName);
                return;
            }
            case NOT_NULL: {
                DynamoDBV1Converter.checkNumArguments(compOp, 0, avl, keyName);
                sb.append("attribute_exists(").append(eName).append(")");
                return;
            }
            case NULL: {
                DynamoDBV1Converter.checkNumArguments(compOp, 0, avl, keyName);
                sb.append("attribute_not_exists(").append(eName).append(")");
                return;
            }
            case IN: {
                DynamoDBV1Converter.handleInCondition(sb, compOp, eName, keyName, avl, eAttrVal);
                return;
            }
            case EQ: {
                op = "=";
                break;
            }
            case LE: {
                op = "<=";
                break;
            }
            case LT: {
                op = "<";
                break;
            }
            case GE: {
                op = ">=";
                break;
            }
            case GT: {
                op = ">";
                break;
            }
            case NE: {
                op = "<>";
                break;
            }
            default: {
                throw new IllegalArgumentException(errorMessage);
            }
        }
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        com.amazonaws.services.dynamodbv2.model.AttributeValue av1 = avl.get(0);
        DynamoDBV1Converter.checkValidBSNType(compOp, av1);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(av1, eAttrVal, VALUE_PREFIX);
        sb.append(eName).append(' ').append(op).append(' ').append(eav0);
    }

    public static String convertExpectedToCondExpr(Map<String, ExpectedAttributeValue> expected, String condOperator, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        condOperator = DynamoDBV1Converter.getOrDefaultCondition(condOperator);
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            if (b) {
                sb.append(' ').append(condOperator).append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeConditionExpression(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrName);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private static void encodeConditionExpression(StringBuilder sb, String keyName, ExpectedAttributeValue eav, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        if (eav == null) {
            return;
        }
        String eName = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrName, NAME_PREFIX);
        String compOp = eav.getComparisonOperator();
        if (compOp == null) {
            DynamoDBV1Converter.handleExistsCriteria(sb, keyName, eav, eName, eAttrVal, eAttrName);
            return;
        }
        if (eav.getExists() != null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Exists and ComparisonOperator cannot be used together for Attribute: " + keyName);
        }
        List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl = eav.getAttributeValueList();
        if (avl == null) {
            if (eav.getValue() != null) {
                avl = Arrays.asList(eav.getValue());
            }
        } else if (eav.getValue() != null) {
            throw ExceptionTranslator.createValidationException("Value and AttributeValueList cannot be used together for Attribute: " + keyName);
        }
        DynamoDBV1Converter.constructFilterOrExpectedCompOpExpression(sb, compOp, eName, keyName, avl, eAttrVal, "Unsupported operator on ExpectedAttributeValue: " + eav);
    }

    public static String convertUpdateAttributesToUpdateExpr(Map<String, AttributeValueUpdate> attrValUpdates, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> exprAttrValues, Map<String, String> exprAttrNames) {
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        ArrayList<String> removes = new ArrayList<String>();
        block7: for (Map.Entry<String, AttributeValueUpdate> entry : attrValUpdates.entrySet()) {
            String attributeName = entry.getKey();
            AttributeValueUpdate update = entry.getValue();
            if (update == null) continue;
            String actionString = update.getAction() != null ? update.getAction() : "PUT";
            AttributeAction action = null;
            try {
                action = AttributeAction.fromValue((String)actionString);
            }
            catch (IllegalArgumentException e) {
                throw ExceptionTranslator.createValidationException("Member must satisfy enum value set: [ADD, DELETE, PUT]");
            }
            if (update.getValue() == null && action != AttributeAction.DELETE) {
                throw ExceptionTranslator.createValidationException("Only DELETE action is allowed when no attribute value is specified");
            }
            switch (action) {
                case PUT: {
                    String putExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " = " + DynamoDBV1Converter.appendToExpAttrMap(update.getValue(), exprAttrValues, VALUE_PREFIX);
                    sets.add(putExpression);
                    continue block7;
                }
                case ADD: {
                    String addExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " " + DynamoDBV1Converter.appendToExpAttrMap(update.getValue(), exprAttrValues, VALUE_PREFIX);
                    adds.add(addExpression);
                    continue block7;
                }
                case DELETE: {
                    String deleteExpression;
                    if (update.getValue() != null) {
                        deleteExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX) + " " + DynamoDBV1Converter.appendToExpAttrMap(update.getValue(), exprAttrValues, VALUE_PREFIX);
                        deletes.add(deleteExpression);
                        continue block7;
                    }
                    deleteExpression = DynamoDBV1Converter.appendToExpAttrMap(attributeName, exprAttrNames, NAME_PREFIX);
                    removes.add(deleteExpression);
                    continue block7;
                }
            }
            throw ExceptionTranslator.createValidationException("Invalid action passed : " + actionString);
        }
        StringBuilder updateExpression = new StringBuilder();
        if (!sets.isEmpty()) {
            DynamoDBV1Converter.generateAndAppendUpdateExpression(sets, "SET", updateExpression);
        }
        if (!adds.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(adds, "ADD", updateExpression);
        }
        if (!deletes.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(deletes, "DELETE", updateExpression);
        }
        if (!removes.isEmpty()) {
            if (updateExpression.length() != 0) {
                updateExpression.append(" ");
            }
            DynamoDBV1Converter.generateAndAppendUpdateExpression(removes, "REMOVE", updateExpression);
        }
        return updateExpression.toString();
    }

    private static void generateAndAppendUpdateExpression(List<String> list, String operation, StringBuilder updateExpression) {
        updateExpression.append(operation).append(" ").append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            updateExpression.append(", ").append(list.get(i));
        }
    }

    public static String convertKeyCondToExpr(Map<String, Condition> keyConds, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrNames) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        for (Map.Entry<String, Condition> entry : keyConds.entrySet()) {
            if (b) {
                sb.append(' ').append("AND").append(' ');
            } else {
                b = true;
            }
            DynamoDBV1Converter.encodeKeyConditions(sb, entry.getKey(), entry.getValue(), eAttrVal, eAttrNames);
        }
        return sb.toString();
    }

    private static void encodeKeyConditions(StringBuilder sb, String keyName, Condition cond, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrNames) {
        String op;
        if (null == cond) {
            throw ExceptionTranslator.createValidationException("KeyCondition cannot be null for key: " + keyName);
        }
        String compOp = cond.getComparisonOperator();
        if (null == compOp || compOp.trim().length() == 0) {
            throw ExceptionTranslator.createValidationException("ComparisonOperator cannot be empty for KeyCondition: " + cond);
        }
        List avl = cond.getAttributeValueList();
        String ean0 = DynamoDBV1Converter.appendToExpAttrMap(keyName, eAttrNames, NAME_PREFIX);
        switch (ComparisonOperator.fromValue((String)compOp)) {
            case BETWEEN: {
                DynamoDBV1Converter.handleBetweenCondition(sb, compOp, ean0, avl, eAttrVal, keyName);
                return;
            }
            case BEGINS_WITH: {
                DynamoDBV1Converter.handleBeginsWithCondition(sb, compOp, ean0, avl, eAttrVal, keyName);
                return;
            }
            case EQ: {
                op = "=";
                break;
            }
            case LE: {
                op = "<=";
                break;
            }
            case LT: {
                op = "<";
                break;
            }
            case GE: {
                op = ">=";
                break;
            }
            case GT: {
                op = ">";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator on KeyCondition: " + cond);
            }
        }
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append(ean0).append(' ').append(op).append(' ').append(eav0);
    }

    private static void handleBetweenCondition(StringBuilder sb, String compOp, String eName, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 2, avl, keyName);
        com.amazonaws.services.dynamodbv2.model.AttributeValue av1 = avl.get(0);
        com.amazonaws.services.dynamodbv2.model.AttributeValue av2 = avl.get(1);
        DynamoDBV1Converter.checkValidBSNType(compOp, av1, av2);
        DynamoDBV1Converter.checkValidBounds(av1, av2);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(av1, eAttrVal, VALUE_PREFIX);
        String eav1 = DynamoDBV1Converter.appendToExpAttrMap(av2, eAttrVal, VALUE_PREFIX);
        sb.append(eName).append(" between ").append(eav0).append(" AND ").append(eav1);
    }

    private static void handleBeginsWithCondition(StringBuilder sb, String compOp, String eName, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        com.amazonaws.services.dynamodbv2.model.AttributeValue av1 = avl.get(0);
        if (av1.getB() == null && av1.getS() == null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: ComparisonOperator " + compOp + " is not valid for " + DynamoDBV1Converter.getAttributeValueType(av1) + " AttributeValue type");
        }
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append("begins_with(").append(eName).append(", ").append(eav0).append(")");
    }

    private static void handleContainsCondition(StringBuilder sb, String compOp, String eName, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, String keyName) {
        DynamoDBV1Converter.checkNumArguments(compOp, 1, avl, keyName);
        com.amazonaws.services.dynamodbv2.model.AttributeValue av1 = avl.get(0);
        DynamoDBV1Converter.checkValidBSNBoolNullTypes(compOp, av1);
        String eav0 = DynamoDBV1Converter.appendToExpAttrMap(avl.get(0), eAttrVal, VALUE_PREFIX);
        sb.append("contains(").append(eName).append(", ").append(eav0).append(")");
    }

    private static void handleInCondition(StringBuilder sb, String compOp, String eName, String keyName, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal) {
        if (avl == null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value or AttributeValueList must be used with ComparisonOperator: IN for Attribute: " + keyName);
        }
        if (avl.isEmpty()) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Invalid number of argument(s) for the IN ComparisonOperator");
        }
        DynamoDBV1Converter.checkValidBSNType(compOp, avl.toArray(new com.amazonaws.services.dynamodbv2.model.AttributeValue[avl.size()]));
        sb.append(eName).append(" IN (");
        DynamoDBV1Converter.convertToExpressionAttributeString(sb, avl, VALUE_PREFIX, ",", eAttrVal);
        sb.append(")");
    }

    private static void handleExistsCriteria(StringBuilder sb, String keyName, ExpectedAttributeValue eav, String eName, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> eAttrVal, Map<String, String> eAttrName) {
        if (eav.getExists() != null || eav.getValue() != null) {
            if (eav.getExists() == null || eav.getExists().booleanValue()) {
                if (eav.getAttributeValueList() != null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
                }
                if (eav.getValue() == null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value must be provided when Exists is true for Attribute: " + keyName);
                }
                String eav0 = DynamoDBV1Converter.appendToExpAttrMap(eav.getValue(), eAttrVal, VALUE_PREFIX);
                sb.append(eName).append(" = ").append(eav0);
            } else {
                if (eav.getValue() != null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value cannot be used when Exists is false for Attribute: " + keyName);
                }
                if (eav.getAttributeValueList() != null) {
                    throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
                }
                sb.append("attribute_not_exists(").append(eName).append(")");
            }
            return;
        }
        if (eav.getAttributeValueList() != null) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
        }
        throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value must be provided when Exists is null for Attribute: " + keyName);
    }

    private static void checkNumArguments(String compOp, int expectedArgs, List<com.amazonaws.services.dynamodbv2.model.AttributeValue> avl, String keyName) {
        int size;
        int n = size = avl == null ? 0 : avl.size();
        if (avl == null && expectedArgs > 0) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Value or AttributeValueList must be used with ComparisonOperator: " + compOp + " for Attribute: " + keyName);
        }
        if (size != expectedArgs) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: Invalid number of argument(s) for the " + compOp + " ComparisonOperator");
        }
    }

    private static void checkValidBSNBoolNullTypes(String compOp, com.amazonaws.services.dynamodbv2.model.AttributeValue ... avs) {
        for (com.amazonaws.services.dynamodbv2.model.AttributeValue av : avs) {
            if (av.getBOOL() != null || av.getNULL() != null) continue;
            DynamoDBV1Converter.checkValidBSNType(compOp, av);
        }
    }

    private static void checkValidBSNType(String compOp, com.amazonaws.services.dynamodbv2.model.AttributeValue ... avs) {
        if (compOp == "EQ" || compOp == "NE") {
            return;
        }
        for (com.amazonaws.services.dynamodbv2.model.AttributeValue av : avs) {
            if (av.getB() != null || av.getS() != null || av.getN() != null) continue;
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: ComparisonOperator " + compOp + " is not valid for " + DynamoDBV1Converter.getAttributeValueType(av) + " AttributeValue type");
        }
    }

    private static void checkValidBounds(com.amazonaws.services.dynamodbv2.model.AttributeValue lowerBound, com.amazonaws.services.dynamodbv2.model.AttributeValue upperBound) {
        Double doubleUpperBound;
        Double doubleLowerBound;
        AttributeValue lb = AttributeValueUtil.from(lowerBound);
        AttributeValue ub = AttributeValueUtil.from(upperBound);
        if (!lb.getType().equals(ub.getType())) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValues inside AttributeValueList must be of same type");
        }
        if (lb.type == 1 ? lowerBound.getS().compareTo(upperBound.getS()) > 0 : lb.type == 2 && (doubleLowerBound = Double.valueOf(lowerBound.getN())).compareTo(doubleUpperBound = Double.valueOf(upperBound.getN())) > 0) {
            throw ExceptionTranslator.createValidationException("The BETWEEN condition was provided a range where the lower bound is greater than the upper bound");
        }
    }

    private static <T> String appendToExpAttrMap(T strVal, Map<String, T> exprAttributeMap, String prefix) {
        int suffix = exprAttributeMap.size();
        while (exprAttributeMap.containsKey(prefix + suffix)) {
            ++suffix;
        }
        exprAttributeMap.put(prefix + suffix, strVal);
        return prefix + suffix;
    }

    private static String getAttributeValueType(com.amazonaws.services.dynamodbv2.model.AttributeValue value) {
        return AttributeValueUtil.from(value).getType();
    }
}

