/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.dynamodbv2.ExceptionTranslator;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class RequestValidator {
    private static final int MAX_EXPRESSION_SIZE = 4096;
    private static final int MAX_PARAMETER_MAP_KEY_SIZE = 255;
    private static final int MAX_PARAMETER_MAP_ENTRIES = 0x200000;
    private static final int MAX_READ_BATCH_SIZE = 100;
    private static final int BATCH_WRITE_MAX_ITEM_SIZE = 409600;
    private static final int MAX_ATTRIBUTENAME_SIZE = 65535;

    RequestValidator() {
    }

    static void validateExpression(String condExpr, String updExpr, String projExpr, String filterExpr, String keyCondExpr, String condOp, Map<String, ExpectedAttributeValue> expAttrVals, Map<String, AttributeValueUpdate> attrUpdates, List<String> attributesToGet, Map<String, Condition> queryFilter, Map<String, Condition> scanFilter, Map<String, Condition> keyCondition, Map<String, String> attrNames, Map<String, AttributeValue> attrVals) {
        int attrNameMapSize = 0;
        if (attrNames != null) {
            if (condExpr == null && updExpr == null && projExpr == null && filterExpr == null && keyCondExpr == null) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames can only be specified when using expressions");
            }
            attrNameMapSize = RequestValidator.validateExprAttrNames(attrNames);
            if (attrNameMapSize > 0x200000) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
            }
        }
        int attrValuesMapSize = 0;
        if (attrVals != null) {
            if (condExpr == null && updExpr == null && filterExpr == null && keyCondExpr == null) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues can only be specified when using expressions");
            }
            attrValuesMapSize = RequestValidator.validateExprAttrValues(attrVals);
            if (attrValuesMapSize > 0x200000) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues exceeds max size");
            }
        }
        if (attrNameMapSize + attrValuesMapSize > 0x200000) {
            throw RequestValidator.newValidationException("Combined size of ExpressionAttributeNames and ExpressionAttributeValues exceeds max size");
        }
        if (expAttrVals != null) {
            for (Map.Entry<String, ExpectedAttributeValue> e : expAttrVals.entrySet()) {
                String k = e.getKey();
                ExpectedAttributeValue v = e.getValue();
                if (v == null || v.getValue() == null || v.getAttributeValueList() == null) continue;
                throw RequestValidator.newValidationException("One or more parameter values were invalid: Value and AttributeValueList cannot be used together for Attribute: " + k);
            }
        }
        if (condExpr != null || updExpr != null) {
            if (attrUpdates != null || condOp != null || expAttrVals != null) {
                throw ExceptionTranslator.createValidationException("Can not use both expression and non-expression parameters in the same request");
            }
            if (condExpr != null) {
                if (condExpr.isEmpty()) {
                    throw RequestValidator.newValidationException("Invalid ConditionExpression: The expression can not be empty");
                }
                if (condExpr.length() > 4096) {
                    throw RequestValidator.newValidationException("Invalid ConditionExpression: Expression size has exceeded the maximum allowed size (4096)");
                }
            }
            if (updExpr != null) {
                if (updExpr.isEmpty()) {
                    throw RequestValidator.newValidationException("Invalid UpdateExpression: The expression can not be empty");
                }
                if (updExpr.length() > 4096) {
                    throw RequestValidator.newValidationException("Invalid UpdateExpression: Expression size has exceeded the maximum allowed size (4096)");
                }
            }
        }
        if (keyCondExpr != null) {
            if (keyCondExpr.isEmpty()) {
                throw RequestValidator.newValidationException("Invalid KeyConditionExpression: The expression can not be empty");
            }
            if (keyCondExpr.length() > 4096) {
                throw RequestValidator.newValidationException("Invalid KeyConditionExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (projExpr != null) {
            if (projExpr.isEmpty()) {
                throw RequestValidator.newValidationException("Invalid ProjectionExpression: The expression can not be empty");
            }
            if (RequestValidator.expressionLength(projExpr, attrNames) > 4096) {
                throw RequestValidator.newValidationException("Invalid ProjectionExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (filterExpr != null) {
            if (filterExpr.isEmpty()) {
                throw RequestValidator.newValidationException("Invalid FilterExpression: The expression can not be empty");
            }
            if (filterExpr.length() > 4096) {
                throw RequestValidator.newValidationException("Invalid FilterExpression: Expression size has exceeded the maximum allowed size (4096)");
            }
        }
        if (projExpr != null || filterExpr != null || keyCondExpr != null) {
            String nonExprParams = null;
            String exprParams = null;
            if (projExpr != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "ProjectionExpression");
            }
            if (filterExpr != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "FilterExpression");
            }
            if (keyCondExpr != null) {
                exprParams = RequestValidator.appendParameterName(exprParams, "KeyConditionExpression");
            }
            if (attributesToGet != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "AttributesToGet");
            }
            if (scanFilter != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "ScanFilter");
            }
            if (queryFilter != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "QueryFilter");
            }
            if (condOp != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "ConditionalOperator");
            }
            if (keyCondExpr != null && keyCondition != null) {
                nonExprParams = RequestValidator.appendParameterName(nonExprParams, "KeyConditions");
            }
            if (nonExprParams != null) {
                throw RequestValidator.newValidationException("Can not use both expression and non-expression parameters in the same request: Non-expression parameters: {" + nonExprParams + "} Expression parameters: {" + exprParams + "}");
            }
        }
        if (condOp != null) {
            if (expAttrVals == null && queryFilter == null && scanFilter == null) {
                throw ExceptionTranslator.createValidationException("ConditionalOperator cannot be used without Filter or Expected");
            }
            if (expAttrVals != null && expAttrVals.size() <= 1 || queryFilter != null && queryFilter.size() <= 1 || scanFilter != null && scanFilter.size() <= 1) {
                throw ExceptionTranslator.createValidationException("ConditionalOperator can only be used when Filter or Expected has two or more elements");
            }
        }
    }

    private static int expressionLength(String expr, Map<String, String> subs) {
        if (expr == null) {
            return 0;
        }
        if (subs == null) {
            return expr.length();
        }
        int length = expr.length();
        for (Map.Entry<String, String> sub : subs.entrySet()) {
            String from = sub.getKey();
            String to = sub.getValue();
            if (from.isEmpty()) continue;
            String reduced = expr.replaceAll(from, "");
            int times = (expr.length() - reduced.length()) / from.length();
            length -= times * from.length();
            length += times * (to == null ? 0 : to.length());
            expr = reduced;
        }
        return length;
    }

    private static String appendParameterName(String params, String name) {
        return params == null ? name : params + ", " + name;
    }

    public static void validateCreateTableKeySchema(List<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            throw ExceptionTranslator.createValidationException("No defined key schema.  A key schema containing at least a hash key must be defined for all tables");
        }
        if (keySchema.isEmpty()) {
            throw ExceptionTranslator.createValidationException("No Hash Key specified in schema.  All Dynamo DB tables must have exactly one hash key");
        }
        if (keySchema.size() == 1) {
            RequestValidator.validateNotNull(keySchema.get(0), "keySchema[0]");
            RequestValidator.validateNotNull(keySchema.get(0).getKeyType(), "keySchema[0].keyType");
            if (!keySchema.get(0).getKeyType().equals("HASH")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value 'hash' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
        } else if (keySchema.size() == 2) {
            String rangeKeyType;
            String hashKeyType;
            RequestValidator.validateNotNull(keySchema.get(0), "keySchema[0]");
            RequestValidator.validateNotNull(keySchema.get(1), "keySchema[1]");
            RequestValidator.validateNotNull(keySchema.get(0).getKeyType(), "keySchema[0].keyType");
            RequestValidator.validateNotNull(keySchema.get(1).getKeyType(), "keySchema[1].keyType");
            if (keySchema.get(0).getKeyType().equals("HASH")) {
                hashKeyType = keySchema.get(0).getKeyType();
                rangeKeyType = keySchema.get(1).getKeyType();
            } else if (keySchema.get(0).getKeyType().equals("RANGE")) {
                hashKeyType = keySchema.get(1).getKeyType();
                rangeKeyType = keySchema.get(0).getKeyType();
            } else {
                hashKeyType = keySchema.get(0).getKeyType();
                rangeKeyType = keySchema.get(1).getKeyType();
            }
            if (!hashKeyType.equals("HASH") && !rangeKeyType.equals("RANGE")) {
                throw ExceptionTranslator.createValidationException("2 validation errors detected: Value '" + hashKeyType + "' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]; Value '" + rangeKeyType + "' at 'keySchema.2.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
            if (!hashKeyType.equals("HASH")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + hashKeyType + "' at 'keySchema.1.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
            if (!rangeKeyType.equals("RANGE")) {
                throw ExceptionTranslator.createValidationException("1 validation error detected: Value '" + rangeKeyType + "' at 'keySchema.2.member.keyType' failed to satisfy constraint: Member must satisfy enum value set: [HASH, RANGE]");
            }
        } else {
            throw ExceptionTranslator.createValidationException(keySchema.size() + " validation errors detected: Value 'keySchema' failed to satisfy constraint: Member must have length less than or equal to 2");
        }
    }

    public static void validate(BatchGetItemRequest request) {
        Map requestItems = request.getRequestItems();
        if (requestItems == null) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'requestItems' failed to satisfy constraint: Member must not be null");
        }
        boolean foundAttrsToGet = false;
        boolean foundProjExpr = false;
        boolean foundAttrNames = false;
        boolean isEmpty = true;
        int attrNamesMapSize = 0;
        int batchSize = 0;
        for (Map.Entry tableAndRequest : requestItems.entrySet()) {
            String tableName = (String)tableAndRequest.getKey();
            RequestValidator.validateTableName(tableName);
            KeysAndAttributes kaas = (KeysAndAttributes)tableAndRequest.getValue();
            if (kaas == null) {
                throw RequestValidator.newValidationException("Request can not be null for table " + tableName);
            }
            if (kaas.getKeys() == null) {
                throw RequestValidator.newValidationException("Keys can not be null for table " + tableName);
            }
            if (kaas.getKeys().isEmpty()) {
                throw RequestValidator.newValidationException("Keys can not be empty for table " + tableName);
            }
            if ((batchSize += kaas.getKeys().size()) > 100) {
                throw RequestValidator.newValidationException("Batch size should be less than 100");
            }
            RequestValidator.validateExpression(null, null, kaas.getProjectionExpression(), null, null, null, null, null, kaas.getAttributesToGet(), null, null, null, kaas.getExpressionAttributeNames(), null);
            isEmpty = false;
            List attrsToGet = kaas.getAttributesToGet();
            String projExpr = kaas.getProjectionExpression();
            Map attrNames = kaas.getExpressionAttributeNames();
            foundAttrsToGet |= attrsToGet != null;
            foundProjExpr |= projExpr != null;
            if (attrNames != null) {
                foundAttrNames = true;
                if ((attrNamesMapSize += RequestValidator.validateExprAttrNames(attrNames)) > 0x200000) {
                    throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
                }
            }
            if (!foundAttrsToGet || !foundProjExpr && !foundAttrNames) continue;
            throw RequestValidator.newValidationException("Can not use both expression and non-expression parameters in the same request");
        }
        if (isEmpty) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'requestItems' failed to satisfy constraint: Member must not be null");
        }
    }

    public static void checkAndThrowIfSelectIsInvalidForProjectionExpression(String projectionExpression, String select) {
        if (projectionExpression != null && select != null && !Select.SPECIFIC_ATTRIBUTES.equals((Object)Select.valueOf((String)select.trim()))) {
            throw ExceptionTranslator.createValidationException("Cannot specify the ProjectionExpression when selecet is not SPECIFIC_ATTRIBUTES");
        }
    }

    public static void validateComparisonOperator(String compOp, String keyName) {
        if (null == compOp) {
            throw ExceptionTranslator.createValidationException("One or more parameter values were invalid: AttributeValueList can only be used with a ComparisonOperator for Attribute: " + keyName);
        }
    }

    public static void checkAndThrowIfSelectIsInvalidForAttributestoGet(List<String> attributesToGet, String select, String projectionExpression) {
        if (null != select) {
            if (Select.SPECIFIC_ATTRIBUTES.equals((Object)Select.valueOf((String)select.trim()))) {
                if (!(null != projectionExpression && projectionExpression.trim().length() >= 1 || null != attributesToGet && attributesToGet.size() >= 1)) {
                    throw ExceptionTranslator.createValidationException("Must specify the AttributesToGet or ProjectionExpression when choosing to get SPECIFIC_ATTRIBUTES");
                }
            } else if (null != attributesToGet) {
                throw ExceptionTranslator.createValidationException("Cannot specify the AttributesToGet when choosing to get " + select);
            }
        }
    }

    public static void validateCreateTableRequest(CreateTableRequest request) {
        RequestValidator.validateTableName(request.getTableName());
        RequestValidator.validateCreateTableKeySchema(request.getKeySchema());
        RequestValidator.validateAttributeDefinitions(request.getAttributeDefinitions());
        RequestValidator.validateListNotEmpty(request.getLocalSecondaryIndexes(), "localSecondaryIndexList");
        RequestValidator.validate(request.getProvisionedThroughput());
    }

    public static void validateLocalSecondaryIndex(LocalSecondaryIndex lsi) {
        RequestValidator.validateNotNull(lsi, "localSecondaryIndex");
        RequestValidator.validateNotNull(lsi.getProjection(), "projection");
    }

    public static void validateGlobalSecondaryIndex(GlobalSecondaryIndex gsi) {
        RequestValidator.validateNotNull(gsi, "globalSecondaryIndex");
        RequestValidator.validate(gsi.getProvisionedThroughput());
        RequestValidator.validateNotNull(gsi.getProjection(), "projection");
    }

    public static void validateTableName(String tableName) {
        RequestValidator.validateTableName(tableName, "tableName");
    }

    public static void validateTableName(String tableName, String key) {
        if (tableName == null || tableName.isEmpty()) {
            throw RequestValidator.newValidationException("Value null at '" + key + "' failed to satisfy constraint: Member must not be null");
        }
    }

    public static void validate(ProvisionedThroughput pt) {
        if (pt != null) {
            RequestValidator.validateProvisionedThroughputValue("read", pt.getReadCapacityUnits());
            RequestValidator.validateProvisionedThroughputValue("write", pt.getWriteCapacityUnits());
        }
    }

    public static void validateLimit(Integer limit) {
        if (limit != null && limit <= 0) {
            throw ExceptionTranslator.createValidationException("Limit must be a positive integer");
        }
    }

    public static void validate(WriteRequest writeRequest) {
        if (writeRequest.getPutRequest() != null && writeRequest.getDeleteRequest() != null) {
            throw RequestValidator.newValidationException("Both delete and put request cannot be set");
        }
        if (writeRequest.getPutRequest() == null && writeRequest.getDeleteRequest() == null) {
            throw RequestValidator.newValidationException("Both delete and put request cannot be empty");
        }
    }

    private static void validateProvisionedThroughputValue(String direction, Long throughPut) {
        if (throughPut == null) {
            throw RequestValidator.newValidationException("1 validation error detected: Value null at 'provisionedThroughput' failed to satisfy constraint: Member must not be null");
        }
        if (throughPut < 1L) {
            throw RequestValidator.newValidationException("1 validation error detected: Value '" + throughPut + "' at 'provisionedThroughput." + direction + "CapacityUnits' failed to satisfy constraint: Member must have value greater than or equal to 1 ");
        }
    }

    static void validateReturnValue(DynamoNumerals.ReturnValue rv, DynamoNumerals.Operation op) {
        if (rv != DynamoNumerals.ReturnValue.NONE && rv != DynamoNumerals.ReturnValue.ALL_OLD) {
            switch (op) {
                case CHECK: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Check");
                }
                case PUT: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Put");
                }
                case DELETE: {
                    throw RequestValidator.newValidationException("ReturnValues can only be ALL_OLD or NONE: Delete");
                }
            }
        }
    }

    static void validateKey(Map<String, AttributeValue> item, List<AttributeDefinition> keys) {
        if (item == null) {
            throw ExceptionTranslator.createValidationException("Value null at 'item' failed to satisfy constraint: Member must not be null");
        }
        int itemSize = item.size();
        if (itemSize != keys.size()) {
            throw ExceptionTranslator.createValidationException("The number of conditions on the keys is invalid");
        }
    }

    public static void validateTransactItem(Map<String, AttributeValue> item, String key) {
        if (item == null) {
            throw RequestValidator.newValidationException("1 validation error detected: Value " + item + " at '" + key + "' failed to satisfy constraint: Member must not be null");
        }
        if (item.isEmpty()) {
            throw RequestValidator.newValidationException("One or more parameter values were invalid: Missing the key id in the item");
        }
        RequestValidator.validateItem(item);
    }

    private static void validateItem(Map<String, AttributeValue> item) {
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            if (entry.getKey() == null) {
                if (entry.getValue() != null) {
                    throw new SdkClientException("Unable to marshall request to JSON: Unable to marshall request to JSON: Unable to marshall request to JSON: Unable to marshall request to JSON");
                }
                item.remove(null);
            }
            RequestValidator.validateAttributeValue(entry.getValue());
        }
    }

    private static void validateAttributeValue(AttributeValue attr) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (attr == null) {
                                return;
                            }
                            if (attr.getSS() == null) break block6;
                            if (attr.getSS().size() == 0) {
                                throw RequestValidator.newValidationException("One or more parameter values were invalid: An string set  may not be empty");
                            }
                            for (String s : attr.getSS()) {
                                if (s != null) continue;
                                throw RequestValidator.newValidationException("One or more parameter values were invalid: An string set may not have a null string as a member");
                            }
                            break block7;
                        }
                        if (attr.getBS() == null) break block8;
                        if (attr.getBS().size() == 0) {
                            throw RequestValidator.newValidationException("One or more parameter values were invalid: Binary sets should not be empty");
                        }
                        break block7;
                    }
                    if (attr.getNS() == null) break block9;
                    if (attr.getNS().size() == 0) {
                        throw RequestValidator.newValidationException("One or more parameter values were invalid: An number set  may not be empty");
                    }
                    break block7;
                }
                if (attr.getM() == null) break block10;
                RequestValidator.validateItem(attr.getM());
                break block7;
            }
            if (attr.getL() == null) break block7;
            for (AttributeValue av : attr.getL()) {
                RequestValidator.validateAttributeValue(av);
            }
        }
    }

    public static void validateBatchWriteItem(Map<String, AttributeValue> item) {
        if (item == null || item.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + item + " at 'item' failed to satisfy constraint: Item must not be null");
        }
        for (Map.Entry<String, AttributeValue> e : item.entrySet()) {
            int size = RequestValidator.simpleAttrValLength(e.getValue());
            if (size <= 409600) continue;
            throw RequestValidator.newValidationException("Item size has exceeded the maximum allowed size");
        }
    }

    public static void validateAttributeDefinitions(List<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null || attributeDefinitions.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + attributeDefinitions + " at 'attributeDefinitions' failed to satisfy constraint: The list must not be null or empty.");
        }
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            RequestValidator.validateNotNull(attributeDefinition, "attributeDefinition");
            RequestValidator.validateStringNotNullOrEmpty(attributeDefinition.getAttributeName(), "attributeDefinition.attributeName");
            RequestValidator.validateNotNull(attributeDefinition.getAttributeType(), "attributeDefinition.attributeType");
        }
    }

    private static <T> void validateListNotEmpty(List<T> list, String listName) {
        if (list != null && list.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. The list " + listName + "is empty. Failed to satisfy constraint: List must not be empty.");
        }
    }

    public static void validateNotNull(Object obj, String itemName) {
        if (obj == null) {
            throw RequestValidator.newValidationException("1 validation error detected. Value null at '" + itemName + "'. Failed to satisfy constraint: Item must not be null.");
        }
    }

    private static void validateStringNotNullOrEmpty(String str, String itemName) {
        if (str == null || str.isEmpty()) {
            throw RequestValidator.newValidationException("1 validation error detected. Value " + str + " at '" + itemName + "'. Failed to satisfy constraint: Item must not be null or empty.");
        }
    }

    private static int validateExprAttrNames(Map<String, String> attrNames) {
        int attrNameMapSize = 0;
        if (attrNames.isEmpty()) {
            throw RequestValidator.newValidationException("ExpressionAttributeNames must not be empty");
        }
        if (attrNames.size() >= 0x200000) {
            throw RequestValidator.newValidationException("ExpressionAttributeNames exceeds max size");
        }
        HashSet<String> attrs = new HashSet<String>();
        for (Map.Entry<String, String> e : attrNames.entrySet()) {
            String k = e.getKey();
            if (k == null) {
                throw new AmazonClientException("ExpressionAttributeNames contains invalid key: null");
            }
            String v = e.getValue();
            if (!attrs.add(v)) {
                throw RequestValidator.newValidationException("Two document paths overlap with each other; must remove or rewrite one of these paths " + v);
            }
            attrNameMapSize += k.length();
            if (v == null) {
                attrNameMapSize += 0;
            } else {
                if (v.isEmpty()) {
                    throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid value: for key " + k);
                }
                if (v.length() > 65535) {
                    throw RequestValidator.newValidationException("Member must have length less than or equal to 65535, Member must have length greater than or equal to 0");
                }
                attrNameMapSize += v.length();
            }
            if (k.isEmpty()) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid key: The expression attribute map contains an empty key");
            }
            if (k.charAt(0) != '#') {
                throw RequestValidator.newValidationException("Syntax error, ExpressionAttributeNames contains invalid key: \"" + k + "\"");
            }
            if (k.length() > 255) {
                throw RequestValidator.newValidationException("ExpressionAttributeNames contains invalid key: The expression attribute map contains a key that is too long");
            }
            if (v != null && !v.isEmpty()) continue;
            throw RequestValidator.newValidationException("ExpressionAttributeNames must not be empty");
        }
        return attrNameMapSize;
    }

    private static int validateExprAttrValues(Map<String, AttributeValue> attrVals) {
        int attrValuesMapSize = 0;
        if (attrVals.isEmpty()) {
            throw RequestValidator.newValidationException("ExpressionAttributeValues must not be empty");
        }
        if (attrVals.size() >= 0x200000) {
            throw RequestValidator.newValidationException("ExpressionAttributeValues exceeds max size");
        }
        for (Map.Entry<String, AttributeValue> e : attrVals.entrySet()) {
            String k = e.getKey();
            if (k == null) {
                throw new AmazonClientException("ExpressionAttributeValues contains invalid key: null");
            }
            attrValuesMapSize += k.length();
            attrValuesMapSize += RequestValidator.simpleAttrValLength(e.getValue());
            if (k.isEmpty()) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues contains invalid key: The expression attribute map contains an empty key");
            }
            if (!k.startsWith(":")) {
                throw RequestValidator.newValidationException("Syntax error, ExpressionAttributeValues contains invalid key: \"" + k + "\"");
            }
            if (k.length() > 255) {
                throw RequestValidator.newValidationException("ExpressionAttributeValues contains invalid key: The expression attribute map contains a key that is too long");
            }
            RequestValidator.validateAttributeValue(e.getValue());
        }
        return attrValuesMapSize;
    }

    private static AmazonServiceException newValidationException(String message) {
        return ExceptionTranslator.createValidationException(message);
    }

    private static int simpleAttrValLength(AttributeValue v) {
        if (v == null) {
            return 0;
        }
        if (v.getS() != null) {
            return v.getS().length();
        }
        if (v.getB() != null) {
            return v.getB().array().length;
        }
        if (v.getN() != null) {
            return v.getN().length();
        }
        if (v.getBS() != null) {
            int size = 0;
            for (ByteBuffer bb : v.getBS()) {
                size += bb.limit();
            }
            return size;
        }
        return 0;
    }
}

