/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.client.utils.Utils;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class SigV4Gen {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final SimpleDateFormat DATE_TIME_STAMP;
    private static final SimpleDateFormat DATE_STAMP;
    private static final String HEADER_NAME_DATE = "x-amz-date";
    private static final String HEADER_NAME_SECURITY_TOKEN = "x-amz-security-token";
    private static final String HEADER_NAME_HOST = "host";
    private static final String[] SIGNED_HEADERS;

    static SigAndStringToSign generateSigAndStringToSign(AWSCredentials creds, String endpoint, String region, String payload, Date time) {
        Map<String, String> headers = SigV4Gen.getHeaders(endpoint, time, creds);
        return SigV4Gen.getAuthorizationHeader("POST", time, headers, payload, creds, region);
    }

    public static SigAndStringToSign generateSigAndStringToSign(AWSCredentials creds, String endpoint, String region, String payload) {
        return SigV4Gen.generateSigAndStringToSign(creds, endpoint, region, payload, new Date());
    }

    public static SigAndStringToSign getAuthorizationHeader(String requestType, Date now, Map<String, String> headers, String payload, AWSCredentials awsCredentials, String region) {
        String signature;
        String credentialScope = SigV4Gen.dateTimeAsISO(now, true) + '/' + region + "/dax/aws4_request";
        String canonicalRequest = requestType + "\n/\n" + '\n' + SigV4Gen.getCanonicalHeaders(headers) + '\n' + SigV4Gen.getSignedHeaders() + '\n' + SigV4Gen.SHA256(payload);
        String stringToSign = "AWS4-HMAC-SHA256\n" + SigV4Gen.dateTimeAsISO(now, false) + '\n' + credentialScope + '\n' + SigV4Gen.SHA256(canonicalRequest);
        byte[] signingKey = SigV4Gen.getSignatureKey(awsCredentials.getAWSSecretKey(), SigV4Gen.dateTimeAsISO(now, true), region, "dax");
        try {
            signature = new String(Hex.encodeHex((byte[])SigV4Gen.HmacSHA256(stringToSign, signingKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate signature", e);
        }
        if (awsCredentials instanceof AWSSessionCredentials) {
            return new SigAndStringToSign(signature, stringToSign, ((AWSSessionCredentials)awsCredentials).getSessionToken());
        }
        return new SigAndStringToSign(signature, stringToSign, null);
    }

    private static String getCanonicalHeaders(Map<String, String> headers) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String h : SIGNED_HEADERS) {
            stringBuilder.append(h).append(":").append(headers.get(h)).append('\n');
        }
        return stringBuilder.toString();
    }

    private static String getSignedHeaders() {
        return Utils.stringJoin(";", SIGNED_HEADERS);
    }

    private static Map<String, String> getHeaders(String hostname, Date now, AWSCredentials awsCredentials) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (hostname.startsWith("https://")) {
            hostname = hostname.substring(8);
        }
        headers.put(HEADER_NAME_HOST, hostname);
        headers.put(HEADER_NAME_DATE, SigV4Gen.dateTimeAsISO(now, false));
        if (awsCredentials instanceof AWSSessionCredentials) {
            headers.put(HEADER_NAME_SECURITY_TOKEN, ((AWSSessionCredentials)awsCredentials).getSessionToken());
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dateTimeAsISO(Date date, boolean dateOnly) {
        if (dateOnly) {
            SimpleDateFormat simpleDateFormat = DATE_STAMP;
            synchronized (simpleDateFormat) {
                return DATE_STAMP.format(date);
            }
        }
        SimpleDateFormat simpleDateFormat = DATE_TIME_STAMP;
        synchronized (simpleDateFormat) {
            return DATE_TIME_STAMP.format(date);
        }
    }

    private static String SHA256(String data) {
        try {
            return Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-256").digest(data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute SHA-256", e);
        }
    }

    static byte[] HmacSHA256(String data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        String algorithm = HMAC_SHA256;
        Mac mac = Mac.getInstance(HMAC_SHA256);
        mac.init(new SecretKeySpec(key, HMAC_SHA256));
        return mac.doFinal(data.getBytes("UTF8"));
    }

    static byte[] getSignatureKey(String key, String dateStamp, String regionName, String serviceName) {
        try {
            byte[] kSecret = ("AWS4" + key).getBytes("UTF8");
            byte[] kDate = SigV4Gen.HmacSHA256(dateStamp, kSecret);
            byte[] kRegion = SigV4Gen.HmacSHA256(regionName, kDate);
            byte[] kService = SigV4Gen.HmacSHA256(serviceName, kRegion);
            byte[] kSigning = SigV4Gen.HmacSHA256("aws4_request", kService);
            return kSigning;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate SignatureKey", e);
        }
    }

    static {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_TIME_STAMP = formatter;
        formatter = new SimpleDateFormat("yyyyMMdd");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_STAMP = formatter;
        SIGNED_HEADERS = new String[]{HEADER_NAME_HOST, HEADER_NAME_DATE};
    }

    public static class SigAndStringToSign {
        public final String mSignature;
        public final String mStringToSign;
        public final String mSessionToken;

        public SigAndStringToSign(String sig, String stringToSign) {
            this(sig, stringToSign, null);
        }

        public SigAndStringToSign(String sig, String stringToSign, String sessionToken) {
            this.mSignature = sig;
            this.mStringToSign = stringToSign;
            this.mSessionToken = sessionToken;
        }
    }
}

