/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazonaws.AmazonClientException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SimpleCache<K, V> {
    private final Lock mLock;
    private final CacheMap<K, Object> mCache;

    public SimpleCache(int size) {
        this.mCache = new CacheMap(size);
        this.mLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        this.mLock.lock();
        boolean isThreadInterrupted = false;
        try {
            while (true) {
                Condition cond;
                Object obj;
                if ((obj = this.mCache.get(key)) != null && !(obj instanceof Condition)) {
                    Object v = obj;
                    return v;
                }
                if (obj != null) {
                    assert (obj instanceof Condition);
                    cond = (Condition)obj;
                    try {
                        cond.await(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        isThreadInterrupted = true;
                    }
                    continue;
                }
                cond = this.mLock.newCondition();
                this.mCache.put(key, cond);
                this.mLock.unlock();
                V newValue = null;
                try {
                    newValue = this.fetchWithRetries(key);
                }
                catch (Throwable t) {
                    this.mLock.lock();
                    if (this.mCache.get(key) == cond) {
                        this.mCache.remove(key);
                    }
                    cond.signalAll();
                    throw t;
                }
                this.mLock.lock();
                Object currentValue = this.mCache.get(key);
                if (currentValue != cond) continue;
                this.mCache.put(key, newValue);
                V v = newValue;
                return v;
                finally {
                    cond.signalAll();
                    continue;
                }
                break;
            }
        }
        finally {
            this.mLock.unlock();
            if (isThreadInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final V putLocked(K key, V value) {
        V v = this.mCache.put(key, value);
        if (v instanceof Condition) {
            ((Condition)v).signalAll();
            return null;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        this.mLock.lock();
        try {
            V v = this.putLocked(key, value);
            return v;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putAll(Map<K, V> values) {
        this.mLock.lock();
        try {
            for (Map.Entry<K, V> e : values.entrySet()) {
                this.putLocked(e.getKey(), e.getValue());
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K key) {
        this.mLock.lock();
        try {
            Object v = this.mCache.remove(key);
            if (v instanceof Condition) {
                ((Condition)v).signalAll();
                V v2 = null;
                return v2;
            }
            Object v3 = v;
            return v3;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private V fetchWithRetries(K key) {
        int numOfRetries = 2;
        AmazonClientException lastException = null;
        while (true) {
            try {
                return this.fetch(key);
            }
            catch (AmazonClientException e) {
                if (lastException == null) {
                    lastException = e;
                    continue;
                }
                if (lastException == e) continue;
                lastException.addSuppressed((Throwable)e);
                if (--numOfRetries >= 0) continue;
                throw lastException;
            }
            break;
        }
    }

    protected abstract V fetch(K var1);

    protected int size() {
        return this.mCache.size();
    }

    private static final class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public CacheMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxEntries = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

