/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.retry;

import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazon.dax.client.retry.RetryHandler;
import com.amazon.dax.client.retry.RetryUtils;
import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;

public class BaseRetryHandler
implements RetryHandler {
    protected AmazonClientException mLastException;
    private int requestCount;
    private final int mMaxRetries;
    private final BackoffStrategy mBackoffStrategy;

    public BaseRetryHandler(BackoffStrategy backoffStrategy, int maxRetries) {
        this.mBackoffStrategy = backoffStrategy;
        this.mMaxRetries = Math.max(0, maxRetries);
    }

    @Override
    public void beforeRequest() {
        ++this.requestCount;
    }

    @Override
    public void onException(AmazonClientException e) {
        if (this.mLastException != null) {
            if (this.mLastException.getCause() != null) {
                e.addSuppressed(this.mLastException.getCause());
            } else {
                e.addSuppressed((Throwable)this.mLastException);
            }
        }
        this.mLastException = e;
    }

    @Override
    public AmazonClientException lastException() {
        return this.mLastException;
    }

    @Override
    public boolean canRetry() {
        return this.requestCount - 1 < this.mMaxRetries && this.isRetryable(this.mLastException);
    }

    @Override
    public void pauseBeforeRetry() {
        RetryPolicyContext retryPolicyContext = RetryPolicyContext.builder().exception((SdkBaseException)RetryUtils.toAse((Exception)((Object)this.mLastException))).retriesAttempted(this.requestCount - 1).build();
        long delayMs = this.mBackoffStrategy.computeDelayBeforeNextRetry(retryPolicyContext);
        if (delayMs == 0L) {
            return;
        }
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AbortedException((Throwable)e);
        }
    }

    protected boolean isRetryable(AmazonClientException ace) {
        if (ace instanceof DaxServiceException || ace.getCause() instanceof DaxServiceException) {
            DaxServiceException dse = ace instanceof DaxServiceException ? (DaxServiceException)((Object)ace) : (DaxServiceException)((Object)ace.getCause());
            return DynamoNumerals.ErrorCodes.THROTTLING_ERROR.mErrorCode.equals(dse.getErrorCode()) || dse.getStatusCode() == 503 || dse.isRetryable();
        }
        if (ace instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)ace;
            return ace instanceof InternalServerErrorException || ace instanceof LimitExceededException || ace instanceof ProvisionedThroughputExceededException || DynamoNumerals.ErrorCodes.THROTTLING_ERROR.mErrorCode.equals(ase.getErrorCode()) || ase.getStatusCode() == 503;
        }
        return ace.isRetryable();
    }
}

