/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.retry;

import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazon.dax.client.exceptions.NoClusterEndpointsAvailableException;
import com.amazon.dax.client.retry.ClusterRetryHandler;
import com.amazon.dax.client.retry.RetryHandler;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClusterBaseRetryHandler
implements ClusterRetryHandler {
    private static final Log LOG = LogFactory.getLog(ClusterBaseRetryHandler.class);
    private final Cluster mCluster;
    private final long mRecoveryDuration;
    private final TimeUnit mRecoveryDurationUnit;
    private final RetryHandler mRetryHandler;
    private long mLeaderSessionId;

    public ClusterBaseRetryHandler(Cluster cluster, long recoveryDuration, TimeUnit recoveryDurationUnit, RetryHandler retryHandler) {
        this.mCluster = cluster;
        this.mRecoveryDuration = recoveryDuration;
        this.mRecoveryDurationUnit = recoveryDurationUnit;
        this.mRetryHandler = retryHandler;
    }

    @Override
    public void setLeaderSessionId(long sessionId) {
        this.mLeaderSessionId = sessionId;
    }

    @Override
    public AmazonClientException toAce(Exception lastException) {
        if (lastException instanceof AmazonClientException) {
            return (AmazonClientException)((Object)lastException);
        }
        if (lastException != null) {
            return new AmazonClientException("Unable to call cluster endpoint: " + lastException.getMessage(), (Throwable)lastException);
        }
        return new NoClusterEndpointsAvailableException();
    }

    @Override
    public void beforeRequest() {
        this.mRetryHandler.beforeRequest();
    }

    @Override
    public void onException(AmazonClientException ex) {
        this.mRetryHandler.onException(ex);
    }

    @Override
    public AmazonClientException lastException() {
        return this.mRetryHandler.lastException();
    }

    @Override
    public boolean canRetry() {
        return this.mRetryHandler.canRetry();
    }

    @Override
    public void pauseBeforeRetry() {
        this.logLastException();
        if (this.shouldWaitForClusterRecoveryBeforeRetrying()) {
            this.mCluster.waitForRecovery(this.mLeaderSessionId, this.mRecoveryDuration, this.mRecoveryDurationUnit);
        } else {
            this.mRetryHandler.pauseBeforeRetry();
        }
    }

    private void logLastException() {
        AmazonClientException lastException = this.lastException();
        if (!(lastException instanceof ProvisionedThroughputExceededException)) {
            LOG.info((Object)("Retrying request after exception: " + (lastException != null ? lastException.getMessage() : "no routes")));
        }
    }

    protected boolean shouldWaitForClusterRecoveryBeforeRetrying() {
        AmazonClientException lastException = this.lastException();
        if (lastException == null) {
            return true;
        }
        if (lastException instanceof DaxServiceException || lastException.getCause() instanceof DaxServiceException) {
            DaxServiceException dse = lastException instanceof DaxServiceException ? (DaxServiceException)((Object)lastException) : (DaxServiceException)((Object)lastException.getCause());
            return dse.waitForClusterRecoveryBeforeRetry();
        }
        return lastException instanceof NoClusterEndpointsAvailableException;
    }
}

