/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.retry;

import com.amazon.dax.bits.dynamodb.DynamoNumerals;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;

public class RetryUtils {
    public static AmazonServiceException toAse(Exception e) {
        if (e instanceof DaxServiceException) {
            return (DaxServiceException)((Object)e);
        }
        if (e instanceof AmazonClientException && e.getCause() instanceof DaxServiceException) {
            return (DaxServiceException)((Object)e.getCause());
        }
        if (e instanceof LimitExceededException) {
            return new DaxServiceException(e.getMessage(), DynamoNumerals.ErrorCodes.LIMIT_EXCEEDED_ERROR.mErrorCode);
        }
        if (e instanceof ProvisionedThroughputExceededException) {
            return new DaxServiceException(e.getMessage(), DynamoNumerals.ErrorCodes.PROVISIONED_THROUGHPUT_ERROR.mErrorCode);
        }
        if (e instanceof AmazonServiceException) {
            return (AmazonServiceException)e;
        }
        return null;
    }
}

