/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.retry;

import com.amazon.dax.client.retry.BaseRetryHandler;
import com.amazon.dax.client.utils.Utils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.services.dynamodbv2.model.TransactionInProgressException;

public class WriteRetryHandler
extends BaseRetryHandler {
    public WriteRetryHandler(BackoffStrategy backoffStrategy, int maxRetries) {
        super(backoffStrategy, maxRetries);
    }

    @Override
    protected boolean isRetryable(AmazonClientException ace) {
        if (Utils.isWriteFailureAmbiguous(ace)) {
            return false;
        }
        if (ace instanceof TransactionInProgressException) {
            return true;
        }
        return super.isRetryable(ace);
    }
}

