/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesis.agg;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.kinesis.agg.AggRecord;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

@NotThreadSafe
public class RecordAggregator {
    private AggRecord currentRecord = new AggRecord();
    private List<ListenerExecutorPair> listeners = new LinkedList<ListenerExecutorPair>();

    public int getNumUserRecords() {
        return this.currentRecord.getNumUserRecords();
    }

    public long getSizeBytes() {
        return this.currentRecord.getSizeBytes();
    }

    public void clearRecord() {
        this.currentRecord = new AggRecord();
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void onRecordComplete(RecordCompleteListener listener) {
        this.onRecordComplete(listener, ForkJoinPool.commonPool());
    }

    public void onRecordComplete(RecordCompleteListener listener, Executor executor) {
        this.listeners.add(new ListenerExecutorPair(listener, executor));
    }

    public AggRecord clearAndGet() {
        if (this.getNumUserRecords() == 0) {
            return null;
        }
        AggRecord out = this.currentRecord;
        this.clearRecord();
        return out;
    }

    public AggRecord addUserRecord(UserRecord userRecord) throws Exception {
        if (userRecord == null) {
            throw new IllegalArgumentException("Input user record cannot be null.");
        }
        if (!userRecord.getData().hasArray()) {
            throw new IllegalStateException("The addUserRecord method only works for UserRecord objects whose data ByteBuffer  has a backing byte[] available.");
        }
        return this.addUserRecord(userRecord.getPartitionKey(), userRecord.getExplicitHashKey(), userRecord.getData().array());
    }

    public AggRecord addUserRecord(String partitionKey, byte[] data) throws Exception {
        return this.addUserRecord(partitionKey, null, data);
    }

    public AggRecord addUserRecord(String partitionKey, String explicitHashKey, byte[] data) throws Exception {
        boolean success = this.currentRecord.addUserRecord(partitionKey, explicitHashKey, data);
        if (success) {
            return null;
        }
        AggRecord completeRecord = this.currentRecord;
        for (ListenerExecutorPair pair : this.listeners) {
            pair.getExecutor().execute(() -> pair.getListener().recordComplete(completeRecord));
        }
        this.clearRecord();
        success = this.currentRecord.addUserRecord(partitionKey, explicitHashKey, data);
        if (!success) {
            throw new Exception(String.format("Unable to add User Record %s, %s with data length %s", partitionKey, explicitHashKey, data.length));
        }
        return completeRecord;
    }

    private class ListenerExecutorPair {
        private RecordCompleteListener listener;
        private Executor executor;

        public ListenerExecutorPair(RecordCompleteListener listener, Executor executor) {
            this.listener = listener;
            this.executor = executor;
        }

        public RecordCompleteListener getListener() {
            return this.listener;
        }

        public Executor getExecutor() {
            return this.executor;
        }
    }

    public static interface RecordCompleteListener {
        public void recordComplete(AggRecord var1);
    }
}

