/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncStrategyType;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTaskManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardEndShardSyncStrategy
implements ShardSyncStrategy {
    private static final Log LOG = LogFactory.getLog(Worker.class);
    private ShardSyncTaskManager shardSyncTaskManager;

    ShardEndShardSyncStrategy(ShardSyncTaskManager shardSyncTaskManager) {
        this.shardSyncTaskManager = shardSyncTaskManager;
    }

    @Override
    public ShardSyncStrategyType getStrategyType() {
        return ShardSyncStrategyType.SHARD_END;
    }

    @Override
    public TaskResult syncShards() {
        Future<TaskResult> taskResultFuture = null;
        TaskResult result = null;
        while (taskResultFuture == null) {
            taskResultFuture = this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        }
        try {
            result = (TaskResult)taskResultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Object)"ShardEndShardSyncStrategy syncShards encountered exception.", (Throwable)e);
        }
        return result;
    }

    @Override
    public TaskResult onWorkerInitialization() {
        LOG.debug((Object)String.format("onWorkerInitialization is NoOp for ShardSyncStrategyType %s", this.getStrategyType().toString()));
        return new TaskResult(null);
    }

    @Override
    public TaskResult onFoundCompletedShard() {
        this.shardSyncTaskManager.syncShardAndLeaseInfo(null);
        return new TaskResult(null);
    }

    @Override
    public TaskResult onShardConsumerShutDown() {
        return this.onFoundCompletedShard();
    }

    @Override
    public void onWorkerShutDown() {
        LOG.debug((Object)String.format("Stop is NoOp for ShardSyncStrategyType %s", this.getStrategyType().toString()));
    }
}

