/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import java.util.concurrent.CountDownLatch;

class GracefulShutdownContext {
    private final CountDownLatch shutdownCompleteLatch;
    private final CountDownLatch notificationCompleteLatch;
    private final Worker worker;
    static GracefulShutdownContext SHUTDOWN_ALREADY_COMPLETED = new GracefulShutdownContext(null, null, null);

    boolean isShutdownAlreadyCompleted() {
        return this.shutdownCompleteLatch == null && this.notificationCompleteLatch == null && this.worker == null;
    }

    public GracefulShutdownContext(CountDownLatch shutdownCompleteLatch, CountDownLatch notificationCompleteLatch, Worker worker) {
        this.shutdownCompleteLatch = shutdownCompleteLatch;
        this.notificationCompleteLatch = notificationCompleteLatch;
        this.worker = worker;
    }

    public CountDownLatch getShutdownCompleteLatch() {
        return this.shutdownCompleteLatch;
    }

    public CountDownLatch getNotificationCompleteLatch() {
        return this.notificationCompleteLatch;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GracefulShutdownContext)) {
            return false;
        }
        GracefulShutdownContext other = (GracefulShutdownContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CountDownLatch this$shutdownCompleteLatch = this.getShutdownCompleteLatch();
        CountDownLatch other$shutdownCompleteLatch = other.getShutdownCompleteLatch();
        if (this$shutdownCompleteLatch == null ? other$shutdownCompleteLatch != null : !this$shutdownCompleteLatch.equals(other$shutdownCompleteLatch)) {
            return false;
        }
        CountDownLatch this$notificationCompleteLatch = this.getNotificationCompleteLatch();
        CountDownLatch other$notificationCompleteLatch = other.getNotificationCompleteLatch();
        if (this$notificationCompleteLatch == null ? other$notificationCompleteLatch != null : !this$notificationCompleteLatch.equals(other$notificationCompleteLatch)) {
            return false;
        }
        Worker this$worker = this.getWorker();
        Worker other$worker = other.getWorker();
        return !(this$worker == null ? other$worker != null : !this$worker.equals(other$worker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GracefulShutdownContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CountDownLatch $shutdownCompleteLatch = this.getShutdownCompleteLatch();
        result = result * 59 + ($shutdownCompleteLatch == null ? 43 : $shutdownCompleteLatch.hashCode());
        CountDownLatch $notificationCompleteLatch = this.getNotificationCompleteLatch();
        result = result * 59 + ($notificationCompleteLatch == null ? 43 : $notificationCompleteLatch.hashCode());
        Worker $worker = this.getWorker();
        result = result * 59 + ($worker == null ? 43 : $worker.hashCode());
        return result;
    }

    public String toString() {
        return "GracefulShutdownContext(shutdownCompleteLatch=" + this.getShutdownCompleteLatch() + ", notificationCompleteLatch=" + this.getNotificationCompleteLatch() + ", worker=" + this.getWorker() + ")";
    }
}

