/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.config.KinesisClientLibConfigurator;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangDaemon
implements Callable<Integer> {
    private static final Log LOG = LogFactory.getLog(MultiLangDaemon.class);
    private static final String USER_AGENT = "amazon-kinesis-multi-lang-daemon";
    private static final String VERSION = "1.0.0";
    private static final String PROP_EXECUTABLE_NAME = "executableName";
    private static final String PROP_PROCESSING_LANGUAGE = "processingLanguage";
    private static final String PROP_MAX_ACTIVE_THREADS = "maxActiveThreads";
    private KinesisClientLibConfiguration configuration;
    private MultiLangRecordProcessorFactory recordProcessorFactory;
    private ExecutorService workerThreadPool;
    private String processingLanguage;

    MultiLangDaemon(String processingLanguage, KinesisClientLibConfiguration configuration, MultiLangRecordProcessorFactory recordProcessorFactory, ExecutorService workerThreadPool) {
        this.processingLanguage = processingLanguage;
        this.configuration = configuration;
        this.recordProcessorFactory = recordProcessorFactory;
        this.workerThreadPool = workerThreadPool;
    }

    static void printUsage(PrintStream stream, String message) {
        StringBuilder builder = new StringBuilder();
        if (message != null) {
            builder.append(message);
        }
        builder.append(String.format("java %s <properties file>", MultiLangDaemon.class.getCanonicalName()));
        stream.println(builder.toString());
    }

    static Properties loadProperties(ClassLoader classLoader, String propertiesFileName) throws IOException {
        Properties properties = new Properties();
        try (InputStream propertiesStream = classLoader.getResourceAsStream(propertiesFileName);){
            properties.load(propertiesStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    static boolean validateProperties(Properties properties) {
        return properties != null && properties.getProperty(PROP_EXECUTABLE_NAME) != null;
    }

    void prepare() {
        Security.setProperty("networkaddress.cache.ttl", "60");
        LOG.info((Object)("Using workerId: " + this.configuration.getWorkerIdentifier()));
        LOG.info((Object)("Using credentials with access key id: " + this.configuration.getKinesisCredentialsProvider().getCredentials().getAWSAccessKeyId()));
        StringBuilder userAgent = new StringBuilder("amazon-kinesis-client-library-java-1.2.0");
        userAgent.append(" ");
        userAgent.append(USER_AGENT);
        userAgent.append("/");
        userAgent.append(VERSION);
        if (this.processingLanguage != null) {
            userAgent.append(" ");
            userAgent.append(this.processingLanguage);
        }
        if (this.recordProcessorFactory.getCommandArray().length > 0) {
            userAgent.append(" ");
            userAgent.append(this.recordProcessorFactory.getCommandArray()[0]);
        }
        LOG.debug((Object)String.format("User Agent string is: %s", userAgent.toString()));
        this.configuration.withUserAgent(userAgent.toString());
    }

    @Override
    public Integer call() throws Exception {
        this.prepare();
        Worker worker = new Worker((IRecordProcessorFactory)this.recordProcessorFactory, this.configuration, this.workerThreadPool);
        int exitCode = 0;
        try {
            worker.run();
        }
        catch (Throwable t) {
            LOG.error((Object)"Caught throwable while processing data.", t);
            exitCode = 1;
        }
        return exitCode;
    }

    private static int getMaxActiveThreads(Properties properties) {
        return Integer.parseInt(properties.getProperty(PROP_MAX_ACTIVE_THREADS, "0"));
    }

    private static ExecutorService getExecutorService(Properties properties) {
        int maxActiveThreads = MultiLangDaemon.getMaxActiveThreads(properties);
        LOG.debug((Object)String.format("Value for %s property is %d", PROP_MAX_ACTIVE_THREADS, maxActiveThreads));
        if (maxActiveThreads <= 0) {
            LOG.info((Object)"Using a cached thread pool.");
            return Executors.newCachedThreadPool();
        }
        LOG.info((Object)String.format("Using a fixed thread pool with %d max active threads.", maxActiveThreads));
        return Executors.newFixedThreadPool(maxActiveThreads);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        Properties properties = null;
        try {
            properties = MultiLangDaemon.loadProperties(Thread.currentThread().getContextClassLoader(), args[0]);
        }
        catch (IOException e) {
            MultiLangDaemon.printUsage(System.err, "You must provide a properties file");
            System.exit(1);
        }
        if (MultiLangDaemon.validateProperties(properties)) {
            KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfigurator().getConfiguration(properties);
            String executableName = properties.getProperty(PROP_EXECUTABLE_NAME);
            ExecutorService executorService = MultiLangDaemon.getExecutorService(properties);
            MultiLangRecordProcessorFactory recordProcessorFactory = new MultiLangRecordProcessorFactory(executableName, executorService);
            MultiLangDaemon daemon = new MultiLangDaemon(properties.getProperty(PROP_PROCESSING_LANGUAGE), kinesisClientLibConfiguration, recordProcessorFactory, executorService);
            LOG.info((Object)("Running " + kinesisClientLibConfiguration.getApplicationName() + " to process stream " + kinesisClientLibConfiguration.getStreamName() + " with executable " + executableName));
            Future<Integer> future = executorService.submit(daemon);
            try {
                System.exit(future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)"Encountered an error while running daemon", (Throwable)e);
            }
        } else {
            MultiLangDaemon.printUsage(System.err, "Must provide an executable name in the properties file, e.g. executableName = sampleapp.py");
        }
        System.exit(1);
    }
}

