/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamStatus;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KinesisProxy
implements IKinesisProxy {
    private static final Log LOG = LogFactory.getLog(KinesisProxy.class);
    private static String defaultServiceName = "kinesis";
    private static String defaultRegionId = "us-east-1";
    private AmazonKinesis client;
    private AWSCredentialsProvider credentialsProvider;
    private final String streamName;
    private static final long DEFAULT_DESCRIBE_STREAM_BACKOFF_MILLIS = 1000L;
    private static final int DEFAULT_DESCRIBE_STREAM_RETRY_TIMES = 50;
    private final long describeStreamBackoffTimeInMillis;
    private final int maxDescribeStreamRetryAttempts;

    public KinesisProxy(String streamName, AWSCredentialsProvider credentialProvider, String endpoint) {
        this(streamName, credentialProvider, endpoint, defaultServiceName, defaultRegionId, 1000L, 50);
    }

    public KinesisProxy(String streamName, AWSCredentialsProvider credentialProvider, String endpoint, String serviceName, String regionId, long describeStreamBackoffTimeInMillis, int maxDescribeStreamRetryAttempts) {
        this(streamName, credentialProvider, (AmazonKinesis)KinesisProxy.buildClientSettingEndpoint(credentialProvider, endpoint, serviceName, regionId), describeStreamBackoffTimeInMillis, maxDescribeStreamRetryAttempts);
        LOG.debug((Object)"KinesisProxy has created a kinesisClient");
    }

    private static AmazonKinesisClient buildClientSettingEndpoint(AWSCredentialsProvider credentialProvider, String endpoint, String serviceName, String regionId) {
        AmazonKinesisClient client = new AmazonKinesisClient(credentialProvider);
        client.setEndpoint(endpoint, serviceName, regionId);
        return client;
    }

    public KinesisProxy(String streamName, AWSCredentialsProvider credentialProvider, AmazonKinesis kinesisClient, long describeStreamBackoffTimeInMillis, int maxDescribeStreamRetryAttempts) {
        this.streamName = streamName;
        this.credentialsProvider = credentialProvider;
        this.describeStreamBackoffTimeInMillis = describeStreamBackoffTimeInMillis;
        this.maxDescribeStreamRetryAttempts = maxDescribeStreamRetryAttempts;
        this.client = kinesisClient;
        LOG.debug((Object)("KinesisProxy( " + streamName + ")"));
    }

    @Override
    public GetRecordsResult get(String shardIterator, int maxRecords) throws ResourceNotFoundException, InvalidArgumentException, ExpiredIteratorException {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setRequestCredentials(this.credentialsProvider.getCredentials());
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(Integer.valueOf(maxRecords));
        GetRecordsResult response = this.client.getRecords(getRecordsRequest);
        return response;
    }

    @Override
    public DescribeStreamResult getStreamInfo(String startShardId) throws ResourceNotFoundException, LimitExceededException {
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
        describeStreamRequest.setRequestCredentials(this.credentialsProvider.getCredentials());
        describeStreamRequest.setStreamName(this.streamName);
        describeStreamRequest.setExclusiveStartShardId(startShardId);
        DescribeStreamResult response = null;
        for (int remainingRetryTimes = this.maxDescribeStreamRetryAttempts; remainingRetryTimes >= 0 && response == null; --remainingRetryTimes) {
            try {
                response = this.client.describeStream(describeStreamRequest);
                continue;
            }
            catch (LimitExceededException le) {
                LOG.info((Object)("Got LimitExceededException when describing stream " + this.streamName + ". Backing off for " + this.describeStreamBackoffTimeInMillis + " millis."));
                try {
                    Thread.sleep(this.describeStreamBackoffTimeInMillis);
                    continue;
                }
                catch (InterruptedException ie) {
                    LOG.debug((Object)("Stream " + this.streamName + " : Sleep  was interrupted "), (Throwable)ie);
                }
            }
        }
        if (StreamStatus.ACTIVE.toString().equals(response.getStreamDescription().getStreamStatus()) || StreamStatus.UPDATING.toString().equals(response.getStreamDescription().getStreamStatus())) {
            return response;
        }
        LOG.info((Object)("Stream is in status " + response.getStreamDescription().getStreamStatus() + ", KinesisProxy.DescribeStream returning null (wait until stream is Active or Updating"));
        return null;
    }

    @Override
    public List<Shard> getShardList() {
        ArrayList<Shard> result = new ArrayList<Shard>();
        DescribeStreamResult response = null;
        String lastShardId = null;
        do {
            if ((response = this.getStreamInfo(lastShardId)) == null) {
                return null;
            }
            List shards = response.getStreamDescription().getShards();
            result.addAll(shards);
            lastShardId = ((Shard)shards.get(shards.size() - 1)).getShardId();
        } while (response.getStreamDescription().isHasMoreShards().booleanValue());
        return result;
    }

    @Override
    public Set<String> getAllShardIds() throws ResourceNotFoundException {
        List<Shard> shards = this.getShardList();
        if (shards == null) {
            return null;
        }
        HashSet<String> shardIds = new HashSet<String>();
        for (Shard shard : this.getShardList()) {
            shardIds.add(shard.getShardId());
        }
        return shardIds;
    }

    @Override
    public String getIterator(String shardId, String iteratorType, String sequenceNumber) {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
        getShardIteratorRequest.setRequestCredentials(this.credentialsProvider.getCredentials());
        getShardIteratorRequest.setStreamName(this.streamName);
        getShardIteratorRequest.setShardId(shardId);
        getShardIteratorRequest.setShardIteratorType(iteratorType);
        getShardIteratorRequest.setStartingSequenceNumber(sequenceNumber);
        GetShardIteratorResult response = this.client.getShardIterator(getShardIteratorRequest);
        return response.getShardIterator();
    }

    @Override
    public PutRecordResult put(String exclusiveMinimumSequenceNumber, String explicitHashKey, String partitionKey, ByteBuffer data) throws ResourceNotFoundException, InvalidArgumentException {
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setRequestCredentials(this.credentialsProvider.getCredentials());
        putRecordRequest.setStreamName(this.streamName);
        putRecordRequest.setSequenceNumberForOrdering(exclusiveMinimumSequenceNumber);
        putRecordRequest.setExplicitHashKey(explicitHashKey);
        putRecordRequest.setPartitionKey(partitionKey);
        putRecordRequest.setData(data);
        PutRecordResult response = this.client.putRecord(putRecordRequest);
        return response;
    }
}

