/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.metrics.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.kinesis.metrics.impl.CWMetricKey;
import com.amazonaws.services.kinesis.metrics.impl.CWMetricsScope;
import com.amazonaws.services.kinesis.metrics.impl.CWPublisherRunnable;
import com.amazonaws.services.kinesis.metrics.impl.DefaultCWMetricsPublisher;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;

public class CWMetricsFactory
implements IMetricsFactory {
    private static final int FLUSH_SIZE = 200;
    private final CWPublisherRunnable<CWMetricKey> runnable;
    private final Thread publicationThread;

    public CWMetricsFactory(AWSCredentialsProvider credentialsProvider, String namespace, long bufferTimeMillis, int maxQueueSize) {
        this((AmazonCloudWatch)new AmazonCloudWatchClient(credentialsProvider), namespace, bufferTimeMillis, maxQueueSize);
    }

    public CWMetricsFactory(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfig, String namespace, long bufferTimeMillis, int maxQueueSize) {
        this((AmazonCloudWatch)new AmazonCloudWatchClient(credentialsProvider, clientConfig), namespace, bufferTimeMillis, maxQueueSize);
    }

    public CWMetricsFactory(AmazonCloudWatch cloudWatchClient, String namespace, long bufferTimeMillis, int maxQueueSize) {
        DefaultCWMetricsPublisher metricPublisher = new DefaultCWMetricsPublisher(cloudWatchClient, namespace);
        this.runnable = new CWPublisherRunnable<CWMetricKey>(metricPublisher, bufferTimeMillis, maxQueueSize, 200);
        this.publicationThread = new Thread(this.runnable);
        this.publicationThread.setName("cw-metrics-publisher");
        this.publicationThread.start();
    }

    @Override
    public IMetricsScope createMetrics() {
        return new CWMetricsScope(this.runnable);
    }

    public void shutdown() {
        this.runnable.shutdown();
    }
}

