/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;

class StreamConfig {
    private final IKinesisProxy streamProxy;
    private final int maxRecords;
    private final long idleTimeInMilliseconds;
    private final boolean callProcessRecordsEvenForEmptyRecordList;
    private InitialPositionInStream initialPositionInStream;
    private final boolean validateSequenceNumberBeforeCheckpointing;

    StreamConfig(IKinesisProxy proxy, int maxRecords, long idleTimeInMilliseconds, boolean callProcessRecordsEvenForEmptyRecordList, boolean validateSequenceNumberBeforeCheckpointing) {
        this(proxy, maxRecords, idleTimeInMilliseconds, callProcessRecordsEvenForEmptyRecordList, validateSequenceNumberBeforeCheckpointing, InitialPositionInStream.LATEST);
    }

    StreamConfig(IKinesisProxy proxy, int maxRecords, long idleTimeInMilliseconds, boolean callProcessRecordsEvenForEmptyRecordList, boolean validateSequenceNumberBeforeCheckpointing, InitialPositionInStream initialPositionInStream) {
        this.streamProxy = proxy;
        this.maxRecords = maxRecords;
        this.idleTimeInMilliseconds = idleTimeInMilliseconds;
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        this.initialPositionInStream = initialPositionInStream;
    }

    IKinesisProxy getStreamProxy() {
        return this.streamProxy;
    }

    int getMaxRecords() {
        return this.maxRecords;
    }

    long getIdleTimeInMilliseconds() {
        return this.idleTimeInMilliseconds;
    }

    boolean shouldCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    boolean shouldValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }
}

