/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisDataFetcher;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.StreamConfig;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxyExtended;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.Shard;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProcessTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(ProcessTask.class);
    private static final String EXPIRED_ITERATOR_METRIC = "ExpiredIterator";
    private static final String DATA_BYTES_PROCESSED_METRIC = "DataBytesProcessed";
    private static final String RECORDS_PROCESSED_METRIC = "RecordsProcessed";
    private static final String MILLIS_BEHIND_LATEST_METRIC = "MillisBehindLatest";
    private static final String RECORD_PROCESSOR_PROCESS_RECORDS_METRIC = "RecordProcessor.processRecords";
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final KinesisDataFetcher dataFetcher;
    private final TaskType taskType = TaskType.PROCESS;
    private final StreamConfig streamConfig;
    private final long backoffTimeMillis;
    private final Shard shard;

    public ProcessTask(ShardInfo shardInfo, StreamConfig streamConfig, IRecordProcessor recordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, KinesisDataFetcher dataFetcher, long backoffTimeMillis) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.dataFetcher = dataFetcher;
        this.streamConfig = streamConfig;
        this.backoffTimeMillis = backoffTimeMillis;
        IKinesisProxy kinesisProxy = this.streamConfig.getStreamProxy();
        if (kinesisProxy instanceof IKinesisProxyExtended) {
            this.shard = ((IKinesisProxyExtended)kinesisProxy).getShard(this.shardInfo.getShardId());
        } else {
            LOG.warn((Object)"Cannot get the shard for this ProcessTask, so duplicate KPL user records in the event of resharding will not be dropped during deaggregation of Amazon Kinesis records.");
            this.shard = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        RuntimeException exception;
        block16: {
            long startTimeMillis = System.currentTimeMillis();
            IMetricsScope scope = MetricsHelper.getMetricsScope();
            scope.addDimension("ShardId", this.shardInfo.getShardId());
            scope.addData(RECORDS_PROCESSED_METRIC, 0.0, StandardUnit.Count, MetricsLevel.SUMMARY);
            scope.addData(DATA_BYTES_PROCESSED_METRIC, 0.0, StandardUnit.Bytes, MetricsLevel.SUMMARY);
            exception = null;
            try {
                if (this.dataFetcher.isShardEndReached()) {
                    LOG.info((Object)("Reached end of shard " + this.shardInfo.getShardId()));
                    boolean shardEndReached = true;
                    return new TaskResult(null, shardEndReached);
                }
                GetRecordsResult getRecordsResult = this.getRecordsResult();
                List<Record> records = getRecordsResult.getRecords();
                if (!records.isEmpty()) {
                    scope.addData(RECORDS_PROCESSED_METRIC, records.size(), StandardUnit.Count, MetricsLevel.SUMMARY);
                } else {
                    LOG.debug((Object)("Kinesis didn't return any records for shard " + this.shardInfo.getShardId()));
                    long sleepTimeMillis = this.streamConfig.getIdleTimeInMilliseconds() - (System.currentTimeMillis() - startTimeMillis);
                    if (sleepTimeMillis > 0L) {
                        sleepTimeMillis = Math.max(sleepTimeMillis, this.streamConfig.getIdleTimeInMilliseconds());
                        try {
                            LOG.debug((Object)("Sleeping for " + sleepTimeMillis + " ms since there were no new records in shard " + this.shardInfo.getShardId()));
                            Thread.sleep(sleepTimeMillis);
                        }
                        catch (InterruptedException e) {
                            LOG.debug((Object)("ShardId " + this.shardInfo.getShardId() + ": Sleep was interrupted"));
                        }
                    }
                }
                if (!records.isEmpty() && ((Record)records.get(0)).getClass().equals(Record.class)) {
                    records = this.shard != null ? UserRecord.deaggregate(records, new BigInteger(this.shard.getHashKeyRange().getStartingHashKey()), new BigInteger(this.shard.getHashKeyRange().getEndingHashKey())) : UserRecord.deaggregate(records);
                }
                this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue(this.filterAndGetMaxExtendedSequenceNumber(scope, records, this.recordProcessorCheckpointer.getLastCheckpointValue()));
                if (records.isEmpty() && !this.streamConfig.shouldCallProcessRecordsEvenForEmptyRecordList()) break block16;
                LOG.debug((Object)("Calling application processRecords() with " + records.size() + " records from " + this.shardInfo.getShardId()));
                ProcessRecordsInput processRecordsInput = new ProcessRecordsInput().withRecords(records).withCheckpointer(this.recordProcessorCheckpointer).withMillisBehindLatest(getRecordsResult.getMillisBehindLatest());
                long recordProcessorStartTimeMillis = System.currentTimeMillis();
                try {
                    this.recordProcessor.processRecords(processRecordsInput);
                }
                catch (Exception e) {
                    LOG.error((Object)("ShardId " + this.shardInfo.getShardId() + ": Application processRecords() threw an exception when processing shard "), (Throwable)e);
                    LOG.error((Object)("ShardId " + this.shardInfo.getShardId() + ": Skipping over the following data records: " + records));
                }
                finally {
                    MetricsHelper.addLatencyPerShard(this.shardInfo.getShardId(), RECORD_PROCESSOR_PROCESS_RECORDS_METRIC, recordProcessorStartTimeMillis, MetricsLevel.SUMMARY);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)("ShardId " + this.shardInfo.getShardId() + ": Caught exception: "), (Throwable)e);
                exception = e;
                try {
                    Thread.sleep(this.backoffTimeMillis);
                }
                catch (InterruptedException ie) {
                    LOG.debug((Object)(this.shardInfo.getShardId() + ": Sleep was interrupted"), (Throwable)ie);
                }
            }
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    private ExtendedSequenceNumber filterAndGetMaxExtendedSequenceNumber(IMetricsScope scope, List<Record> records, ExtendedSequenceNumber lastCheckpointValue) {
        ExtendedSequenceNumber largestExtendedSequenceNumber = lastCheckpointValue;
        ListIterator<Record> recordIterator = records.listIterator();
        while (recordIterator.hasNext()) {
            Record record = recordIterator.next();
            ExtendedSequenceNumber extendedSequenceNumber = new ExtendedSequenceNumber(record.getSequenceNumber(), record instanceof UserRecord ? Long.valueOf(((UserRecord)record).getSubSequenceNumber()) : null);
            if (extendedSequenceNumber.compareTo(lastCheckpointValue) <= 0) {
                recordIterator.remove();
                LOG.debug((Object)("removing record with ESN " + extendedSequenceNumber + " because the ESN is <= checkpoint (" + lastCheckpointValue + ")"));
                continue;
            }
            if (largestExtendedSequenceNumber == null || largestExtendedSequenceNumber.compareTo(extendedSequenceNumber) < 0) {
                largestExtendedSequenceNumber = extendedSequenceNumber;
            }
            scope.addData(DATA_BYTES_PROCESSED_METRIC, record.getData().limit(), StandardUnit.Bytes, MetricsLevel.SUMMARY);
        }
        return largestExtendedSequenceNumber;
    }

    private GetRecordsResult getRecordsResult() {
        try {
            return this.getRecordsResultAndRecordMillisBehindLatest();
        }
        catch (ExpiredIteratorException e) {
            LOG.info((Object)("ShardId " + this.shardInfo.getShardId() + ": getRecords threw ExpiredIteratorException - restarting after greatest seqNum " + "passed to customer"), (Throwable)e);
            MetricsHelper.getMetricsScope().addData(EXPIRED_ITERATOR_METRIC, 1.0, StandardUnit.Count, MetricsLevel.SUMMARY);
            this.dataFetcher.advanceIteratorTo(this.recordProcessorCheckpointer.getLargestPermittedCheckpointValue().getSequenceNumber());
            try {
                return this.getRecordsResultAndRecordMillisBehindLatest();
            }
            catch (ExpiredIteratorException ex) {
                String msg = "Shard " + this.shardInfo.getShardId() + ": getRecords threw ExpiredIteratorException with a fresh iterator.";
                LOG.error((Object)msg, (Throwable)ex);
                throw ex;
            }
        }
    }

    private GetRecordsResult getRecordsResultAndRecordMillisBehindLatest() {
        GetRecordsResult getRecordsResult = this.dataFetcher.getRecords(this.streamConfig.getMaxRecords());
        if (getRecordsResult == null) {
            return new GetRecordsResult().withRecords(Collections.emptyList());
        }
        if (getRecordsResult.getMillisBehindLatest() != null) {
            MetricsHelper.getMetricsScope().addData(MILLIS_BEHIND_LATEST_METRIC, getRecordsResult.getMillisBehindLatest().longValue(), StandardUnit.Milliseconds, MetricsLevel.SUMMARY);
        }
        return getRecordsResult;
    }
}

