/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.kinesis.clientlibrary.utils.NamedThreadFactory;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.LeasingException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.leases.impl.LeaseRenewer;
import com.amazonaws.services.kinesis.leases.impl.LeaseTaker;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseRenewer;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseTaker;
import com.amazonaws.services.kinesis.metrics.impl.LogMetricsFactory;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeaseCoordinator<T extends Lease> {
    public static final String WORKER_IDENTIFIER_METRIC = "WorkerIdentifier";
    private static final Log LOG = LogFactory.getLog(LeaseCoordinator.class);
    private static final long STOP_WAIT_TIME_MILLIS = 2000L;
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("LeaseCoordinator-");
    private final ILeaseRenewer<T> leaseRenewer;
    private final ILeaseTaker<T> leaseTaker;
    private final long renewerIntervalMillis;
    private final long takerIntervalMillis;
    protected final IMetricsFactory metricsFactory;
    private ScheduledExecutorService threadpool;
    private volatile boolean running = false;

    public LeaseCoordinator(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis) {
        this(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis, new LogMetricsFactory());
    }

    public LeaseCoordinator(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, IMetricsFactory metricsFactory) {
        this.leaseTaker = new LeaseTaker<T>(leaseManager, workerIdentifier, leaseDurationMillis);
        this.leaseRenewer = new LeaseRenewer<T>(leaseManager, workerIdentifier, leaseDurationMillis);
        this.renewerIntervalMillis = leaseDurationMillis / 3L - epsilonMillis;
        this.takerIntervalMillis = (leaseDurationMillis + epsilonMillis) * 2L;
        this.metricsFactory = metricsFactory;
        LOG.info((Object)String.format("With failover time %dms and epsilon %dms, LeaseCoordinator will renew leases every %dms and take leases every %dms", leaseDurationMillis, epsilonMillis, this.renewerIntervalMillis, this.takerIntervalMillis));
    }

    public void start() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.leaseRenewer.initialize();
        this.threadpool = Executors.newScheduledThreadPool(2, THREAD_FACTORY);
        this.threadpool.scheduleWithFixedDelay(new TakerRunnable(), 0L, this.takerIntervalMillis, TimeUnit.MILLISECONDS);
        this.threadpool.scheduleAtFixedRate(new RenewerRunnable(), 0L, this.renewerIntervalMillis, TimeUnit.MILLISECONDS);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTaker() throws DependencyException, InvalidStateException {
        IMetricsScope scope = MetricsHelper.startScope(this.metricsFactory, "TakeLeases");
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            Map<String, T> takenLeases = this.leaseTaker.takeLeases();
            this.leaseRenewer.addLeasesToRenew(takenLeases.values());
            success = true;
        }
        finally {
            scope.addDimension(WORKER_IDENTIFIER_METRIC, this.getWorkerIdentifier());
            MetricsHelper.addSuccessAndLatency(startTime, success, MetricsLevel.SUMMARY);
            MetricsHelper.endScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRenewer() throws DependencyException, InvalidStateException {
        IMetricsScope scope = MetricsHelper.startScope(this.metricsFactory, "RenewAllLeases");
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            this.leaseRenewer.renewLeases();
            success = true;
        }
        finally {
            scope.addDimension(WORKER_IDENTIFIER_METRIC, this.getWorkerIdentifier());
            MetricsHelper.addSuccessAndLatency(startTime, success, MetricsLevel.SUMMARY);
            MetricsHelper.endScope();
        }
    }

    public Collection<T> getAssignments() {
        return this.leaseRenewer.getCurrentlyHeldLeases().values();
    }

    public T getCurrentlyHeldLease(String leaseKey) {
        return this.leaseRenewer.getCurrentlyHeldLease(leaseKey);
    }

    public String getWorkerIdentifier() {
        return this.leaseTaker.getWorkerIdentifier();
    }

    public void stop() {
        block5: {
            if (this.threadpool != null) {
                this.threadpool.shutdown();
                try {
                    if (this.threadpool.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        LOG.info((Object)String.format("Worker %s has successfully stopped lease-tracking threads", this.leaseTaker.getWorkerIdentifier()));
                        break block5;
                    }
                    this.threadpool.shutdownNow();
                    LOG.info((Object)String.format("Worker %s stopped lease-tracking threads %dms after stop", this.leaseTaker.getWorkerIdentifier(), 2000L));
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Encountered InterruptedException when awaiting threadpool termination");
                }
            } else {
                LOG.debug((Object)"Threadpool was null, no need to shutdown/terminate threadpool.");
            }
        }
        this.leaseRenewer.clearCurrentlyHeldLeases();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean updateLease(T lease, UUID concurrencyToken) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        return this.leaseRenewer.updateLease(lease, concurrencyToken);
    }

    private class RenewerRunnable
    implements Runnable {
        private RenewerRunnable() {
        }

        @Override
        public void run() {
            try {
                LeaseCoordinator.this.runRenewer();
            }
            catch (LeasingException e) {
                LOG.error((Object)"LeasingException encountered in lease renewing thread", (Throwable)e);
            }
            catch (Throwable t) {
                LOG.error((Object)"Throwable encountered in lease renewing thread", t);
            }
        }
    }

    private class TakerRunnable
    implements Runnable {
        private TakerRunnable() {
        }

        @Override
        public void run() {
            try {
                LeaseCoordinator.this.runTaker();
            }
            catch (LeasingException e) {
                LOG.error((Object)"LeasingException encountered in lease taking thread", (Throwable)e);
            }
            catch (Throwable t) {
                LOG.error((Object)"Throwable encountered in lease taking thread", t);
            }
        }
    }
}

