/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.connectors.KinesisClientLibraryPipelinedRecordProcessor;

public class KinesisClientLibraryPipelinedRecordProcessorFactory
implements IRecordProcessorFactory {
    private final IRecordProcessorFactory recordProcessorFactory;
    private final int maxQueueSize;
    private final Long maxQueueWaitTimeMs;
    private final Long maxProcessRecordsWaitTimeMs;

    public KinesisClientLibraryPipelinedRecordProcessorFactory(IRecordProcessorFactory factory, int maxQueueSize) {
        this.recordProcessorFactory = factory;
        this.maxQueueSize = maxQueueSize;
        this.maxQueueWaitTimeMs = null;
        this.maxProcessRecordsWaitTimeMs = null;
    }

    public KinesisClientLibraryPipelinedRecordProcessorFactory(IRecordProcessorFactory factory, int maxQueueSize, Long maxQueueWaitTimeMs, Long maxProcessRecordsWaitTimeMs) {
        this.recordProcessorFactory = factory;
        this.maxQueueSize = maxQueueSize;
        this.maxQueueWaitTimeMs = maxQueueWaitTimeMs;
        this.maxProcessRecordsWaitTimeMs = maxProcessRecordsWaitTimeMs;
    }

    public IRecordProcessor createProcessor() {
        return new KinesisClientLibraryPipelinedRecordProcessor(this.recordProcessorFactory.createProcessor(), this.maxQueueSize, this.maxQueueWaitTimeMs, this.maxProcessRecordsWaitTimeMs);
    }
}

