/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.impl;

import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.interfaces.IBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class BasicMemoryBuffer<T>
implements IBuffer<T> {
    private final long bytesPerFlush;
    private final long numMessagesToBuffer;
    private final long millisecondsToBuffer;
    private final List<T> buffer;
    private final AtomicLong byteCount;
    private String firstSequenceNumber;
    private String lastSequenceNumber;
    private long previousFlushTimeMillisecond;

    public BasicMemoryBuffer(KinesisConnectorConfiguration configuration, List<T> buffer) {
        this.bytesPerFlush = configuration.BUFFER_BYTE_SIZE_LIMIT;
        this.numMessagesToBuffer = configuration.BUFFER_RECORD_COUNT_LIMIT;
        this.millisecondsToBuffer = configuration.BUFFER_MILLISECONDS_LIMIT;
        this.buffer = buffer;
        this.byteCount = new AtomicLong();
        this.previousFlushTimeMillisecond = this.getCurrentTimeMilliseconds();
    }

    public BasicMemoryBuffer(KinesisConnectorConfiguration configuration) {
        this(configuration, new LinkedList());
    }

    @Override
    public long getBytesToBuffer() {
        return this.bytesPerFlush;
    }

    @Override
    public long getNumRecordsToBuffer() {
        return this.numMessagesToBuffer;
    }

    @Override
    public long getMillisecondsToBuffer() {
        return this.millisecondsToBuffer;
    }

    @Override
    public void consumeRecord(T record, int recordSize, String sequenceNumber) {
        if (this.buffer.isEmpty()) {
            this.firstSequenceNumber = sequenceNumber;
        }
        this.lastSequenceNumber = sequenceNumber;
        this.buffer.add(record);
        this.byteCount.addAndGet(recordSize);
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.byteCount.set(0L);
        this.previousFlushTimeMillisecond = this.getCurrentTimeMilliseconds();
    }

    @Override
    public String getFirstSequenceNumber() {
        return this.firstSequenceNumber;
    }

    @Override
    public String getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    @Override
    public boolean shouldFlush() {
        long timelapseMillisecond = this.getCurrentTimeMilliseconds() - this.previousFlushTimeMillisecond;
        return !this.buffer.isEmpty() && ((long)this.buffer.size() >= this.getNumRecordsToBuffer() || this.byteCount.get() >= this.getBytesToBuffer() || timelapseMillisecond >= this.getMillisecondsToBuffer());
    }

    @Override
    public List<T> getRecords() {
        return this.buffer;
    }

    protected long getCurrentTimeMilliseconds() {
        return System.currentTimeMillis();
    }
}

