/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.s3;

import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.UnmodifiableBuffer;
import com.amazonaws.services.kinesis.connectors.interfaces.IEmitter;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3Emitter
implements IEmitter<byte[]> {
    private static final Log LOG = LogFactory.getLog(S3Emitter.class);
    protected final String s3Bucket;
    protected final String s3Endpoint;
    protected final AmazonS3Client s3client;

    public S3Emitter(KinesisConnectorConfiguration configuration) {
        this.s3Bucket = configuration.S3_BUCKET;
        this.s3Endpoint = configuration.S3_ENDPOINT;
        this.s3client = new AmazonS3Client(configuration.AWS_CREDENTIALS_PROVIDER);
        if (this.s3Endpoint != null) {
            this.s3client.setEndpoint(this.s3Endpoint);
        }
    }

    protected String getS3FileName(String firstSeq, String lastSeq) {
        return firstSeq + "-" + lastSeq;
    }

    protected String getS3URI(String s3FileName) {
        return "s3://" + this.s3Bucket + "/" + s3FileName;
    }

    @Override
    public List<byte[]> emit(UnmodifiableBuffer<byte[]> buffer) throws IOException {
        List<byte[]> records = buffer.getRecords();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] record : records) {
            try {
                baos.write(record);
            }
            catch (Exception e) {
                LOG.error((Object)("Error writing record to output stream. Failing this emit attempt. Record: " + Arrays.toString(record)), (Throwable)e);
                return buffer.getRecords();
            }
        }
        String s3FileName = this.getS3FileName(buffer.getFirstSequenceNumber(), buffer.getLastSequenceNumber());
        String s3URI = this.getS3URI(s3FileName);
        try {
            ByteArrayInputStream object = new ByteArrayInputStream(baos.toByteArray());
            LOG.debug((Object)("Starting upload of file " + s3URI + " to Amazon S3 containing " + records.size() + " records."));
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength((long)baos.size());
            this.s3client.putObject(this.s3Bucket, s3FileName, (InputStream)object, meta);
            LOG.info((Object)("Successfully emitted " + buffer.getRecords().size() + " records to Amazon S3 in " + s3URI));
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception when uploading file " + s3URI + "to Amazon S3. Failing this emit attempt."), (Throwable)e);
            return buffer.getRecords();
        }
    }

    @Override
    public void fail(List<byte[]> records) {
        for (byte[] record : records) {
            LOG.error((Object)("Record failed: " + Arrays.toString(record)));
        }
    }

    @Override
    public void shutdown() {
        this.s3client.shutdown();
    }
}

