/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesis.deagg;

import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class RecordDeaggregator {
    public static Void stream(Stream<KinesisEvent.KinesisEventRecord> inputStream, Consumer<UserRecord> streamConsumer) {
        LinkedList rawRecords = new LinkedList();
        inputStream.forEachOrdered(rec -> rawRecords.add(rec.getKinesis()));
        List deaggregatedRecords = UserRecord.deaggregate(rawRecords);
        deaggregatedRecords.stream().forEachOrdered(streamConsumer);
        return null;
    }

    public static Void processRecords(List<KinesisEvent.KinesisEventRecord> inputRecords, KinesisUserRecordProcessor processor) {
        LinkedList<KinesisEvent.Record> rawRecords = new LinkedList<KinesisEvent.Record>();
        for (KinesisEvent.KinesisEventRecord rec : inputRecords) {
            rawRecords.add(rec.getKinesis());
        }
        return processor.process(UserRecord.deaggregate(rawRecords));
    }

    public static List<UserRecord> deaggregate(List<KinesisEvent.KinesisEventRecord> inputRecords) {
        LinkedList<UserRecord> outputRecords = new LinkedList<UserRecord>();
        for (KinesisEvent.KinesisEventRecord inputRecord : inputRecords) {
            outputRecords.addAll(RecordDeaggregator.deaggregate(inputRecord));
        }
        return outputRecords;
    }

    public static List<UserRecord> deaggregate(KinesisEvent.KinesisEventRecord inputRecord) {
        return UserRecord.deaggregate(Arrays.asList(inputRecord.getKinesis()));
    }

    public static interface KinesisUserRecordProcessor {
        public Void process(List<UserRecord> var1);
    }
}

