/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.producer;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.producer.protobuf.Config;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _ConfigTemplate {
    private static final Logger log = LoggerFactory.getLogger(_ConfigTemplate.class);
    private List<Config.AdditionalDimension> additionalDims = new ArrayList<Config.AdditionalDimension>();
    private AWSCredentialsProvider credentialsProvider = new DefaultAWSCredentialsProviderChain();
    private AWSCredentialsProvider metricsCredentialsProvider = null;

    _ConfigTemplate() {
    }

    public void addAdditionalMetricsDimension(String key, String value, String granularity) {
        if (!Pattern.matches("global|stream|shard", granularity)) {
            throw new IllegalArgumentException("level must match the pattern global|stream|shard, got " + granularity);
        }
        this.additionalDims.add(Config.AdditionalDimension.newBuilder().setKey(key).setValue(value).setGranularity(granularity).build());
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public _ConfigTemplate setCredentialsProvider(AWSCredentialsProvider CredentialsProvider) {
        this.credentialsProvider = CredentialsProvider;
        return this;
    }

    public AWSCredentialsProvider getMetricsCredentialsProvider() {
        return this.metricsCredentialsProvider;
    }

    public _ConfigTemplate setMetricsCredentialsProvider(AWSCredentialsProvider metricsCredentialsProvider) {
        this.metricsCredentialsProvider = metricsCredentialsProvider;
        return this;
    }

    public static _ConfigTemplate fromPropertiesFile(String path) {
        log.info("Attempting to load config from file " + path);
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(path);){
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading config from properties file", e);
        }
        return _ConfigTemplate.fromProperties(props);
    }

    public static _ConfigTemplate fromProperties(Properties props) {
        _ConfigTemplate config = new _ConfigTemplate();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            boolean found = false;
            String key = propNames.nextElement().toString();
            String value = props.getProperty(key);
            for (Method method : _ConfigTemplate.class.getMethods()) {
                if (!method.getName().equals("set" + key)) continue;
                found = true;
                Class<?> type = method.getParameterTypes()[0];
                try {
                    if (type == Long.TYPE) {
                        method.invoke((Object)config, Long.valueOf(value));
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        method.invoke((Object)config, Boolean.valueOf(value));
                        continue;
                    }
                    if (type != String.class) continue;
                    method.invoke((Object)config, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Error trying to set field %s with the value '%s'", key, value), e);
                }
            }
            if (found) continue;
            log.warn("Property " + key + " ignored as there is no corresponding set method in " + _ConfigTemplate.class.getSimpleName());
        }
        return config;
    }

    protected Config.Configuration.Builder additionalConfigsToProtobuf(Config.Configuration.Builder builder) {
        return builder.addAllAdditionalMetricDims(this.additionalDims);
    }
}

