/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;

public class EBMLElementMetaData {
    private final EBMLTypeInfo typeInfo;
    private final long elementNumber;

    public boolean isMaster() {
        return this.typeInfo.getType() == EBMLTypeInfo.TYPE.MASTER;
    }

    EBMLElementMetaData(EBMLTypeInfo typeInfo, long elementNumber) {
        this.typeInfo = typeInfo;
        this.elementNumber = elementNumber;
    }

    public static EBMLElementMetaDataBuilder builder() {
        return new EBMLElementMetaDataBuilder();
    }

    public EBMLTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public long getElementNumber() {
        return this.elementNumber;
    }

    public String toString() {
        return "EBMLElementMetaData(typeInfo=" + this.getTypeInfo() + ", elementNumber=" + this.getElementNumber() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EBMLElementMetaData)) {
            return false;
        }
        EBMLElementMetaData other = (EBMLElementMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getElementNumber() != other.getElementNumber()) {
            return false;
        }
        EBMLTypeInfo this$typeInfo = this.getTypeInfo();
        EBMLTypeInfo other$typeInfo = other.getTypeInfo();
        return !(this$typeInfo == null ? other$typeInfo != null : !((Object)this$typeInfo).equals(other$typeInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EBMLElementMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $elementNumber = this.getElementNumber();
        result = result * 59 + (int)($elementNumber >>> 32 ^ $elementNumber);
        EBMLTypeInfo $typeInfo = this.getTypeInfo();
        result = result * 59 + ($typeInfo == null ? 43 : ((Object)$typeInfo).hashCode());
        return result;
    }

    public static class EBMLElementMetaDataBuilder {
        private EBMLTypeInfo typeInfo;
        private long elementNumber;

        EBMLElementMetaDataBuilder() {
        }

        public EBMLElementMetaDataBuilder typeInfo(EBMLTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public EBMLElementMetaDataBuilder elementNumber(long elementNumber) {
            this.elementNumber = elementNumber;
            return this;
        }

        public EBMLElementMetaData build() {
            return new EBMLElementMetaData(this.typeInfo, this.elementNumber);
        }

        public String toString() {
            return "EBMLElementMetaData.EBMLElementMetaDataBuilder(typeInfo=" + this.typeInfo + ", elementNumber=" + this.elementNumber + ")";
        }
    }
}

