/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.ebml;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLParserCallbacks;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfo;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLTypeInfoProvider;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLUtils;
import com.amazonaws.kinesisvideo.parser.ebml.ParserBulkByteSource;
import com.amazonaws.kinesisvideo.parser.ebml.TrackingReplayableIdAndSizeByteSource;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

class EBMLParserInternalElement {
    private final long startingOffset;
    private final long elementCount;
    ElementReadState currentElementReadState = ElementReadState.NEW;
    private int id;
    private long idNumBytes;
    private long dataSize;
    private long dataSizeNumBytes;
    private Optional<EBMLElementMetaData> elementMetaData = Optional.empty();

    public EBMLParserInternalElement(long startingOffset, long elementCount) {
        this.startingOffset = startingOffset;
        this.elementCount = elementCount;
    }

    public void readId(TrackingReplayableIdAndSizeByteSource idAndSizeByteSource) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.NEW ? 1 : 0) != 0);
        idAndSizeByteSource.setReadOffsetForReplayBuffer(this.startingOffset);
        EBMLUtils.readId(idAndSizeByteSource, this::setId);
    }

    public void readSize(TrackingReplayableIdAndSizeByteSource idAndSizeByteSource) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.ID_DONE ? 1 : 0) != 0);
        idAndSizeByteSource.setReadOffsetForReplayBuffer(this.startingOffset + this.idNumBytes);
        EBMLUtils.readSize(idAndSizeByteSource, this::setSize);
    }

    public void updateTypeInfo(EBMLTypeInfoProvider typeInfoProvider) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.SIZE_DONE ? 1 : 0) != 0);
        Optional<EBMLTypeInfo> typeInfo = typeInfoProvider.getType(this.id);
        if (typeInfo.isPresent()) {
            this.elementMetaData = Optional.of(new EBMLElementMetaData(typeInfo.get(), this.elementCount));
        }
    }

    public boolean isKnownType() {
        return this.elementMetaData.isPresent();
    }

    public EBMLTypeInfo getTypeInfo() {
        return this.elementMetaData.get().getTypeInfo();
    }

    public EBMLElementMetaData getMetadata() {
        Validate.isTrue((boolean)this.elementMetaData.isPresent(), (String)"EBML element metadata ", (Object[])new Object[0]);
        return this.elementMetaData.get();
    }

    public void startReadingContent() {
        Validate.isTrue((this.currentElementReadState == ElementReadState.SIZE_DONE ? 1 : 0) != 0);
        this.currentElementReadState = ElementReadState.CONTENT_READING;
    }

    public void startSkippingContent() {
        Validate.isTrue((this.currentElementReadState == ElementReadState.SIZE_DONE ? 1 : 0) != 0);
        this.currentElementReadState = ElementReadState.CONTENT_SKIPPING;
    }

    public void readContent(TrackingReplayableIdAndSizeByteSource idAndSizeByteSource, ParserBulkByteSource bulkByteSource, EBMLParserCallbacks callbacks, int maxContentBytesInOnePass) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.CONTENT_READING ? 1 : 0) != 0);
        long bytesToRead = this.getBytesToRead(idAndSizeByteSource, maxContentBytesInOnePass);
        if (bytesToRead > 0L) {
            callbacks.onPartialContent(this.elementMetaData.get(), bulkByteSource, (int)bytesToRead);
        }
        if (!this.isUnknownLength() && idAndSizeByteSource.getTotalBytesRead() >= this.getContentStartOffset() + this.dataSize) {
            this.currentElementReadState = ElementReadState.FINISHED;
        }
    }

    public void skipContent(TrackingReplayableIdAndSizeByteSource idAndSizeByteSource, ParserBulkByteSource bulkByteSource, ByteBuffer skipBuffer) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.CONTENT_SKIPPING ? 1 : 0) != 0);
        long bytesToRead = this.getBytesToRead(idAndSizeByteSource, skipBuffer.remaining());
        if (bytesToRead > 0L) {
            bulkByteSource.readBytes(skipBuffer, (int)bytesToRead);
        }
        if (idAndSizeByteSource.getTotalBytesRead() >= this.getContentStartOffset() + this.dataSize) {
            this.currentElementReadState = ElementReadState.FINISHED;
        }
    }

    public boolean isUnknownLength() {
        return this.dataSize == -1L;
    }

    public long endOffSet() {
        Validate.isTrue((!this.isUnknownLength() ? 1 : 0) != 0);
        return this.getContentStartOffset() + this.dataSize;
    }

    private long getContentStartOffset() {
        return this.startingOffset + this.idNumBytes + this.dataSizeNumBytes;
    }

    private void setId(int idArg, long idNumBytes) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.NEW ? 1 : 0) != 0);
        this.id = idArg;
        this.idNumBytes = idNumBytes;
        this.currentElementReadState = ElementReadState.ID_DONE;
    }

    private void setSize(long sizeArg, long sizeNumBytes) {
        Validate.isTrue((this.currentElementReadState == ElementReadState.ID_DONE ? 1 : 0) != 0);
        this.dataSize = sizeArg;
        this.dataSizeNumBytes = sizeNumBytes;
        this.currentElementReadState = ElementReadState.SIZE_DONE;
    }

    private long getBytesToRead(TrackingReplayableIdAndSizeByteSource idAndSizeByteSource, int maxContentBytesInOnePass) {
        long bytesToRead = this.dataSize + this.getContentStartOffset() - idAndSizeByteSource.getTotalBytesRead();
        bytesToRead = Math.min(bytesToRead, (long)maxContentBytesInOnePass);
        bytesToRead = Math.min(bytesToRead, (long)idAndSizeByteSource.availableForContent());
        return bytesToRead;
    }

    public String toString() {
        return "EBMLParserInternalElement(startingOffset=" + this.startingOffset + ", elementCount=" + this.getElementCount() + ", currentElementReadState=" + (Object)((Object)this.currentElementReadState) + ", id=" + this.getId() + ", idNumBytes=" + this.idNumBytes + ", dataSize=" + this.getDataSize() + ", dataSizeNumBytes=" + this.dataSizeNumBytes + ", elementMetaData=" + this.elementMetaData + ")";
    }

    public long getElementCount() {
        return this.elementCount;
    }

    public int getId() {
        return this.id;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    static enum ElementReadState {
        NEW,
        ID_DONE,
        SIZE_DONE,
        CONTENT_READING,
        CONTENT_SKIPPING,
        FINISHED;

    }
}

