/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.kinesisvideo.parser.utilities.FragmentMetadata;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.GetMediaResponseStreamConsumerFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMediaClientBuilder;
import com.amazonaws.services.kinesisvideo.model.APIName;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetMediaResult;
import com.amazonaws.services.kinesisvideo.model.StartSelector;
import com.amazonaws.services.kinesisvideo.model.StartSelectorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousGetMediaWorker
extends KinesisVideoCommon
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ContinuousGetMediaWorker.class);
    private static final int HTTP_STATUS_OK = 200;
    private final AmazonKinesisVideoMedia videoMedia;
    private final GetMediaResponseStreamConsumerFactory consumerFactory;
    private final StartSelector startSelector;
    private Optional<String> fragmentNumberToStartAfter = Optional.empty();
    private volatile AtomicBoolean shouldStop = new AtomicBoolean(false);

    private ContinuousGetMediaWorker(Regions region, AWSCredentialsProvider credentialsProvider, String streamName, StartSelector startSelector, String endPoint, GetMediaResponseStreamConsumerFactory consumerFactory) {
        super(region, credentialsProvider, streamName);
        AmazonKinesisVideoMediaClientBuilder builder = (AmazonKinesisVideoMediaClientBuilder)((AmazonKinesisVideoMediaClientBuilder)AmazonKinesisVideoMediaClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endPoint, region.getName()))).withCredentials(this.getCredentialsProvider());
        this.videoMedia = (AmazonKinesisVideoMedia)builder.build();
        this.consumerFactory = consumerFactory;
        this.startSelector = startSelector;
    }

    public static ContinuousGetMediaWorker create(Regions region, AWSCredentialsProvider credentialsProvider, String streamName, StartSelector startSelector, AmazonKinesisVideo amazonKinesisVideo, GetMediaResponseStreamConsumerFactory consumer) {
        String endPoint = amazonKinesisVideo.getDataEndpoint(new GetDataEndpointRequest().withAPIName(APIName.GET_MEDIA).withStreamName(streamName)).getDataEndpoint();
        return new ContinuousGetMediaWorker(region, credentialsProvider, streamName, startSelector, endPoint, consumer);
    }

    public void stop() {
        log.info("Stop ContinuousGetMediaWorker");
        this.shouldStop.set(true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeGetMediaResponse(GetMediaResult getMediaResult) {
        InputStream payload;
        if (getMediaResult != null && (payload = getMediaResult.getPayload()) != null) {
            try {
                payload.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void updateFragmentNumberToStartAfter(FragmentMetadata f) {
        Validate.isTrue((!this.fragmentNumberToStartAfter.isPresent() || f.getFragmentNumberString().compareTo(this.fragmentNumberToStartAfter.get()) > 0 ? 1 : 0) != 0);
        this.fragmentNumberToStartAfter = Optional.of(f.getFragmentNumberString());
    }

    private static /* synthetic */ StartSelector lambda$run$0(String fn) {
        return new StartSelector().withStartSelectorType(StartSelectorType.FRAGMENT_NUMBER).withAfterFragmentNumber(fn);
    }
}

