/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.kinesisvideo.parser.examples.ContinuousGetMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.kinesisvideo.parser.examples.PutMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.StreamOps;
import com.amazonaws.kinesisvideo.parser.utilities.consumer.MergedOutputPiperFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoClientBuilder;
import com.amazonaws.services.kinesisvideo.model.StartSelector;
import com.amazonaws.services.kinesisvideo.model.StartSelectorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisVideoGStreamerPiperExample
extends KinesisVideoCommon {
    private static final Logger log = LoggerFactory.getLogger(KinesisVideoGStreamerPiperExample.class);
    private static final String DEFAULT_PATH_TO_GSTREAMER = "/usr/bin/gst-launch-1.0";
    private static final String[] FDSRC_ARGS = new String[]{"-v", "fdsrc", "!"};
    private final AmazonKinesisVideo amazonKinesisVideo;
    private final InputStream inputStream;
    private final ExecutorService executorService;
    private PutMediaWorker putMediaWorker;
    private final StreamOps streamOps;
    private final List<String> gStreamerPipelineArguments;

    private KinesisVideoGStreamerPiperExample(Regions region, String streamName, AWSCredentialsProvider credentialsProvider, InputStream inputVideoStream, String gStreamerPipelineArgument) {
        super(region, credentialsProvider, streamName);
        AmazonKinesisVideoClientBuilder builder = AmazonKinesisVideoClientBuilder.standard();
        this.configureClient((AwsClientBuilder)builder);
        this.amazonKinesisVideo = (AmazonKinesisVideo)builder.build();
        this.inputStream = inputVideoStream;
        this.streamOps = new StreamOps(region, streamName, credentialsProvider);
        this.executorService = Executors.newFixedThreadPool(2);
        this.gStreamerPipelineArguments = new ArrayList<String>();
        this.addGStreamerPipelineArguments(gStreamerPipelineArgument);
    }

    private void addGStreamerPipelineArguments(String gStreamerPipeLineArgument) {
        this.gStreamerPipelineArguments.add(this.pathToExecutable("PATH_TO_GSTREAMER", DEFAULT_PATH_TO_GSTREAMER));
        this.addToPipelineArguments(FDSRC_ARGS);
        this.addToPipelineArguments(gStreamerPipeLineArgument.split("\\s+"));
    }

    private String pathToExecutable(String environmentVariable, String defaultPath) {
        String environmentVariableValue = System.getenv(environmentVariable);
        return StringUtils.isEmpty((CharSequence)environmentVariableValue) ? defaultPath : environmentVariableValue;
    }

    private void addToPipelineArguments(String[] pipelineArguments) {
        for (String pipelineArgument : pipelineArguments) {
            this.gStreamerPipelineArguments.add(pipelineArgument);
        }
    }

    public void execute() throws InterruptedException, IOException {
        this.streamOps.recreateStreamIfNecessary();
        ContinuousGetMediaWorker getWorker = ContinuousGetMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), new StartSelector().withStartSelectorType(StartSelectorType.EARLIEST), this.amazonKinesisVideo, new MergedOutputPiperFactory(Optional.empty(), true, this.gStreamerPipelineArguments));
        this.executorService.submit(getWorker);
        this.putMediaWorker = PutMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), this.inputStream, this.amazonKinesisVideo);
        this.executorService.submit(this.putMediaWorker);
        Thread.sleep(3000L);
        getWorker.stop();
        this.executorService.shutdown();
        this.executorService.awaitTermination(120L, TimeUnit.SECONDS);
        if (!this.executorService.isTerminated()) {
            log.warn("Shutting down executor service by force");
            this.executorService.shutdownNow();
        } else {
            log.info("Executor service is shutdown");
        }
    }

    public static KinesisVideoGStreamerPiperExampleBuilder builder() {
        return new KinesisVideoGStreamerPiperExampleBuilder();
    }

    public static class KinesisVideoGStreamerPiperExampleBuilder {
        private Regions region;
        private String streamName;
        private AWSCredentialsProvider credentialsProvider;
        private InputStream inputVideoStream;
        private String gStreamerPipelineArgument;

        KinesisVideoGStreamerPiperExampleBuilder() {
        }

        public KinesisVideoGStreamerPiperExampleBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public KinesisVideoGStreamerPiperExampleBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public KinesisVideoGStreamerPiperExampleBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public KinesisVideoGStreamerPiperExampleBuilder inputVideoStream(InputStream inputVideoStream) {
            this.inputVideoStream = inputVideoStream;
            return this;
        }

        public KinesisVideoGStreamerPiperExampleBuilder gStreamerPipelineArgument(String gStreamerPipelineArgument) {
            this.gStreamerPipelineArgument = gStreamerPipelineArgument;
            return this;
        }

        public KinesisVideoGStreamerPiperExample build() {
            return new KinesisVideoGStreamerPiperExample(this.region, this.streamName, this.credentialsProvider, this.inputVideoStream, this.gStreamerPipelineArgument);
        }

        public String toString() {
            return "KinesisVideoGStreamerPiperExample.KinesisVideoGStreamerPiperExampleBuilder(region=" + this.region + ", streamName=" + this.streamName + ", credentialsProvider=" + this.credentialsProvider + ", inputVideoStream=" + this.inputVideoStream + ", gStreamerPipelineArgument=" + this.gStreamerPipelineArgument + ")";
        }
    }
}

