/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.examples.GetMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoBoundingBoxFrameViewer;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.kinesisvideo.parser.examples.PutMediaWorker;
import com.amazonaws.kinesisvideo.parser.examples.StreamOps;
import com.amazonaws.kinesisvideo.parser.kinesis.KinesisDataStreamsWorker;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognitionInput;
import com.amazonaws.kinesisvideo.parser.rekognition.pojo.RekognizedFragmentsIndex;
import com.amazonaws.kinesisvideo.parser.rekognition.processor.RekognitionStreamProcessor;
import com.amazonaws.kinesisvideo.parser.utilities.FrameVisitor;
import com.amazonaws.kinesisvideo.parser.utilities.H264BoundingBoxFrameRenderer;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.model.StartSelector;
import com.amazonaws.services.kinesisvideo.model.StartSelectorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisVideoRekognitionIntegrationExample
extends KinesisVideoCommon {
    private static final Logger log = LoggerFactory.getLogger(KinesisVideoRekognitionIntegrationExample.class);
    private static final int DEFAULT_FRAME_WIDTH = 640;
    private static final int DEFAULT_FRAME_HEIGHT = 480;
    private static final int INITIAL_DELAY = 10000;
    private final StreamOps streamOps;
    private final InputStream inputStream;
    private final ExecutorService executorService;
    private RekognitionStreamProcessor rekognitionStreamProcessor;
    private KinesisDataStreamsWorker kinesisDataStreamsWorker;
    private GetMediaWorker getMediaWorker;
    private String kdsStreamName;
    private RekognitionInput rekognitionInput;
    private Integer rekognitionMaxTimeoutInMillis;
    private int width = 640;
    private int height = 480;
    private RekognizedFragmentsIndex rekognizedFragmentsIndex = new RekognizedFragmentsIndex();

    private KinesisVideoRekognitionIntegrationExample(Regions region, InputStream inputStream, String kvsStreamName, String kdsStreamName, RekognitionInput rekognitionInput, AWSCredentialsProvider credentialsProvider) {
        super(region, credentialsProvider, kvsStreamName);
        this.streamOps = new StreamOps(region, kvsStreamName, credentialsProvider);
        this.inputStream = inputStream;
        this.kdsStreamName = kdsStreamName;
        this.rekognitionInput = rekognitionInput;
        this.executorService = Executors.newFixedThreadPool(3);
    }

    public void execute(Long timeOutinSec) throws InterruptedException, IOException {
        this.startRekognitionProcessor();
        this.startKinesisDataStreamsWorker();
        Thread.sleep(10000L);
        this.startGetMediaWorker();
        if (this.inputStream != null) {
            this.startPutMediaWorker();
        }
        this.waitForTermination(timeOutinSec);
        this.cleanup();
    }

    private void startPutMediaWorker() {
        PutMediaWorker putMediaWorker = PutMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), this.inputStream, this.streamOps.getAmazonKinesisVideo());
        this.executorService.submit(putMediaWorker);
    }

    private void startGetMediaWorker() {
        KinesisVideoBoundingBoxFrameViewer kinesisVideoBoundingBoxFrameViewer = new KinesisVideoBoundingBoxFrameViewer(this.width, this.height);
        H264BoundingBoxFrameRenderer h264BoundingBoxFrameRenderer = H264BoundingBoxFrameRenderer.create(kinesisVideoBoundingBoxFrameViewer, this.rekognizedFragmentsIndex);
        if (this.rekognitionMaxTimeoutInMillis != null) {
            h264BoundingBoxFrameRenderer.setMaxTimeout(this.rekognitionMaxTimeoutInMillis);
        }
        FrameVisitor frameVisitor = FrameVisitor.create(h264BoundingBoxFrameRenderer);
        this.getMediaWorker = GetMediaWorker.create(this.getRegion(), this.getCredentialsProvider(), this.getStreamName(), new StartSelector().withStartSelectorType(StartSelectorType.NOW), this.streamOps.getAmazonKinesisVideo(), frameVisitor);
        this.executorService.submit(this.getMediaWorker);
    }

    private void startRekognitionProcessor() {
        this.rekognitionStreamProcessor = RekognitionStreamProcessor.create(this.getRegion(), this.getCredentialsProvider(), this.rekognitionInput);
        this.rekognitionStreamProcessor.process();
    }

    private void startKinesisDataStreamsWorker() {
        this.kinesisDataStreamsWorker = KinesisDataStreamsWorker.create(this.getRegion(), this.getCredentialsProvider(), this.kdsStreamName, this.rekognizedFragmentsIndex);
        this.executorService.submit(this.kinesisDataStreamsWorker);
    }

    private void waitForTermination(Long timeOutinSec) throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(timeOutinSec, TimeUnit.SECONDS);
    }

    private void cleanup() {
        if (!this.executorService.isTerminated()) {
            log.warn("Shutting down executor service by force");
            this.executorService.shutdownNow();
        } else {
            log.info("Executor service is shutdown");
        }
        this.rekognitionStreamProcessor.stopStreamProcessor();
    }

    public static KinesisVideoRekognitionIntegrationExampleBuilder builder() {
        return new KinesisVideoRekognitionIntegrationExampleBuilder();
    }

    public void setRekognitionMaxTimeoutInMillis(Integer rekognitionMaxTimeoutInMillis) {
        this.rekognitionMaxTimeoutInMillis = rekognitionMaxTimeoutInMillis;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public static class KinesisVideoRekognitionIntegrationExampleBuilder {
        private Regions region;
        private InputStream inputStream;
        private String kvsStreamName;
        private String kdsStreamName;
        private RekognitionInput rekognitionInput;
        private AWSCredentialsProvider credentialsProvider;

        KinesisVideoRekognitionIntegrationExampleBuilder() {
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder region(Regions region) {
            this.region = region;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder kvsStreamName(String kvsStreamName) {
            this.kvsStreamName = kvsStreamName;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder kdsStreamName(String kdsStreamName) {
            this.kdsStreamName = kdsStreamName;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder rekognitionInput(RekognitionInput rekognitionInput) {
            this.rekognitionInput = rekognitionInput;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExampleBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public KinesisVideoRekognitionIntegrationExample build() {
            return new KinesisVideoRekognitionIntegrationExample(this.region, this.inputStream, this.kvsStreamName, this.kdsStreamName, this.rekognitionInput, this.credentialsProvider);
        }

        public String toString() {
            return "KinesisVideoRekognitionIntegrationExample.KinesisVideoRekognitionIntegrationExampleBuilder(region=" + this.region + ", inputStream=" + this.inputStream + ", kvsStreamName=" + this.kvsStreamName + ", kdsStreamName=" + this.kdsStreamName + ", rekognitionInput=" + this.rekognitionInput + ", credentialsProvider=" + this.credentialsProvider + ")";
        }
    }
}

