/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaClient;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaClientBuilder;
import com.amazonaws.services.kinesisvideo.model.APIName;
import com.amazonaws.services.kinesisvideo.model.Fragment;
import com.amazonaws.services.kinesisvideo.model.FragmentSelector;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsRequest;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFragmentWorker
extends KinesisVideoCommon
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(ListFragmentWorker.class);
    private final FragmentSelector fragmentSelector;
    private final AmazonKinesisVideoArchivedMedia amazonKinesisVideoArchivedMedia;
    private final long fragmentsPerRequest = 100L;

    public ListFragmentWorker(String streamName, AWSCredentialsProvider awsCredentialsProvider, String endPoint, Regions region, FragmentSelector fragmentSelector) {
        super(region, awsCredentialsProvider, streamName);
        this.fragmentSelector = fragmentSelector;
        this.amazonKinesisVideoArchivedMedia = (AmazonKinesisVideoArchivedMedia)((AmazonKinesisVideoArchivedMediaClientBuilder)((AmazonKinesisVideoArchivedMediaClientBuilder)AmazonKinesisVideoArchivedMediaClient.builder().withCredentials(awsCredentialsProvider)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endPoint, region.getName()))).build();
    }

    public static ListFragmentWorker create(String streamName, AWSCredentialsProvider awsCredentialsProvider, Regions region, AmazonKinesisVideo amazonKinesisVideo, FragmentSelector fragmentSelector) {
        GetDataEndpointRequest request = new GetDataEndpointRequest().withAPIName(APIName.LIST_FRAGMENTS).withStreamName(streamName);
        String endpoint = amazonKinesisVideo.getDataEndpoint(request).getDataEndpoint();
        return new ListFragmentWorker(streamName, awsCredentialsProvider, endpoint, region, fragmentSelector);
    }

    public List<String> call() {
        ArrayList<String> fragmentNumbers = new ArrayList<String>();
        try {
            log.info("Start ListFragment worker on stream {}", (Object)this.streamName);
            ListFragmentsRequest request = new ListFragmentsRequest().withStreamName(this.streamName).withFragmentSelector(this.fragmentSelector).withMaxResults(Long.valueOf(100L));
            ListFragmentsResult result = this.amazonKinesisVideoArchivedMedia.listFragments(request);
            log.info("List Fragments called on stream {} response {} request ID {}", new Object[]{this.streamName, result.getSdkHttpMetadata().getHttpStatusCode(), result.getSdkResponseMetadata().getRequestId()});
            for (Fragment f : result.getFragments()) {
                fragmentNumbers.add(f.getFragmentNumber());
            }
            String nextToken = result.getNextToken();
            while (nextToken != null) {
                request = new ListFragmentsRequest().withStreamName(this.streamName).withNextToken(nextToken);
                result = this.amazonKinesisVideoArchivedMedia.listFragments(request);
                for (String f : result.getFragments()) {
                    fragmentNumbers.add(f.getFragmentNumber());
                }
                nextToken = result.getNextToken();
            }
            Collections.sort(fragmentNumbers);
            for (String f : fragmentNumbers) {
                log.info("Retrieved fragment number {} ", (Object)f);
            }
        }
        catch (Throwable t) {
            log.error("Failure in ListFragmentWorker for streamName {} {}", (Object)this.streamName, (Object)t.toString());
            throw t;
        }
        finally {
            log.info("Retrieved {} Fragments and exiting ListFragmentWorker for stream {}", (Object)fragmentNumbers.size(), (Object)this.streamName);
            return fragmentNumbers;
        }
    }
}

