/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.examples.KinesisVideoCommon;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideo;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMediaClient;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMediaClientBuilder;
import com.amazonaws.services.kinesisvideo.PutMediaAckResponseHandler;
import com.amazonaws.services.kinesisvideo.model.APIName;
import com.amazonaws.services.kinesisvideo.model.AckEvent;
import com.amazonaws.services.kinesisvideo.model.AckEventType;
import com.amazonaws.services.kinesisvideo.model.FragmentTimecodeType;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.PutMediaRequest;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutMediaWorker
extends KinesisVideoCommon
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PutMediaWorker.class);
    private final InputStream inputStream;
    private final AmazonKinesisVideoPutMedia putMedia;
    private long numFragmentsPersisted = 0L;

    private PutMediaWorker(Regions region, AWSCredentialsProvider credentialsProvider, String streamName, InputStream inputStream, String endPoint) {
        super(region, credentialsProvider, streamName);
        this.inputStream = inputStream;
        AmazonKinesisVideoPutMediaClientBuilder builder = AmazonKinesisVideoPutMediaClient.builder().withEndpoint(endPoint);
        this.conifgurePutMediaClient(builder);
        this.putMedia = builder.build();
    }

    public static PutMediaWorker create(Regions region, AWSCredentialsProvider credentialsProvider, String streamName, InputStream inputStream, AmazonKinesisVideo amazonKinesisVideo) {
        String endPoint = amazonKinesisVideo.getDataEndpoint(new GetDataEndpointRequest().withAPIName(APIName.PUT_MEDIA).withStreamName(streamName)).getDataEndpoint();
        return new PutMediaWorker(region, credentialsProvider, streamName, inputStream, endPoint);
    }

    @Override
    public void run() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.putMedia.putMedia(new PutMediaRequest().withStreamName(this.streamName).withFragmentTimecodeType(FragmentTimecodeType.RELATIVE).withProducerStartTimestamp(new Date()).withPayload(this.inputStream), new PutMediaAckResponseHandler(){

            public void onAckEvent(AckEvent event) {
                log.info("PutMedia Ack for stream {}: {} ", (Object)PutMediaWorker.this.streamName, (Object)event.toString());
                if (AckEventType.Values.PERSISTED.equals((Object)event.getAckEventType().getEnumValue())) {
                    PutMediaWorker.this.numFragmentsPersisted++;
                }
            }

            public void onFailure(Throwable t) {
                log.error("PutMedia for {} has suffered error {}", (Object)PutMediaWorker.this.streamName, (Object)t);
                latch.countDown();
            }

            public void onComplete() {
                log.info("PutMedia for {} is complete ", (Object)PutMediaWorker.this.streamName);
                latch.countDown();
            }
        });
        log.info("Made PutMedia call for stream {}", (Object)this.streamName);
        try {
            latch.await();
            log.info("PutMedia worker exiting for stream {} number of fragments persisted {} ", (Object)this.streamName, (Object)this.numFragmentsPersisted);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failure while waiting for PutMedia to finish", e);
        }
        finally {
            this.putMedia.close();
        }
    }

    public long getNumFragmentsPersisted() {
        return this.numFragmentsPersisted;
    }
}

