/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples.lambda;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.parser.examples.lambda.FragmentCheckpoint;
import com.amazonaws.kinesisvideo.parser.examples.lambda.FragmentCheckpointManager;
import com.amazonaws.kinesisvideo.parser.utilities.DynamoDBHelper;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDBBasedFragmentCheckpointManager
implements FragmentCheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(DDBBasedFragmentCheckpointManager.class);
    private static final String TABLE_NAME = "FragmentCheckpoint";
    private static final String KVS_STREAM_NAME = "KVSStreamName";
    private static final String FRAGMENT_NUMBER = "FragmentNumber";
    private static final String SERVER_TIME = "ServerTime";
    private static final String PRODUCER_TIME = "ProducerTime";
    private static final String UPDATED_TIME = "UpdatedTime";
    private final DynamoDBHelper dynamoDBHelper;

    public DDBBasedFragmentCheckpointManager(Regions region, AWSCredentialsProvider credentialsProvider) {
        this.dynamoDBHelper = new DynamoDBHelper(region, credentialsProvider);
        this.dynamoDBHelper.createTableIfDoesntExist();
    }

    @Override
    public Optional<FragmentCheckpoint> getLastProcessedItem(String streamName) {
        Map<String, AttributeValue> result = this.dynamoDBHelper.getItem(streamName);
        if (result != null && result.containsKey(FRAGMENT_NUMBER)) {
            return Optional.of(new FragmentCheckpoint(streamName, result.get(FRAGMENT_NUMBER).getS(), Long.parseLong(result.get(PRODUCER_TIME).getN()), Long.parseLong(result.get(SERVER_TIME).getN()), Long.parseLong(result.get(UPDATED_TIME).getN())));
        }
        return Optional.empty();
    }

    @Override
    public void saveCheckPoint(String streamName, String fragmentNumber, Long producerTime, Long serverTime) {
        if (fragmentNumber != null) {
            if (this.dynamoDBHelper.getItem(streamName) != null) {
                log.info("Checkpoint for stream name {} already exists. So updating checkpoint with fragment number: {}", (Object)streamName, (Object)fragmentNumber);
                this.dynamoDBHelper.updateItem(streamName, fragmentNumber, producerTime, serverTime, System.currentTimeMillis());
            } else {
                log.info("Creating checkpoint for stream name {} with fragment number: {}", (Object)streamName, (Object)fragmentNumber);
                this.dynamoDBHelper.putItem(streamName, fragmentNumber, producerTime, serverTime, System.currentTimeMillis());
            }
        } else {
            log.info("Fragment number is null. Skipping save checkpoint...");
        }
    }
}

