/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.examples.lambda;

import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.client.mediasource.MediaSourceState;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceSink;
import com.amazonaws.kinesisvideo.parser.examples.lambda.EncodedFrame;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.kinesisvideo.producer.StreamCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVSMediaSource
implements MediaSource {
    private static final Logger log = LoggerFactory.getLogger(KVSMediaSource.class);
    private static final int FRAME_FLAG_KEY_FRAME = 1;
    private static final int FRAME_FLAG_NONE = 0;
    private static final long HUNDREDS_OF_NANOS_IN_MS = 10000L;
    private static final long FRAME_DURATION_20_MS = 20L;
    private CameraMediaSourceConfiguration cameraMediaSourceConfiguration;
    private MediaSourceState mediaSourceState;
    private MediaSourceSink mediaSourceSink;
    private int frameIndex;
    private final StreamInfo streamInfo;

    private void putFrame(KinesisVideoFrame kinesisVideoFrame) {
        try {
            this.mediaSourceSink.onFrame(kinesisVideoFrame);
        }
        catch (KinesisVideoException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MediaSourceState getMediaSourceState() {
        return this.mediaSourceState;
    }

    public MediaSourceConfiguration getConfiguration() {
        return this.cameraMediaSourceConfiguration;
    }

    public StreamInfo getStreamInfo() throws KinesisVideoException {
        return this.streamInfo;
    }

    public void initialize(MediaSourceSink mediaSourceSink) {
        this.mediaSourceSink = mediaSourceSink;
    }

    public void configure(MediaSourceConfiguration configuration) {
        if (!(configuration instanceof CameraMediaSourceConfiguration)) {
            throw new IllegalStateException("Configuration must be an instance of CameraMediaSourceConfiguration");
        }
        this.cameraMediaSourceConfiguration = (CameraMediaSourceConfiguration)configuration;
        this.frameIndex = 0;
    }

    public void start() {
        this.mediaSourceState = MediaSourceState.RUNNING;
    }

    public void putFrameData(EncodedFrame encodedFrame) {
        int flags;
        int n = flags = encodedFrame.isKeyFrame() ? 1 : 0;
        if (encodedFrame.getByteBuffer() != null) {
            KinesisVideoFrame frame;
            if ((frame = new KinesisVideoFrame(this.frameIndex++, flags, encodedFrame.getTimeCode() * 10000L, encodedFrame.getTimeCode() * 10000L, 200000L, encodedFrame.getByteBuffer())).getSize() == 0) {
                return;
            }
            this.putFrame(frame);
        } else {
            log.info("Frame Data is null !");
        }
    }

    public void stop() {
        this.mediaSourceState = MediaSourceState.STOPPED;
    }

    public boolean isStopped() {
        return this.mediaSourceState == MediaSourceState.STOPPED;
    }

    public void free() {
    }

    public MediaSourceSink getMediaSourceSink() {
        return this.mediaSourceSink;
    }

    @Nullable
    public StreamCallbacks getStreamCallbacks() {
        return null;
    }

    public KVSMediaSource(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }
}

