/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.parser.mkv;

import com.amazonaws.kinesisvideo.parser.ebml.EBMLElementMetaData;
import com.amazonaws.kinesisvideo.parser.ebml.EBMLUtils;
import com.amazonaws.kinesisvideo.parser.ebml.MkvTypeInfos;
import com.amazonaws.kinesisvideo.parser.mkv.Frame;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElement;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitException;
import com.amazonaws.kinesisvideo.parser.mkv.MkvElementVisitor;
import com.amazonaws.kinesisvideo.parser.mkv.MkvValue;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkvDataElement
extends MkvElement {
    private static final Logger log = LoggerFactory.getLogger(MkvDataElement.class);
    private static final int DATE_SIZE = 8;
    private static final Instant DATE_BASE_INSTANT = Instant.ofEpochSecond(978307200L);
    private final long dataSize;
    private final ByteBuffer idAndSizeRawBytes;
    private ByteBuffer dataBuffer;
    private MkvValue valueCopy;

    private MkvDataElement(EBMLElementMetaData elementMetaData, List<EBMLElementMetaData> elementPath, ByteBuffer idAndSizeRawBytes, long dataSize, ByteBuffer dataBuffer) {
        super(elementMetaData, elementPath);
        this.dataSize = dataSize;
        this.dataBuffer = dataBuffer;
        this.idAndSizeRawBytes = idAndSizeRawBytes;
    }

    public MkvValue getValueCopy() {
        if (this.valueCopy == null) {
            this.createValueByCopyingBytes();
        }
        return this.valueCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createValueByCopyingBytes() {
        this.dataBuffer.rewind();
        try {
            switch (this.elementMetaData.getTypeInfo().getType()) {
                case INTEGER: {
                    this.valueCopy = new MkvValue<Long>(EBMLUtils.readDataSignedInteger(this.dataBuffer, this.dataSize), this.dataSize);
                    return;
                }
                case UINTEGER: {
                    BigInteger unsignedValue = EBMLUtils.readDataUnsignedInteger(this.dataBuffer, this.dataSize);
                    if (unsignedValue.signum() < 0) {
                        log.error("Uinteger has negative value {} ", (Object)unsignedValue);
                    }
                    this.valueCopy = new MkvValue<BigInteger>(unsignedValue, this.dataSize);
                    return;
                }
                case FLOAT: {
                    Validate.isTrue((this.dataSize == 4L || this.dataSize == 8L ? 1 : 0) != 0, (String)("Invalid size for float type" + this.dataSize), (Object[])new Object[0]);
                    if (this.dataSize == 4L) {
                        this.valueCopy = new MkvValue<Float>(Float.valueOf(this.dataBuffer.getFloat()), 4L);
                        return;
                    } else {
                        this.valueCopy = new MkvValue<Double>(this.dataBuffer.getDouble(), 8L);
                        return;
                    }
                }
                case STRING: {
                    this.valueCopy = new MkvValue<String>(StandardCharsets.US_ASCII.decode(this.dataBuffer).toString(), this.dataSize);
                    return;
                }
                case UTF_8: {
                    this.valueCopy = new MkvValue<String>(StandardCharsets.UTF_8.decode(this.dataBuffer).toString(), this.dataSize);
                    return;
                }
                case DATE: {
                    Validate.isTrue((this.dataSize == 8L ? 1 : 0) != 0, (String)("Date element size can only be 8 bytes not " + this.dataSize), (Object[])new Object[0]);
                    long dateLongValue = EBMLUtils.readDataSignedInteger(this.dataBuffer, 8L);
                    this.valueCopy = new MkvValue<Instant>(DATE_BASE_INSTANT.plusNanos(dateLongValue), this.dataSize);
                    return;
                }
                case BINARY: {
                    if (this.elementMetaData.getTypeInfo().equals(MkvTypeInfos.SIMPLEBLOCK)) {
                        Frame frame = Frame.withCopy(this.dataBuffer);
                        this.valueCopy = new MkvValue<Frame>(frame, this.dataSize);
                        return;
                    } else {
                        ByteBuffer buffer = ByteBuffer.allocate((int)this.dataSize);
                        this.dataBuffer.get(buffer.array(), 0, (int)this.dataSize);
                        this.valueCopy = new MkvValue<ByteBuffer>(buffer, this.dataSize);
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Cannot have value for ebml element type " + (Object)((Object)this.elementMetaData.getTypeInfo().getType()));
                }
            }
        }
        finally {
            this.dataBuffer.rewind();
        }
    }

    @Override
    public boolean isMaster() {
        return false;
    }

    @Override
    public void accept(MkvElementVisitor visitor) throws MkvElementVisitException {
        visitor.visit(this);
    }

    @Override
    public boolean equivalent(MkvElement other) {
        if (!this.typeEquals(other)) {
            return false;
        }
        MkvDataElement otherDataElement = (MkvDataElement)other;
        return this.dataSize == otherDataElement.dataSize && this.valueCopy.equals(otherDataElement.valueCopy);
    }

    @Override
    public void writeToChannel(WritableByteChannel outputChannel) throws MkvElementVisitException {
        this.writeByteBufferToChannel(this.idAndSizeRawBytes, outputChannel);
        this.writeByteBufferToChannel(this.dataBuffer, outputChannel);
    }

    public int getIdAndSizeRawBytesLength() {
        return this.idAndSizeRawBytes.limit();
    }

    public int getDataBufferSize() {
        if (this.dataBuffer == null) {
            return 0;
        }
        return this.dataBuffer.limit();
    }

    void clearDataBuffer() {
        this.dataBuffer = null;
    }

    public static MkvDataElementBuilder builder() {
        return new MkvDataElementBuilder();
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public ByteBuffer getIdAndSizeRawBytes() {
        return this.idAndSizeRawBytes;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public String toString() {
        return "MkvDataElement(super=" + super.toString() + ", dataSize=" + this.getDataSize() + ")";
    }

    public static class MkvDataElementBuilder {
        private EBMLElementMetaData elementMetaData;
        private List<EBMLElementMetaData> elementPath;
        private ByteBuffer idAndSizeRawBytes;
        private long dataSize;
        private ByteBuffer dataBuffer;

        MkvDataElementBuilder() {
        }

        public MkvDataElementBuilder elementMetaData(EBMLElementMetaData elementMetaData) {
            this.elementMetaData = elementMetaData;
            return this;
        }

        public MkvDataElementBuilder elementPath(List<EBMLElementMetaData> elementPath) {
            this.elementPath = elementPath;
            return this;
        }

        public MkvDataElementBuilder idAndSizeRawBytes(ByteBuffer idAndSizeRawBytes) {
            this.idAndSizeRawBytes = idAndSizeRawBytes;
            return this;
        }

        public MkvDataElementBuilder dataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public MkvDataElementBuilder dataBuffer(ByteBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        public MkvDataElement build() {
            return new MkvDataElement(this.elementMetaData, this.elementPath, this.idAndSizeRawBytes, this.dataSize, this.dataBuffer);
        }

        public String toString() {
            return "MkvDataElement.MkvDataElementBuilder(elementMetaData=" + this.elementMetaData + ", elementPath=" + this.elementPath + ", idAndSizeRawBytes=" + this.idAndSizeRawBytes + ", dataSize=" + this.dataSize + ", dataBuffer=" + this.dataBuffer + ")";
        }
    }
}

